/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.AopType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.DoNextEvent;
import com.hotent.bpm.api.event.DoNextModel;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserGroupService;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DefaultBpmTaskService
implements BpmTaskService {
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;

    @Override
    public List<BpmTask> getChildsByTaskId(String taskId) {
        return this.convert(this.bpmTaskManager.getChildsByTaskId(taskId));
    }

    @Override
    public List<BpmTask> getTasksByUserId(String userId) {
        return this.convert(this.bpmTaskManager.getByUserId(userId).getRows());
    }

    @Override
    public List<BpmTask> getTasksByUserId(String userId, PageBean page) {
        return this.convert(this.bpmTaskManager.getByUserId(userId, page).getRows());
    }

    @Override
    public List<BpmTask> getTasksByUserId(String userId, QueryFilter filter) {
        List list = this.bpmTaskManager.getByUserId(userId, (QueryFilter<DefaultBpmTask>)filter).getRows();
        return list;
    }

    @Override
    public List<BpmTask> getAllTasks(QueryFilter filter) {
        List list = (List)this.bpmTaskManager.query(filter);
        return list;
    }

    @Override
    public BpmTask getByTaskId(String taskId) {
        return (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
    }

    @Override
    public List<BpmTask> getTasksInstId(String instId) {
        return this.convert(this.bpmTaskManager.getByInstId(instId));
    }

    @Override
    public List<BpmTask> getTaskByInstUser(String instId, String userId) {
        return this.convert(this.bpmTaskManager.getByInstUser(instId, userId));
    }

    @Override
    public boolean canAccessTask(String taskId, String userId) {
        return this.bpmTaskManager.canAccessTask(taskId, userId);
    }

    private BpmTask convert(DefaultBpmTask defaultBpmTask) {
        DefaultBpmTask bpmTask = defaultBpmTask;
        return bpmTask;
    }

    private List<BpmTask> convert(List<DefaultBpmTask> defaultBpmTasks) {
        ArrayList<BpmTask> bpmTasks = new ArrayList<BpmTask>();
        for (DefaultBpmTask defaultBpmTask : defaultBpmTasks) {
            bpmTasks.add(this.convert(defaultBpmTask));
        }
        return bpmTasks;
    }

    @Override
    public void lockTask(String taskId, String userId) {
        this.bpmTaskManager.lockTask(taskId, userId);
    }

    @Override
    public void unlockTask(String taskId, String userId) {
        this.bpmTaskManager.unLockTask(taskId, userId);
    }

    @Override
    public void assigTask(String taskId, String assigneeId) {
        this.bpmTaskManager.assignTask(taskId, assigneeId);
    }

    @Override
    @Transactional
    public void addCandidateUsers(String taskId, String[] userIds) {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (bpmTask == null) {
            return;
        }
        for (String userId : userIds) {
            DefaultBpmTaskCandidate tmp = this.bpmTaskCandidateManager.getByTaskIdExeIdType(taskId, userId, "user");
            if (tmp != null) continue;
            DefaultBpmTaskCandidate candidate = new DefaultBpmTaskCandidate();
            candidate.setId(UniqueIdUtil.getSuid());
            candidate.setExecutor(userId);
            candidate.setType("user");
            candidate.setTaskId(bpmTask.getTaskId());
            candidate.setProcInstId(bpmTask.getProcInstId());
            this.bpmTaskCandidateManager.create((Model)candidate);
        }
    }

    @Override
    @Transactional
    public void addCandidates(String taskId, List<BpmIdentity> candidates) {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (bpmTask == null) {
            return;
        }
        for (BpmIdentity identity : candidates) {
            String type;
            String executorId = identity.getId();
            DefaultBpmTaskCandidate tmp = this.bpmTaskCandidateManager.getByTaskIdExeIdType(taskId, executorId, type = "user".equals(identity.getType()) ? "user" : identity.getGroupType());
            if (tmp != null) continue;
            DefaultBpmTaskCandidate candidate = new DefaultBpmTaskCandidate();
            candidate.setId(UniqueIdUtil.getSuid());
            candidate.setExecutor(executorId);
            candidate.setType(type);
            candidate.setTaskId(bpmTask.getTaskId());
            candidate.setProcInstId(bpmTask.getProcInstId());
            this.bpmTaskCandidateManager.create((Model)candidate);
        }
    }

    @Override
    public void setTaskSkip(BpmTask bpmTask) throws Exception {
        BpmUtil.setTaskSkip(bpmTask);
    }

    @Override
    public List<BpmIdentity> getTaskCandidates(String taskId) {
        ArrayList<BpmIdentity> bpmIdentites = new ArrayList<BpmIdentity>();
        List<DefaultBpmTaskCandidate> candidateList = this.bpmTaskCandidateManager.queryByTaskId(taskId);
        for (DefaultBpmTaskCandidate candiate : candidateList) {
            DefaultBpmIdentity bpmId = new DefaultBpmIdentity();
            if ("user".equals(candiate.getType())) {
                bpmId.setType("user");
                String executor = candiate.getExecutor();
                IUser user = this.userServiceImpl.getUserById(executor);
                Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)String.format("\u672a\u83b7\u53d6\u5230id\u4e3a\uff1a%s\u7684\u7528\u6237", executor));
                bpmId.setName(user.getFullname());
            } else {
                bpmId.setType("group");
                bpmId.setGroupType(candiate.getType());
                IGroup group = this.defaultUserGroupService.getGroupByIdOrCode(candiate.getType(), candiate.getExecutor());
                bpmId.setName(group == null ? "" : group.getName());
            }
            bpmId.setId(candiate.getExecutor());
            bpmIdentites.add(bpmId);
        }
        return bpmIdentites;
    }

    @Override
    public List<IUser> getUsersByTaskId(String taskId) {
        ArrayList<IUser> userList = new ArrayList<IUser>();
        if (StringUtil.isEmpty((String)taskId)) {
            return userList;
        }
        BpmTask task = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            return userList;
        }
        if (StringUtil.isNotZeroEmpty((String)task.getAssigneeId())) {
            IUser user = this.userServiceImpl.getUserById(task.getAssigneeId());
            userList.add(user);
        } else {
            List<BpmIdentity> identities = this.getTaskCandidates(task.getId());
            List<IUser> users = this.bpmIdentityExtractService.extractUser(identities);
            userList.addAll(users);
        }
        return userList;
    }

    @Override
    public void saveDraft(TaskFinishCmd cmd) {
        ContextThreadUtil.setActionCmd(cmd);
        DoNextModel donextModel = new DoNextModel(cmd, AopType.PREVIOUS);
        DoNextEvent donextEv = new DoNextEvent(donextModel);
        AppUtil.publishEvent((ApplicationEvent)donextEv);
    }

    @Override
    public void setTaskExecutors(String taskId, String[] userIds, String notifyType, String opinion) throws Exception {
        this.bpmTaskManager.setTaskExecutors(taskId, userIds, notifyType, opinion);
    }

    @Override
    public int canLockTask(String taskId) {
        return this.bpmTaskManager.canLockTask(taskId);
    }
}

