/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.IGlobalRestfulPluginDef;
import com.hotent.bpm.api.model.process.def.Restful;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginFactory;
import com.hotent.bpm.api.plugin.core.runtime.BpmExecutionPlugin;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.RestfulService;
import com.hotent.bpm.api.service.TaskCommuService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmCommuReceiverManager;
import com.hotent.bpm.persistence.manager.BpmDefDataManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCommuManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.model.BpmCommuReceiver;
import com.hotent.bpm.persistence.model.BpmTaskCommu;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DefaultTaskCommuService
implements TaskCommuService {
    @Resource
    BpmTaskCommuManager bpmTaskCommuManager;
    @Resource
    BpmCommuReceiverManager bpmCommuReceiverManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmPluginFactory bpmPluginFactory;
    @Resource
    RestfulService restfulService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceMapper;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmDefDataManager bpmDefDataManager;

    private BpmTaskCommu getByTasknew(String instId, String opinion) {
        IUser user = ContextUtil.getCurrentUser();
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByInstId(instId);
        if (taskCommu != null) {
            return taskCommu;
        }
        taskCommu = new BpmTaskCommu();
        taskCommu.setId(UniqueIdUtil.getSuid());
        taskCommu.setInstanceId(instId);
        taskCommu.setNodeName("\u6c9f\u901a\u4efb\u52a1");
        taskCommu.setSenderId(user.getUserId());
        taskCommu.setSender(user.getFullname());
        taskCommu.setCreatetime(LocalDateTime.now());
        taskCommu.setOpinion(opinion);
        this.bpmTaskCommuManager.create((Model)taskCommu);
        return taskCommu;
    }

    @Override
    @Transactional
    public void addCommuTask(String instId, String notifyType, String opinion, List<IUser> users, String files, String defId, String nodeId, String formData, String taskId, String parentId) throws Exception {
        Object latestOrHistory;
        DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceMapper.get((Serializable)((Object)instId));
        BpmTaskCommu commu = this.getByTasknew(instId, opinion);
        String commuId = commu.getId();
        String addTranCheckOpinionId = this.addTranCheckOpinion(processInstance, OpinionStatus.START_COMMU, ContextUtil.getCurrentUserId(), opinion, files, formData, taskId);
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        String name = "\u6c9f\u901a\u4efb\u52a1";
        if (!StringUtils.isEmpty((Object)instId) && !StringUtils.isEmpty((Object)nodeId)) {
            List<DefaultBpmCheckOpinion> taskList = this.bpmCheckOpinionManager.getByInstNodeId(instId, nodeId);
            if (!CollectionUtils.isEmpty(taskList) && taskList.get(0) != null) {
                name = taskList.get(0).getTaskName();
            }
        } else if (!StringUtils.isEmpty((Object)instId) && StringUtils.isEmpty((Object)nodeId) && (latestOrHistory = this.bpmCheckOpinionManager.getLatestOrHistoryBpmCheckOpinionByInstId(instId)) != null) {
            nodeId = ((DefaultBpmCheckOpinion)latestOrHistory).getTaskKey();
            name = ((DefaultBpmCheckOpinion)latestOrHistory).getTaskName();
        }
        for (IUser user : users) {
            BpmCommuReceiver receiver = this.getCommuReceiver(commuId, user);
            this.bpmCommuReceiverManager.create((Model)receiver);
            String opinionId = this.addTranCheckOpinion(processInstance, OpinionStatus.AWAITING_FEEDBACK, user.getUserId(), "", "", "", taskId);
            BpmTaskNotice notice = new BpmTaskNotice();
            if (StringUtil.isNotEmpty((String)nodeId)) {
                notice.setNodeId(nodeId);
            }
            notice.setStatus(TaskType.COMMU.getKey());
            notice.setId(UniqueIdUtil.getSuid());
            notice.setName(name);
            notice.setProcInstId(instId);
            notice.setAssigneeId(user.getUserId());
            notice.setAssigneeName(user.getFullname());
            notice.setOwnerId(ContextUtil.getCurrentUserId());
            notice.setOwnerName(ContextUtil.getCurrentUser().getFullname());
            notice.setSubject(processInstance.getSubject());
            notice.setProcDefId(processInstance.getProcDefId());
            notice.setProcDefKey(processInstance.getProcDefKey());
            notice.setProcDefName(processInstance.getProcDefName());
            notice.setSupportMobile(processInstance.getSupportMobile());
            notice.setOpinionId(addTranCheckOpinionId);
            notice.setTaskId(opinionId);
            notice.setParentId(parentId);
            noticeManager.create((Model)notice);
            TodoPushUtil.addCopyToToPortal(notice);
        }
        String messageType = BpmUtil.getNotifyType(processInstance, nodeId);
        MessageUtil.sendMsg("bpmCommuSend", messageType, users, processInstance, opinion);
    }

    private BpmCommuReceiver getCommuReceiver(String commuId, IUser user) {
        BpmCommuReceiver receiver = new BpmCommuReceiver();
        receiver.setId(UniqueIdUtil.getSuid());
        receiver.setCommuId(commuId);
        receiver.setReceiver(user.getFullname());
        receiver.setReceiverId(user.getUserId());
        receiver.setStatus(BpmCommuReceiver.COMMU_NO);
        return receiver;
    }

    private BpmTaskCommu getByTask(DefaultBpmTask task, String opinion) {
        IUser user = ContextUtil.getCurrentUser();
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByTaskId(task.getId());
        if (taskCommu != null) {
            return taskCommu;
        }
        taskCommu = new BpmTaskCommu();
        taskCommu.setId(UniqueIdUtil.getSuid());
        taskCommu.setInstanceId(task.getProcInstId());
        taskCommu.setNodeId(task.getNodeId());
        taskCommu.setNodeName(task.getName());
        taskCommu.setTaskId(task.getId());
        taskCommu.setSenderId(user.getUserId());
        taskCommu.setSender(user.getFullname());
        taskCommu.setCreatetime(LocalDateTime.now());
        taskCommu.setOpinion(opinion);
        this.bpmTaskCommuManager.create((Model)taskCommu);
        return taskCommu;
    }

    @Override
    @Transactional
    public void completeTask(String taskId, String notifyType, String opinion) throws Exception {
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByTaskId(defaultBpmTask.getParentId());
        BpmCommuReceiver commuReceiver = this.bpmCommuReceiverManager.getByCommuUser(taskCommu.getId(), defaultBpmTask.getAssigneeId());
        commuReceiver.setStatus(BpmCommuReceiver.COMMU_FEEDBACK);
        if (commuReceiver.getReceiveTime() == null) {
            commuReceiver.setReceiveTime(LocalDateTime.now());
        }
        commuReceiver.setFeedbackTime(LocalDateTime.now());
        commuReceiver.setOpinion(opinion);
        this.bpmCommuReceiverManager.update((Model)commuReceiver);
        this.updOpinionComplete(taskId, OpinionStatus.FEEDBACK, ContextUtil.getCurrentUserId(), opinion);
        IUser user = BpmUtil.getUser(taskCommu.getSenderId());
        MessageUtil.notify(defaultBpmTask, opinion, user, notifyType, "bpmCommuFeedBack");
        defaultBpmTask.setAssigneeId(ContextUtil.getCurrentUserId());
        this.restfulPluginExecut(defaultBpmTask, EventType.TASK_COMPLETE_EVENT);
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
    }

    @Override
    public void finishTask(String parentId) {
        this.bpmTaskManager.delByParentId(parentId);
    }

    private String addTranCheckOpinion(DefaultBpmProcessInstance def, OpinionStatus opinionStatus, String commuUser, String opinion, String files, String formData, String taskId) {
        String opinionId = UniqueIdUtil.getSuid();
        IUser user = this.userServiceImpl.getUserById(commuUser);
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        String bpmnInstId = def.getBpmnInstId();
        String superInstId = (String)this.natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(opinionId);
        checkOpinion.setProcDefId(def.getBpmnDefId());
        checkOpinion.setSupInstId(superInstId);
        checkOpinion.setProcInstId(def.getId());
        checkOpinion.setTaskId(taskId);
        checkOpinion.setTaskKey("");
        checkOpinion.setTaskName("\u6c9f\u901a\u4efb\u52a1");
        checkOpinion.setFiles(files);
        checkOpinion.setFormData(formData);
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setCreateTime(LocalDateTime.now());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        checkOpinion.setOpinion(opinion);
        if (opinionStatus.equals((Object)OpinionStatus.START_COMMU)) {
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(durMs);
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
        }
        checkOpinion.setIsRead(1);
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
        return opinionId;
    }

    @Transactional
    private void updOpinionComplete(String taskId, OpinionStatus opinionStatus, String commuUser, String opinion) {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.addFilter("task_id_", (Object)taskId, QueryOP.EQUAL);
        queryFilter.addFilter("status_", (Object)OpinionStatus.AWAITING_FEEDBACK, QueryOP.EQUAL);
        PageList opinions = this.bpmCheckOpinionManager.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)opinions)) {
            DefaultBpmCheckOpinion checkOpinion = (DefaultBpmCheckOpinion)opinions.getRows().get(0);
            IUser user = BpmUtil.getUser(commuUser);
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
            checkOpinion.setOpinion(opinion);
            checkOpinion.setStatus(opinionStatus.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(durMs);
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
    }

    private void restfulPluginExecut(DefaultBpmTask task, EventType eventType) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(task.getProcDefId());
        List<BpmPluginContext> pluginContextList = bpmProcessDef.getProcessDefExt().getBpmPluginContexts();
        if (BeanUtils.isNotEmpty(pluginContextList)) {
            for (BpmPluginContext bpmPluginContext : pluginContextList) {
                IGlobalRestfulPluginDef restfulPluginDef;
                List<Restful> restfuls;
                BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
                if (!(bpmPluginDef instanceof BpmExecutionPluginDef)) continue;
                BpmExecutionPluginDef bpmExecutionPluginDef = (BpmExecutionPluginDef)bpmPluginDef;
                BpmExecutionPlugin bpmExecutionPlugin = this.bpmPluginFactory.buildExecutionPlugin(bpmPluginContext, eventType);
                if (bpmExecutionPlugin == null || !bpmPluginContext.getEventTypes().contains((Object)eventType) || !(bpmExecutionPluginDef instanceof IGlobalRestfulPluginDef) || !BeanUtils.isNotEmpty(restfuls = (restfulPluginDef = (IGlobalRestfulPluginDef)((Object)bpmExecutionPluginDef)).getRestfulList())) continue;
                this.restfulService.outTaskPluginExecute(task, restfuls, eventType);
            }
        }
    }
}

