/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.skip;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.inst.ISkipCondition;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.SkipResult;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.engine.task.skip.SkipConditionUtil;
import com.hotent.bpm.exception.BusinessException;
import com.hotent.bpm.params.AutoRunVo;
import com.hotent.bpm.params.PolicyConfig;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AutoRunSkipCondition
implements ISkipCondition {
    private static final Logger logger = LoggerFactory.getLogger(AutoRunSkipCondition.class);
    @Resource
    private BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;

    @Override
    public boolean canSkip(BpmTask task) {
        List<AutoRunVo> autoRunVos = this.getAutoRunVos(task);
        if (BeanUtils.isNotEmpty(autoRunVos)) {
            List base = autoRunVos.stream().filter(i -> "base".equals(i.getValidNode())).collect(Collectors.toList());
            for (AutoRunVo runVo : autoRunVos) {
                if (!runVo.getValidNode().equals(task.getNodeId())) continue;
                if ("2".equals(runVo.getPolicyType())) {
                    String script = runVo.getPolicyScript();
                    script = script.replaceAll("\\\\", "");
                    return this.excuteScript(script, task);
                }
                if (!"1".equals(runVo.getPolicyType())) continue;
                List<PolicyConfig> policyList = runVo.getPolicyList();
                return this.handPolicy(policyList, task);
            }
            if (BeanUtils.isNotEmpty(base)) {
                AutoRunVo autoRunVo = (AutoRunVo)base.get(0);
                if ("1".equals(autoRunVo.getPolicyType())) {
                    List<PolicyConfig> policyList = autoRunVo.getPolicyList();
                    return this.handPolicy(policyList, task);
                }
                if ("2".equals(autoRunVo.getPolicyType())) {
                    String script = autoRunVo.getPolicyScript();
                    script = script.replaceAll("\\\\", "");
                    return this.excuteScript(script, task);
                }
            }
        }
        return false;
    }

    private boolean excuteScript(String script, BpmTask task) {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)ContextThreadUtil.getActionCmd();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty(boMap)) {
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty(boMap)) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                ObjectNode obj = next.getValue();
                if (obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode) {
                    obj = (ObjectNode)obj.get("data");
                }
                HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode(obj);
                newMap.put(next.getKey(), htObjectNode);
                vars.put(next.getKey(), htObjectNode);
            }
            vars.putAll(newMap);
        }
        vars.putAll(cmd.getVariables());
        GroovyScriptEngine engine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        try {
            boolean executeBoolean = engine.executeBoolean(script, vars);
            if (executeBoolean) {
                ContextThreadUtil.putCommonVars("autoRunAuditor", "");
                ContextThreadUtil.putCommonVars("autoRunAuditorName", "");
                return true;
            }
            return false;
        }
        catch (BusinessException e) {
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            message.append("<br/><br/>\u8282\u70b9\uff1a" + task.getName());
            message.append("<br/><br/>\u811a\u672c\uff1a" + script);
            throw new WorkFlowException(message.toString());
        }
    }

    private List<AutoRunVo> getAutoRunVos(BpmTask task) {
        BpmProcessDef<BpmProcessDefExt> procDef = null;
        List autoRunVos = null;
        try {
            procDef = BpmUtil.getProcessDefByDefId(task.getProcDefId());
            BpmDefExtProperties extProperties = procDef.getProcessDefExt().getExtProperties();
            String autoRunConfig = extProperties.getAutoRunConfig();
            autoRunVos = (List)JsonUtil.toBean((String)autoRunConfig, (TypeReference)new TypeReference<List<AutoRunVo>>(){});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return autoRunVos;
    }

    private boolean handPolicy(List<PolicyConfig> policyList, BpmTask task) {
        for (PolicyConfig policyConfig : policyList) {
            String node = policyConfig.getPolicyNode();
            String type = policyConfig.getPolicyType();
            if (!this.handNode(type, task, node)) continue;
            return true;
        }
        return false;
    }

    private boolean handNode(String type, BpmTask task, String node) {
        boolean flag = false;
        if ("1".equals(type)) {
            flag = "pre".equals(node) ? this.preSameUserSkip(task) : ("already".equals(node) ? this.alreadyNode(task) : this.directNode(node, task));
        }
        return flag;
    }

    private boolean directNode(String node, BpmTask task) {
        boolean flag = false;
        List<DefaultBpmCheckOpinion> list = this.bpmCheckOpinionManager.getByInstId(task.getProcInstId());
        for (DefaultBpmCheckOpinion checkOpinion : list) {
            if (!node.equals(checkOpinion.getTaskKey()) || !this.isChecked(checkOpinion.getAuditor(), this.bpmIdentityExtractService.extractUser(task.getIdentityList()))) continue;
            ContextThreadUtil.putCommonVars("autoRunAuditor", checkOpinion.getAuditor());
            ContextThreadUtil.putCommonVars("autoRunAuditorName", checkOpinion.getAuditorName());
            flag = true;
            break;
        }
        return flag;
    }

    private boolean preSameUserSkip(BpmTask task) {
        BpmProStatusManager bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        List<String> nodeIds = bpmProStatusManager.getByInstIdAndRecycleNode(task.getProcInstId(), "0");
        List<BpmNodeDef> beforeAllNodes = null;
        try {
            beforeAllNodes = AutoRunSkipCondition.getBeforeAllNodes(task.getProcDefId(), task.getNodeId(), nodeIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<DefaultBpmCheckOpinion> list = this.bpmCheckOpinionManager.getByInstId(task.getProcInstId());
        if (BeanUtils.isEmpty(beforeAllNodes)) {
            return false;
        }
        List<BpmNodeDef> finalBeforeAllNodes = beforeAllNodes;
        List opinions = list.stream().filter(i -> StringUtil.isNotEmpty((String)i.getTaskKey()) && i.getTaskKey().equals(((BpmNodeDef)finalBeforeAllNodes.get(0)).getNodeId())).collect(Collectors.toList());
        List<IUser> userList = this.bpmIdentityExtractService.extractUser(task.getIdentityList());
        for (DefaultBpmCheckOpinion opinion : opinions) {
            if (!this.isChecked(opinion.getAuditor(), userList)) continue;
            ContextThreadUtil.putCommonVars("autoRunAuditor", opinion.getAuditor());
            ContextThreadUtil.putCommonVars("autoRunAuditorName", opinion.getAuditorName());
            return true;
        }
        return false;
    }

    private boolean alreadyNode(BpmTask task) {
        boolean flag = false;
        List<DefaultBpmCheckOpinion> list = this.bpmCheckOpinionManager.getByInstId(task.getProcInstId());
        BpmProStatusManager bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        List<String> nodeIds = bpmProStatusManager.getByInstIdAndRecycleNode(task.getProcInstId(), "0");
        List beforeAllNodes = null;
        try {
            beforeAllNodes = AutoRunSkipCondition.getBeforeAllNodes(task.getProcDefId(), task.getNodeId(), nodeIds).stream().map(BpmNodeDef::getNodeId).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e4b\u524d\u6240\u6709\u8282\u70b9\u5f02\u5e38\uff01", (Throwable)e);
        }
        List finalBeforeAllNodes = beforeAllNodes;
        List collect = list.stream().filter(i -> finalBeforeAllNodes.contains(i.getTaskKey())).collect(Collectors.toList());
        List<IUser> userList = this.bpmIdentityExtractService.extractUser(task.getIdentityList());
        List<IUser> userListCvt = SkipConditionUtil.convertUserAgent(userList, task.getId());
        for (DefaultBpmCheckOpinion opinion : collect) {
            if (!this.isChecked(opinion.getAuditor(), userListCvt)) continue;
            ContextThreadUtil.putCommonVars("autoRunAuditor", opinion.getAuditor());
            ContextThreadUtil.putCommonVars("autoRunAuditorName", opinion.getAuditorName());
            flag = true;
            break;
        }
        return flag;
    }

    public static List<BpmNodeDef> getBeforeAllNodes(String defId, String nodeId, List<String> nodeIds) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        ArrayList<String> findNodeIds = new ArrayList<String>();
        ArrayList<BpmNodeDef> resultBeforeNodes = new ArrayList<BpmNodeDef>();
        AutoRunSkipCondition.collectBeforeNodes(bpmNodeDef, resultBeforeNodes, findNodeIds, nodeIds);
        return AutoRunSkipCondition.reorderBeforeAllNodes(resultBeforeNodes, nodeIds);
    }

    private static void collectBeforeNodes(BpmNodeDef bpmNodeDef, List<BpmNodeDef> resultBeforeNodes, List<String> findNodeIds, List<String> nodeIds) {
        List<BpmNodeDef> incomeNodes = bpmNodeDef.getIncomeNodes();
        if (BeanUtils.isEmpty(incomeNodes)) {
            return;
        }
        ArrayList<String> userTaskTypes = new ArrayList<String>();
        userTaskTypes.add(NodeType.USERTASK.getKey());
        userTaskTypes.add(NodeType.SIGNTASK.getKey());
        incomeNodes.stream().forEach(incomeNode -> {
            if (userTaskTypes.contains(incomeNode.getType().getKey()) && !findNodeIds.contains(incomeNode.getNodeId()) && nodeIds.contains(incomeNode.getNodeId())) {
                resultBeforeNodes.add((BpmNodeDef)incomeNode);
            }
            if (!findNodeIds.contains(incomeNode.getNodeId())) {
                findNodeIds.add(incomeNode.getNodeId());
                AutoRunSkipCondition.collectBeforeNodes(incomeNode, resultBeforeNodes, findNodeIds, nodeIds);
            }
            BpmNodeDef parentBpmNodeDef = incomeNode.getParentBpmNodeDef();
            if (NodeType.START.equals((Object)incomeNode.getType()) && BeanUtils.isNotEmpty((Object)incomeNode.getParentBpmNodeDef())) {
                AutoRunSkipCondition.collectBeforeNodes(parentBpmNodeDef, resultBeforeNodes, findNodeIds, nodeIds);
            }
        });
    }

    private static List<BpmNodeDef> reorderBeforeAllNodes(List<BpmNodeDef> resultBeforeNodes, List<String> nodeIds) {
        ArrayList<BpmNodeDef> reorderBeforeAllNodes = new ArrayList<BpmNodeDef>();
        Map nodeId2BpmNodeDef = resultBeforeNodes.stream().collect(Collectors.toMap(BpmNodeDef::getNodeId, Function.identity()));
        nodeIds.stream().forEach(nodeId -> {
            if (nodeId2BpmNodeDef.containsKey(nodeId)) {
                reorderBeforeAllNodes.add((BpmNodeDef)nodeId2BpmNodeDef.get(nodeId));
            }
        });
        return reorderBeforeAllNodes;
    }

    private boolean isChecked(String auditor, List<IUser> userList) {
        if (BeanUtils.isEmpty(userList)) {
            return false;
        }
        for (IUser user : userList) {
            if (!user.getUserId().equals(auditor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "\u4efb\u52a1\u81ea\u52a8\u6267\u884c";
    }

    @Override
    public String getType() {
        return SkipResult.SKIP_AUTO_RUN;
    }

    @Override
    public String getOpinion(DefaultBpmTask task) {
        List base;
        List<AutoRunVo> autoRunVos = this.getAutoRunVos(task);
        String opinion = "";
        for (AutoRunVo autoRunVo : autoRunVos) {
            if (!task.getNodeId().equals(autoRunVo.getValidNode()) || !"1".equals(autoRunVo.getShowOpinion())) continue;
            opinion = autoRunVo.getOpinion();
        }
        if (StringUtil.isEmpty((String)opinion) && BeanUtils.isNotEmpty(base = autoRunVos.stream().filter(i -> "base".equals(i.getValidNode())).collect(Collectors.toList())) && "1".equals(((AutoRunVo)base.get(0)).getShowOpinion())) {
            opinion = ((AutoRunVo)base.get(0)).getOpinion();
        }
        return opinion;
    }
}

