/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.skip;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.TaskActionType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.inst.ISkipCondition;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.params.PreviewProcessVo;
import com.hotent.bpm.persistence.manager.PreviewProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PreSkipAfterApproveSkipCondition
implements ISkipCondition {
    @Override
    public boolean canSkip(BpmTask task) {
        try {
            BpmNodeDef bpmNodeDef;
            NodeProperties localProperties;
            Map<String, Object> transitVars = ContextThreadUtil.getActionCmd().getTransitVars();
            String preTaskNodeId = task.getNodeId();
            if (transitVars.containsKey("bpmTask_")) {
                BpmTask bpmTask = (BpmTask)transitVars.get("bpmTask_");
                preTaskNodeId = bpmTask.getNodeId();
            }
            if (!(localProperties = (bpmNodeDef = ((BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class)).getBpmNodeDef(task.getProcDefId(), preTaskNodeId)).getLocalProperties()).isPreSkipAfterApprovePreview()) {
                return false;
            }
            List<BpmIdentity> identityList = task.getIdentityList();
            if (BeanUtils.isEmpty(identityList) || identityList.size() > 1) {
                return false;
            }
            BpmIdentity identity = identityList.get(0);
            String userId = identity.getId();
            if (!"user".equals(identity.getType())) {
                return false;
            }
            return this.suportSkip(task, userId);
        }
        catch (Exception e) {
            throw new BaseException("\u524d\u8df3\u540e\u5ba1\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean suportSkip(BpmTask task, String userId) throws Exception {
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (!TaskActionType.AGREE.getKey().equals(actionCmd.getActionName())) {
            return false;
        }
        PreviewProcessVo previewProcessVo = new PreviewProcessVo();
        previewProcessVo.setInstId(task.getProcInstId());
        previewProcessVo.setNodeId(task.getNodeId());
        String busData = actionCmd.getBusData();
        if (StringUtil.isNotEmpty((String)busData)) {
            previewProcessVo.setFormData(Base64.getBase64((String)busData));
        }
        Map<String, Object> resultMap = ((PreviewProcessService)AppUtil.getBean(PreviewProcessService.class)).previewProcess(previewProcessVo);
        List pathList = (List)resultMap.get("pathList");
        List afterNodeExecutor = pathList.stream().filter(predicate -> !task.getNodeId().equals(predicate.get("nodeId"))).collect(Collectors.toList());
        List existNode = afterNodeExecutor.stream().filter(predicate -> {
            List<Map> excutors = new ArrayList();
            if (predicate.get("excutorList") instanceof ArrayList) {
                excutors = (List)predicate.get("excutorList");
            }
            if (predicate.containsKey("excutor") && predicate.get("excutor") instanceof HashMap) {
                excutors.add((Map)predicate.get("excutor"));
            }
            if (excutors.size() > 1) {
                return false;
            }
            List existExcutor = excutors.stream().filter(excutor -> userId.equals(String.valueOf(excutor.get("id")))).collect(Collectors.toList());
            return BeanUtils.isNotEmpty(existExcutor);
        }).collect(Collectors.toList());
        return BeanUtils.isNotEmpty(existNode);
    }

    @Override
    public String getTitle() {
        return "\u524d\u8df3\u540e\u5ba1";
    }

    @Override
    public String getType() {
        return "preSkipAfterApprove";
    }
}

