/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.bpm.api.event.AutoTestEvent;
import com.hotent.bpm.persistence.model.AutoTestModel;
import java.io.IOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.ClientProtocolException;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AutoTestEventListener
implements ApplicationListener<AutoTestEvent>,
Ordered {
    public int getOrder() {
        return 0;
    }

    public void onApplicationEvent(AutoTestEvent event) {
        AutoTestModel model = (AutoTestModel)event.getSource();
        try {
            this.doNext(model);
        }
        catch (Exception e) {
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void doNext(AutoTestModel model) throws ClientProtocolException, IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("account", model.getRandomAccount());
        jsonObject.put("actionName", "agree");
        jsonObject.put("taskId", model.getTaskId());
        jsonObject.put("tenantId", model.getTenantId());
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)model, "bpmTestCase");
    }
}

