/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.DataType;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.SkipResult;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.DataObjectHandler;
import com.hotent.bpm.engine.def.BpmDefUtil;
import com.hotent.bpm.exception.HandlerException;
import com.hotent.bpm.model.BoDataModifyRecord;
import com.hotent.bpm.persistence.manager.BoDataModifyRecordManager;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.HandlerUtil;
import com.hotent.table.operator.ITableOperator;
import com.hotent.table.operator.impl.mysql.MySQLTableOperator;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.seata.common.util.CollectionUtils;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BusDataUtil {
    private static int supportPart = -1;
    private static Set<String> partions = Collections.synchronizedSet(new HashSet());
    private static final String tableName = "BPM_BUS_LINK";

    public static void handlerBusinessLink(BpmProcessInstance instance, List<ObjectNode> boResults, String saveMode, Boolean isInstanceCreateTemp) {
        BpmBusLinkManager bpmBusLinkManager = (BpmBusLinkManager)AppUtil.getBean(BpmBusLinkManager.class);
        ArrayList<BpmBusLink> insertBusLinks = new ArrayList<BpmBusLink>();
        ArrayList<Map<String, Object>> deleteBusLinks = new ArrayList<Map<String, Object>>();
        HashSet<String> addSet = new HashSet<String>();
        Map<String, List<BpmBusLink>> bblMap = null;
        if (!isInstanceCreateTemp.booleanValue()) {
            List<BpmBusLink> bbls = bpmBusLinkManager.getAllByInstId(instance.getId());
            bblMap = bbls.stream().collect(Collectors.groupingBy(bpmBusLink -> StringUtils.isEmpty((String)bpmBusLink.getBusinesskeyStr()) ? String.valueOf(bpmBusLink.getBusinesskey()) : bpmBusLink.getBusinesskeyStr()));
        }
        for (ObjectNode result : boResults) {
            BpmBusLink busLink;
            ObjectNode boEnt = (ObjectNode)result.get("boEnt");
            boolean isNumber = BeanUtils.isNotEmpty((Object)boEnt.get("pkType")) && "number".equals(JsonUtil.getString((JsonNode)boEnt, (String)"pkType"));
            String action = result.get("action").asText();
            if ("add".equals(action)) {
                busLink = BpmUtil.buildBusLink(instance, result, saveMode);
                BusDataUtil.createPartition(busLink.getFormIdentify());
                addSet.add(isNumber ? busLink.getBusinesskey().toString() : busLink.getBusinesskeyStr());
                insertBusLinks.add(busLink);
                continue;
            }
            if ("del".equals(action)) {
                deleteBusLinks.add(BusDataUtil.getParams(result.get("pk").asText(), result.get("boEnt").get("name").asText(), isNumber));
                continue;
            }
            if (!"upd".equals(action) || !BeanUtils.isEmpty(bblMap) && (bblMap.containsKey(result.get("pk").asText()) || addSet.contains(result.get("pk").asText()))) continue;
            busLink = BpmUtil.buildBusLink(instance, result, saveMode);
            BusDataUtil.createPartition(busLink.getFormIdentify());
            insertBusLinks.add(busLink);
        }
        if (BeanUtils.isNotEmpty(insertBusLinks)) {
            bpmBusLinkManager.saveBatch(insertBusLinks);
        }
        if (BeanUtils.isNotEmpty(deleteBusLinks)) {
            bpmBusLinkManager.delBatchByBusinesKey(deleteBusLinks);
        }
    }

    private static Map<String, Object> getParams(String businessKey, String formIdentity, boolean isNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isNumber) {
            params.put("businessKey", Long.parseLong(businessKey));
        } else {
            params.put("businessKey", businessKey);
        }
        if (StringUtil.isNotEmpty((String)formIdentity)) {
            params.put("formIdentity", formIdentity);
        }
        params.put("isNumber", isNumber);
        return params;
    }

    private static void createPartition(String partName) {
        if (StringUtil.isEmpty((String)partName)) {
            return;
        }
        ITableOperator tableOperator = (ITableOperator)AppUtil.getBean((String)"tableOperator");
        if (tableOperator == null) {
            return;
        }
        if (tableOperator instanceof MySQLTableOperator) {
            return;
        }
        if (supportPart == -1) {
            boolean isSupport = tableOperator.supportPartition(tableName);
            int n = supportPart = isSupport ? 1 : 0;
        }
        if (supportPart == 0) {
            return;
        }
        if (partions.contains(partName)) {
            return;
        }
        boolean isPartExist = tableOperator.isExsitPartition(tableName, partName);
        partions.add(partName);
        if (isPartExist) {
            return;
        }
        tableOperator.createPartition(tableName, partName);
    }

    public static void handExt(ActionCmd cmd) {
        Map<String, String> pairs = cmd.getDataPair();
        if (BeanUtils.isNotEmpty(pairs)) {
            return;
        }
        BusDataUtil.addBusLink(cmd);
    }

    private static void addBusLink(ActionCmd cmd) {
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmBusLinkManager bpmBusLinkManager = (BpmBusLinkManager)AppUtil.getBean(BpmBusLinkManager.class);
        String instId = cmd.getInstId();
        Map<String, String> pairs = cmd.getDataPair();
        DataType dataType = cmd.getPkDataType();
        BpmProcessInstance instance = (BpmProcessInstance)bpmProcessInstanceManager.get((Serializable)((Object)instId));
        boolean isNumber = !DataType.STRING.equals((Object)dataType);
        for (Map.Entry<String, String> entry : pairs.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            List<BpmBusLink> bpmBusLinkList = bpmBusLinkManager.getByBusinesKey(val, key, isNumber);
            if (CollectionUtils.isNotEmpty(bpmBusLinkList)) continue;
            BpmBusLink busLink = BpmUtil.buildBusLink(instance);
            busLink.setIsMain(1);
            busLink.setFormIdentify(key);
            if (!isNumber) {
                busLink.setBusinesskeyStr(val);
            } else {
                busLink.setBusinesskey(Long.parseLong(val));
            }
            BusDataUtil.createPartition(key);
            bpmBusLinkManager.create((Model)busLink);
        }
    }

    public static void executeHandler(NodeProperties properties, ActionCmd actionCmd, boolean isBefore) {
        String handler;
        if (properties == null) {
            return;
        }
        String string = handler = isBefore ? properties.getPrevHandler() : properties.getPostHandler();
        if (StringUtil.isEmpty((String)handler)) {
            return;
        }
        try {
            HandlerUtil.invokeHandler(actionCmd, handler);
        }
        catch (Exception ex) {
            throw new HandlerException(ex.getMessage(), ex.getCause());
        }
    }

    public static void updateBoData(String instId, String nodeId, String formData) throws Exception {
        BpmProcessInstanceManager instanceManager;
        ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        DefaultBpmProcessInstance instance = null;
        if (BeanUtils.isNotEmpty((Object)actionCmd) && BeanUtils.isNotEmpty((Object)actionCmd.getTransitVars("processInstance"))) {
            instance = (DefaultBpmProcessInstance)actionCmd.getTransitVars("processInstance");
        }
        if (BeanUtils.isEmpty(instance) && BeanUtils.isEmpty((Object)(instance = (DefaultBpmProcessInstance)(instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class)).get((Serializable)((Object)instId))))) {
            throw new BaseException(String.format("\u6839\u636e\u5b9e\u4f8bid\u3010%s\u3011\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b", instId));
        }
        DefaultBpmProcessDefExt bpmProcessDefExt = BpmDefUtil.getProcessExt(instance);
        List<ObjectNode> boDatas = BusDataUtil.transFormDataToBoData(bpmProcessDefExt, formData);
        ObjectNode[] dataArray = boDatas.toArray(new ObjectNode[boDatas.size()]);
        BusDataUtil.updateBoData(instance.getId(), nodeId, dataArray);
    }

    public static void updateBoData(DefaultBpmProcessInstance instance, String nodeId, String formData) throws Exception {
        if (BeanUtils.isEmpty((Object)instance)) {
            throw new BaseException("\u6839\u636e\u5b9e\u4f8b\u5bf9\u8c61\u66f4\u65b0\u8868\u5355\u6570\u636e\u65f6\uff0c\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)formData) || Objects.equals(formData, "{}")) {
            return;
        }
        DefaultBpmProcessDefExt bpmProcessDefExt = BpmDefUtil.getProcessExt(instance);
        List<ObjectNode> boDatas = BusDataUtil.transFormDataToBoData(bpmProcessDefExt, formData);
        ObjectNode[] dataArray = boDatas.toArray(new ObjectNode[boDatas.size()]);
        BusDataUtil.updateBoData(instance.getId(), nodeId, dataArray);
    }

    private static void updateBoData(String instanceId, String nodeId, ObjectNode ... boDatas) {
        FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        List boResultList = formRestfulService.batchHandlerBoData(BusDataUtil.getFormRestParamByBoDatas(false, instanceId, nodeId, false, boDatas));
        BusDataUtil.handlerBodataModify(boResultList);
    }

    private static void handlerBodataModify(List<List<ObjectNode>> boResultList) {
        BaseActionCmd actionCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        BoDataModifyRecordManager boDataModifyRecordManager = (BoDataModifyRecordManager)AppUtil.getBean(BoDataModifyRecordManager.class);
        if (BeanUtils.isEmpty((Object)actionCmd)) {
            return;
        }
        ArrayList<BoDataModifyRecord> saveList = new ArrayList<BoDataModifyRecord>();
        for (List<ObjectNode> boResult : boResultList) {
            String modifyRes = "";
            String refId = "";
            String data = "";
            String boAlias = "";
            for (ObjectNode objectNode : boResult) {
                if (!objectNode.hasNonNull("modifyDetail") || !StringUtil.isNotEmpty((String)objectNode.get("modifyDetail").asText())) continue;
                modifyRes = objectNode.get("modifyDetail").asText();
                data = objectNode.get("data").asText();
                refId = objectNode.get("pk").asText();
                boAlias = JsonUtil.getString((JsonNode)objectNode, (String)"boAlias");
                break;
            }
            if (StringUtil.isEmpty((String)modifyRes)) continue;
            BoDataModifyRecord record = new BoDataModifyRecord();
            if (StringUtil.isNotEmpty((String)refId)) {
                record.setRefId(refId);
            }
            if (actionCmd instanceof TaskFinishCmd) {
                record.setReason(((TaskFinishCmd)((Object)actionCmd)).getApprovalOpinion());
            }
            record.setInstId(actionCmd.getInstId());
            record.setModifyTime(LocalDateTime.now());
            IUser currentUser = ContextUtil.getCurrentUser();
            record.setUserId(currentUser.getUserId());
            record.setUserName(currentUser.getFullname());
            DefaultBpmTask task = (DefaultBpmTask)actionCmd.getTransitVars("bpmTask_");
            if (BeanUtils.isNotEmpty((Object)task)) {
                record.setTaskId(task.getTaskId());
                record.setNodeId(task.getNodeId());
                record.setTaskName(task.getName());
            }
            record.setDetail(modifyRes);
            record.setData(data);
            record.setBoAlias(boAlias);
            saveList.add(record);
        }
        boDataModifyRecordManager.saveOrUpdateBatch(saveList);
    }

    public static void handSaveBoData(BpmProcessInstance instance, ActionCmd cmd) throws Exception {
        boolean backOtherTaskCancle;
        Object taskObj = cmd.getTransitVars("bpmTask_");
        BpmTask bpmTask = null;
        String boJson = cmd.getBusData();
        FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        if (StringUtil.isEmpty((String)boJson)) {
            BoDataService boDataService = (BoDataService)AppUtil.getBean(BoDataService.class);
            List<ObjectNode> boDatas = boDataService.getDataByInst(instance);
            HashMap<String, ObjectNode> boMap = new HashMap<String, ObjectNode>();
            for (ObjectNode data : boDatas) {
                String code = "";
                code = data.hasNonNull("boDefAlias") ? data.get("boDefAlias").asText() : data.get("boDef").get("alias").asText();
                ObjectNode bodefByAlias = formRestfulService.getBodefByAlias(code);
                if (BeanUtils.isNotEmpty((Object)bodefByAlias) && "forbidden".equals(bodefByAlias.get("status").asText())) {
                    throw new BaseException("\u8be5\u6d41\u7a0b\u7ed1\u5b9a\u7684\u8868\u5355\u6240\u5bf9\u5e94\u7684\u4e1a\u52a1\u5efa\u6a21\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u542f\u52a8\u3002");
                }
                boMap.put(code, data);
            }
            cmd.getTransitVars().put("bo_inst_", boMap);
            return;
        }
        DefaultBpmProcessDefExt bpmProcessDefExt = BpmDefUtil.getProcessExt(instance);
        List<ObjectNode> boDatas = BusDataUtil.transFormDataToBoData(bpmProcessDefExt, boJson);
        if (BeanUtils.isNotEmpty((Object)taskObj) && taskObj instanceof BpmTask) {
            bpmTask = (BpmTask)taskObj;
            if (bpmTask.getSkipResult().isSkipTask()) {
                ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
            }
            if (SkipResult.SKIP_FIRST.equals(bpmTask.getSkipResult().getSkipType()) && bpmTask.getSkipResult().isSkipTask()) {
                cmd.addTransitVars("bo_inst_", BoDataUtil.converBodataListToMap(boDatas));
                return;
            }
            if (TaskType.TRANSFORMED.getKey().equals(bpmTask.getStatus())) {
                cmd.addTransitVars("bo_inst_", BoDataUtil.converBodataListToMap(boDatas));
                return;
            }
            if (TaskType.TRANSFORMING.getKey().equals(bpmTask.getStatus())) {
                cmd.addTransitVars("bo_inst_", BoDataUtil.converBodataListToMap(boDatas));
                return;
            }
        }
        if (backOtherTaskCancle = ((Boolean)cmd.getTransitVars("back_other_task_cancle", false)).booleanValue()) {
            return;
        }
        boolean isInstanceCreateTemp = false;
        if (cmd.getTransitVars("instance_draft") != null) {
            isInstanceCreateTemp = true;
        }
        DataObjectHandler dataObjectHandler = (DataObjectHandler)AppUtil.getBean(DataObjectHandler.class);
        String nodeId = "";
        if (BeanUtils.isNotEmpty((Object)bpmTask)) {
            nodeId = bpmTask.getNodeId();
            dataObjectHandler.handSaveData(instance, nodeId, boDatas);
        } else {
            dataObjectHandler.handSaveData(instance, boDatas);
        }
        cmd.addTransitVars("processInstance", instance);
        boolean checkFormDataRev = !"true".equals(ThreadMsgUtil.getMapMsg((String)"ignore_form_data_rev"));
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmProcessInstance instanceTop = bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
        String instId = instanceTop == null ? instance.getId() : instanceTop.getId();
        List<ObjectNode> formRestParams = BusDataUtil.getFormRestParamByBoDatas(isInstanceCreateTemp, instId, nodeId, checkFormDataRev, boDatas.toArray(new ObjectNode[boDatas.size()]));
        if (BeanUtils.isNotEmpty((Object)instanceTop) && !instanceTop.getId().equals(instance.getId())) {
            formRestParams.forEach(param -> param.put("parentFlowKey", instanceTop.getProcDefKey()));
        }
        String saveType = "database";
        List boResultList = null;
        try {
            boResultList = formRestfulService.batchHandlerBoData(formRestParams);
        }
        catch (Exception e) {
            if (e.getCause() instanceof BaseException) {
                throw new BaseException(e.getCause().getMessage());
            }
            throw e;
        }
        String formKey = cmd.getFormKey();
        List formDataTemplateExtendList = null;
        if (StringUtil.isNotEmpty((String)formKey)) {
            formDataTemplateExtendList = formRestfulService.getDataTemplateExtendByFormKey(formKey);
        }
        HashMap<String, ObjectNode> boMap = new HashMap<String, ObjectNode>();
        for (int i = 0; i < boDatas.size(); ++i) {
            List boResults = (List)boResultList.get(i);
            ObjectNode boData = boDatas.get(i);
            ObjectNode boEnt = (ObjectNode)boData.get("boEnt");
            ObjectNode def = (ObjectNode)boData.get("boDef");
            if (def != null && def.has("supportDb") && !def.get("supportDb").asBoolean()) {
                saveType = "boObject";
            }
            String id = formRestParams.get(i).get("boid").asText();
            for (ObjectNode result : boResults) {
                if (!JsonUtil.getString((JsonNode)result, (String)"parentId", (String)"").equals("0") || !"add".equals(result.get("action").asText())) continue;
                ThreadMsgUtil.addMapMsg((String)"curBoPkVal", (String)result.get("pk").asText());
                boData.put(boEnt.get("pkKey").asText(), result.get("pk").asText());
                if (!boData.has("data")) continue;
                HtObjectNode jsonNode = (HtObjectNode)boData.get("data");
                jsonNode.put(boEnt.get("pkKey").asText(), result.get("pk").asText());
            }
            if (StringUtil.isNotEmpty((String)formKey)) {
                BusDataUtil.handeDataTemplateExtend(id, boData, boResults, formDataTemplateExtendList);
            }
            BusDataUtil.handlerBusinessLink(instance, boResults, saveType, isInstanceCreateTemp);
            boMap.put(def.get("alias").asText(), boData);
        }
        BusDataUtil.handlerBodataModify(boResultList);
        cmd.getTransitVars().put("bo_inst_", boMap);
    }

    private static void handeDataTemplateExtend(String id, ObjectNode boData, List<ObjectNode> boResults, List formDataTemplateExtendList) throws IOException {
        FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        GroovyScriptEngine groovyScriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        if (StringUtil.isNotEmpty((String)id)) {
            formRestfulService.deleteFormRemindDataByBoDataId(id);
        } else {
            ObjectNode a = boResults.stream().filter(b -> "add".equals(b.get("action").asText())).findAny().orElse(null);
            if (a != null) {
                id = a.get("pk").asText();
            }
        }
        ArrayList<ObjectNode> insertList = new ArrayList<ObjectNode>();
        for (int i = 0; i < formDataTemplateExtendList.size(); ++i) {
            JsonNode node;
            String script;
            boolean res;
            JsonNode formDataTemplateExtend = JsonUtil.toJsonNode(formDataTemplateExtendList.get(i));
            String scriptJson = formDataTemplateExtend.get("rule").asText();
            if (StringUtil.isEmpty((String)scriptJson) || !(res = groovyScriptEngine.executeBoolean(Base64.getFromBase64((String)(script = (node = JsonUtil.toJsonNode((String)scriptJson)).get("scriptStr").asText())), JsonUtil.toMap((String)boData.toString())))) continue;
            String typeObj = formDataTemplateExtend.get("typeObj").asText();
            String objId = formDataTemplateExtend.get("objId").asText();
            String content = formDataTemplateExtend.get("content").asText();
            String count = formDataTemplateExtend.get("count").asText();
            String subject = formDataTemplateExtend.get("subject").asText();
            String refId = formDataTemplateExtend.get("id").asText();
            if (typeObj.equals("script")) {
                objId = boData.get(objId).asText();
                ObjectNode formRemindData = JsonUtil.getMapper().createObjectNode();
                formRemindData.put("content", content);
                formRemindData.put("count", count);
                formRemindData.put("objId", objId);
                formRemindData.put("typeObj", "user");
                formRemindData.put("opemId", id);
                formRemindData.put("subject", subject);
                formRemindData.put("refId", refId);
                formRemindData.put("opemType", formDataTemplateExtend.get("alias").asText());
                insertList.add(formRemindData);
                continue;
            }
            String[] objIds = objId.split(",");
            for (int j = 0; j < objIds.length; ++j) {
                ObjectNode formRemindData = JsonUtil.getMapper().createObjectNode();
                formRemindData.put("content", content);
                formRemindData.put("count", count);
                formRemindData.put("objId", objIds[j]);
                formRemindData.put("typeObj", typeObj);
                formRemindData.put("opemId", id);
                formRemindData.put("subject", subject);
                formRemindData.put("refId", refId);
                formRemindData.put("opemType", BeanUtils.isNotEmpty((Object)formDataTemplateExtend.get("alias")) ? formDataTemplateExtend.get("alias").asText() : "");
                insertList.add(formRemindData);
            }
        }
        formRestfulService.saveBatch(insertList);
    }

    public static List<ObjectNode> transFormDataToBoData(DefaultBpmProcessDefExt bpmProcessDefExt, String boJson) throws IOException {
        if (StringUtil.isEmpty((String)boJson)) {
            return new ArrayList<ObjectNode>();
        }
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((String)boJson);
        if (jsonObj == null || jsonObj.isEmpty()) {
            return new ArrayList<ObjectNode>();
        }
        BoDataUtil.validBo(bpmProcessDefExt, jsonObj);
        Map<String, ObjectNode> jsonMap = BoDataUtil.getMap(jsonObj);
        FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        ArrayList<ObjectNode> boDatas = new ArrayList<ObjectNode>();
        Set<String> set = jsonMap.keySet();
        if (BeanUtils.isEmpty(set)) {
            return new ArrayList<ObjectNode>();
        }
        List<ProcBoDef> list = bpmProcessDefExt.getBoDefList();
        HashSet<String> bindBoSet = new HashSet<String>();
        for (ProcBoDef boDef : list) {
            bindBoSet.add(boDef.getKey());
        }
        for (String string : set) {
            if (bindBoSet.contains(string)) continue;
            throw new BaseException(String.format("\u8868\u5355\u6570\u636e\u6709\u8bef\uff0c\u6d41\u7a0b\u5e76\u672a\u7ed1\u5b9a\u542b\u6709\u522b\u540d\u4e3a\u3010%s\u3011\u7684\u5efa\u6a21", string));
        }
        List bodefsByAliasList = formRestfulService.getBodefWithMainEntByAlias(StringUtil.join(set));
        for (ObjectNode bodefByAlias : bodefsByAliasList) {
            if (BeanUtils.isNotEmpty((Object)bodefByAlias) && "forbidden".equals(bodefByAlias.get("status").asText())) {
                throw new BaseException(String.format("\u8be5\u6d41\u7a0b\u7ed1\u5b9a\u7684\u8868\u5355\u6240\u5bf9\u5e94\u7684\u4e1a\u52a1\u5efa\u6a21\u3010%s\u3011\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u542f\u52a8\u3002", bodefByAlias.get("description").asText()));
            }
            ObjectNode json = jsonMap.get(bodefByAlias.get("alias").asText());
            ObjectNode curData = (ObjectNode)BoDataUtil.transJSON((JsonNode)json);
            curData.set("boEnt", bodefByAlias.get("boEnt"));
            bodefByAlias.remove("boEnt");
            curData.set("boDef", (JsonNode)bodefByAlias);
            curData.set("data", (JsonNode)json);
            boDatas.add(curData);
        }
        return boDatas;
    }

    public static List<ObjectNode> getFormRestParamByBoDatas(Boolean isInstanceCreateTemp, String instId, String nodeId, boolean checkFormDataRev, ObjectNode ... boDatas) {
        BpmProcessInstanceManager instanceManager;
        Map<String, BpmBusLink> linkMap = null;
        if (!isInstanceCreateTemp.booleanValue()) {
            BpmBusLinkManager bpmBusLinkManager = (BpmBusLinkManager)AppUtil.getBean(BpmBusLinkManager.class);
            linkMap = bpmBusLinkManager.getMapByInstId(instId);
        }
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (StringUtil.isEmpty((String)nodeId)) {
            nodeId = (String)ContextThreadUtil.getCommuVar("nodeId", "");
        }
        DefaultBpmProcessInstance instance = null;
        if (BeanUtils.isNotEmpty((Object)actionCmd)) {
            if (BeanUtils.isNotEmpty((Object)actionCmd.getTransitVars("processInstance"))) {
                instance = (DefaultBpmProcessInstance)actionCmd.getTransitVars("processInstance");
            }
            if (StringUtil.isEmpty((String)nodeId) && BeanUtils.isNotEmpty((Object)actionCmd.getTransitVars("bpmTask_"))) {
                nodeId = ((DefaultBpmTask)actionCmd.getTransitVars("bpmTask_")).getNodeId();
            }
        }
        if (BeanUtils.isEmpty(instance) && BeanUtils.isEmpty((Object)(instance = (DefaultBpmProcessInstance)(instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class)).get((Serializable)((Object)instId))))) {
            throw new BaseException(String.format("\u6839\u636e\u5b9e\u4f8bid\u3010%s\u3011\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b", instId));
        }
        if (StringUtil.isEmpty((String)nodeId)) {
            nodeId = (String)ContextThreadUtil.getCommuVar("nodeId", "");
        }
        String saveType = "database";
        ArrayList<ObjectNode> formRestParams = new ArrayList<ObjectNode>();
        for (ObjectNode boData : boDatas) {
            BpmBusLink busLink;
            ObjectNode boEnt = (ObjectNode)boData.get("boEnt");
            ObjectNode def = (ObjectNode)boData.get("boDef");
            String id = "";
            if (BeanUtils.isNotEmpty(linkMap) && (busLink = linkMap.get(def.get("alias").asText())) != null) {
                boolean isNumber = "number".equals(JsonUtil.getString((JsonNode)boEnt, (String)"pkType"));
                String string = id = isNumber ? busLink.getBusinesskey().toString() : busLink.getBusinesskeyStr();
            }
            if (def != null && def.has("supportDb") && !def.get("supportDb").asBoolean()) {
                saveType = "boObject";
            }
            ObjectNode formRestParam = JsonUtil.getMapper().createObjectNode();
            if (StringUtil.isEmpty((String)nodeId)) {
                nodeId = JsonUtil.getString((JsonNode)boData, (String)"nodeId");
            }
            formRestParam.put("boid", id);
            formRestParam.put("defId", def.get("id").asText());
            formRestParam.set("boData", (JsonNode)boData);
            formRestParam.put("saveType", saveType);
            formRestParam.put("flowDefId", instance.getProcDefId());
            formRestParam.put("flowKey", instance.getProcDefKey());
            formRestParam.put("nodeId", nodeId);
            formRestParam.put("hasCheckFormDataRev", checkFormDataRev);
            Object formPermission = ContextThreadUtil.getCommuVar("formPermission", "");
            if (BeanUtils.isNotEmpty((Object)formPermission)) {
                try {
                    JsonNode permissionNode = JsonUtil.toJsonNode((String)formPermission.toString());
                    if (permissionNode.has("desensitization")) {
                        formRestParam.put("desensitization", permissionNode.get("desensitization").toString());
                    }
                    if (permissionNode.has("formType")) {
                        formRestParam.put("formType", permissionNode.get("formType").asText());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (BeanUtils.isNotEmpty((Object)actionCmd)) {
                formRestParam.put("formkey", actionCmd.getFormKey());
            }
            if (StringUtil.isEmpty((String)id)) {
                formRestParam.put("updateSubTableJson", ThreadMsgUtil.getMapMsg((String)"updateSubTableJson"));
            }
            formRestParams.add(formRestParam);
        }
        return formRestParams;
    }
}

