/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.AopType;
import com.hotent.bpm.api.event.DoNextEvent;
import com.hotent.bpm.api.event.DoNextModel;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.listener.BusDataUtil;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class DoNextEventListener
implements ApplicationListener<DoNextEvent>,
Ordered {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmInstService bpmInstService;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(DoNextEvent ev) {
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"is_start_process", (boolean)true))) {
            return;
        }
        DoNextModel model = (DoNextModel)ev.getSource();
        this.setBuinessKey(model);
        if (AopType.PREVIOUS.equals((Object)model.getAopType())) {
            try {
                this.before(model);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.after(model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setBuinessKey(DoNextModel model) {
        TaskFinishCmd cmd = model.getTaskFinishCmd();
        if (!(cmd instanceof TaskFinishCmd)) {
            return;
        }
        DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)cmd.getTransitVars("processInstance");
        if (!"pk".equals(inst.getDataMode())) {
            return;
        }
        String pkInst = inst.getBizKey();
        if (StringUtil.isNotEmpty((String)pkInst)) {
            cmd.setBusinessKey(pkInst);
            cmd.setSysCode(inst.getSysCode());
        }
    }

    private void before(DoNextModel model) throws Exception {
        this.checkFlowIsValid(model);
        this.saveBusLink(model);
        this.executeHandler(model, true);
    }

    private void checkFlowIsValid(DoNextModel model) {
        BpmTask bpmTask = (BpmTask)model.getTaskFinishCmd().getTransitVars("bpmTask_");
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(bpmTask.getProcInstId());
        if (isForbindden) {
            throw new WorkFlowException("\u6d41\u7a0b\u5df2\u7ecf\u88ab\u7981\u6b62\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    private void saveBusLink(DoNextModel model) throws Exception {
        DefaultTaskFinishCmd cmd;
        DefaultTaskFinishCmd actionCmd = cmd = (DefaultTaskFinishCmd)model.getTaskFinishCmd();
        BpmProcessInstance instance = (BpmProcessInstance)actionCmd.getTransitVars("processInstance");
        String dataMode = instance.getDataMode();
        Object taskObj = cmd.getTransitVars("bpmTask_");
        if (BeanUtils.isNotEmpty((Object)taskObj) && taskObj instanceof DefaultBpmTask && this.bpmTaskManager.checkNodeIsUrlForm((DefaultBpmTask)taskObj, instance).booleanValue()) {
            return;
        }
        if ("pair".equals(dataMode)) {
            BusDataUtil.handExt(cmd);
        } else if ("bo".equals(dataMode)) {
            BusDataUtil.handSaveBoData(instance, actionCmd);
        } else if ("pk".equals(dataMode)) {
            // empty if block
        }
    }

    private void after(DoNextModel model) throws Exception {
        this.executeHandler(model, false);
    }

    private NodeProperties getNodeProperties(DoNextModel model) throws Exception {
        TaskFinishCmd cmd = model.getTaskFinishCmd();
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
        String nodeId = bpmTask.getNodeId();
        String defId = instance.getProcDefId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        NodeProperties nodeProperties = null;
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            BpmProcessInstance parentInst = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()));
            if (BeanUtils.isEmpty((Object)bpmNodeDef)) {
                bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(parentInst.getProcDefId(), nodeId);
            }
            String defKey = parentInst.getProcDefKey();
            nodeProperties = bpmNodeDef.getPropertiesByParentDefKey(defKey);
        }
        if (nodeProperties == null) {
            nodeProperties = bpmNodeDef.getLocalProperties();
        }
        return nodeProperties;
    }

    private void executeHandler(DoNextModel model, boolean isBefore) throws Exception {
        TaskFinishCmd cmd;
        TaskFinishCmd actionCmd = cmd = model.getTaskFinishCmd();
        NodeProperties properties = this.getNodeProperties(model);
        BusDataUtil.executeHandler(properties, actionCmd, isBefore);
    }
}

