/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.InterfaceEventPostAsync;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.InterPoseType;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.NodeNotifyEvent;
import com.hotent.bpm.api.event.NodeNotifyModel;
import com.hotent.bpm.api.event.TaskCompleteEvent;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.BpmTaskTurn;
import com.hotent.bpm.api.model.process.task.SkipResult;
import com.hotent.bpm.api.service.ActiviService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.TaskCommuService;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.engine.task.skip.SkipConditionUtil;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.ActExecutionManager;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.manager.TaskFollowManager;
import com.hotent.bpm.persistence.model.BpmInterposeRecored;
import com.hotent.bpm.persistence.model.BpmTaskDueTime;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.TaskFollow;
import com.hotent.bpm.persistence.util.ServiceUtil;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.todo.vo.PendingTask;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.uc.api.impl.service.UserServiceImpl;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class TaskCompleteEventListener
implements ApplicationListener<TaskCompleteEvent>,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(TaskCompleteEventListener.class);
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    TaskCommuService taskCommuService;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    PortalFeignService PortalFeignService;
    @Resource
    TaskFollowManager taskFollowManager;
    @Resource
    ActiviService activiService;
    @Autowired
    PortalFeignService portalFeignService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    UserServiceImpl userServiceImpl;

    public int getOrder() {
        return 1;
    }

    @InterfaceEventPostAsync
    public void onApplicationEvent(TaskCompleteEvent event) {
        BpmDelegateTask delegateTask = (BpmDelegateTask)event.getSource();
        String currentNodeId = delegateTask.getTaskDefinitionKey();
        String currentExecutionId = delegateTask.getExecutionId();
        String instId = (String)delegateTask.getVariable("instanceId_");
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        String rejectTargetNodeId = cmd.getDestination();
        NodeStatus nodeStatus = this.getNodeStatus(cmd);
        String bpmnTaskId = cmd.getTaskId();
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(bpmnTaskId);
        BpmDelegateTask task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
        cmd.getTransitVars().put("cur_node_path_id", bpmTask.getNodeId());
        if (!task.getExecutionId().equals(bpmTask.getExecId())) {
            bpmTask.setExecId(task.getExecutionId());
            this.bpmTaskManager.update((Model)bpmTask);
        }
        Boolean isSub = null;
        try {
            isSub = this.handleIsSub(delegateTask);
            if (isSub.booleanValue()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("subCreaterAccount", ContextUtil.getCurrentUser().getAccount());
                map.put("subCreaterName", ContextUtil.getCurrentUser().getFullname());
                map.put("subCreaterID", ContextUtil.getCurrentUser().getUserId());
                this.natProInstanceService.setVariable(delegateTask.getExecutionId(), delegateTask.getExecutionId(), map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        String skipType = (String)actionCmd.getTransitVars().get("skipType_");
        try {
            this.followTask(cmd, bpmTask.getNodeId());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.delCandidateAndTask(bpmTask.getOwnerId(), bpmnTaskId);
        try {
            this.updateCheckOpinion(cmd, skipType);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2.getMessage());
        }
        this.updateProcStatus(instId, delegateTask, nodeStatus, actionCmd);
        this.updTaskTurnComplte(cmd.getTaskId());
        this.updTaskCommuComplete(bpmTask.getId());
        this.updProcessInstance(cmd);
        BpmNodeDef bpmNodeDef = null;
        try {
            this.updDueTime(bpmTask);
            bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
            if (NodeType.USERTASK.getKey().equals(bpmNodeDef.getType().getKey()) && (BeanUtils.isEmpty((Object)cmd.getTransitVars("IsDoneUnused")) || !((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue()) && !((Boolean)cmd.getTransitVars("back_other_task_cancle", false)).booleanValue()) {
                com.hotent.bpm.persistence.util.BpmUtil.autoTrans(bpmNodeDef, instId, bpmTask.getId());
            }
            if (!bpmNodeDef.isFirstNode() || !SkipResult.SKIP_FIRST.equals(skipType)) {
                TodoPushUtil.taskToHandled(bpmTask);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e1));
        }
        this.updateInstanceSubject(bpmTask.getProcInstId(), bpmTask.getNodeId());
        if (BeanUtils.isEmpty((Object)skipType)) {
            NodeNotifyModel model = new NodeNotifyModel(bpmTask.getNodeId(), EventType.TASK_COMPLETE_EVENT, bpmTask.getProcInstId(), cmd);
            model.setSubject(bpmTask.getSubject());
            model.setOpinion(cmd.getApprovalOpinion());
            NodeNotifyEvent ev = new NodeNotifyEvent(model);
            AppUtil.publishEvent((ApplicationEvent)ev);
        }
    }

    private void updateInstanceSubject(String instId, String nodeId) {
        try {
            BpmNodeDef startNode;
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), nodeId);
            List<BpmNodeDef> incomeNodes = nodeDef.getIncomeNodes();
            if (BeanUtils.isNotEmpty(incomeNodes) && BeanUtils.isNotEmpty((Object)(startNode = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId()).getStartEvent()))) {
                boolean fromStart = false;
                for (BpmNodeDef bpmNodeDef : incomeNodes) {
                    if (!startNode.getNodeId().equals(bpmNodeDef.getNodeId())) continue;
                    fromStart = true;
                    break;
                }
                if (fromStart) {
                    ActionCmd cmd = ContextThreadUtil.getActionCmd();
                    if (BeanUtils.isNotEmpty((Object)instance)) {
                        BpmProcessDef<BpmProcessDefExt> bpmDefinition = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId());
                        DefaultProcessInstCmd cInstCmd = new DefaultProcessInstCmd();
                        cInstCmd.setFlowKey(instance.getProcDefKey());
                        cInstCmd.setBusData(cmd.getBusData());
                        cInstCmd.setVariables(cmd.getVariables());
                        cInstCmd.putTransitVars(cmd.getTransitVars());
                        cInstCmd.setInstId(instance.getId());
                        cInstCmd.setBusinessKey(instance.getBizKey());
                        instance.setUpdateSubjectWhenExist(true);
                        String subject = this.bpmProcessInstanceManager.getSubject(bpmDefinition, cInstCmd, instance);
                        instance.setSubject(subject);
                        this.bpmProcessInstanceManager.update((Model)instance);
                        cmd.addTransitVars("processInstance", instance);
                        TodoPushUtil.updateProcessStatus(instance);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException("\u66f4\u65b0\u5b9e\u4f8b\u6807\u9898\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public void followTask(TaskFinishCmd cmd, String nodeId) throws Exception {
        if (cmd.getActionName().equals("agree") || cmd.getActionName().equals("reject")) {
            QueryFilter build = QueryFilter.build();
            build.addFilter("PRO_INST_", (Object)cmd.getInstId(), QueryOP.EQUAL);
            build.addFilter("TASK_ID", (Object)nodeId, QueryOP.LIKE);
            PageList list = this.taskFollowManager.query(build);
            if (list.getRows().size() > 0) {
                List rows = list.getRows();
                DefaultBpmTask task = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
                BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                for (TaskFollow follow : rows) {
                    BpmTaskNotice taskNotice = new BpmTaskNotice(task.getName(), task.getSubject(), task.getProcInstId(), task.getProcDefId(), task.getProcDefKey(), task.getProcDefName(), "", "", TaskType.FOLLOW.getKey(), task.getSupportMobile(), "", "", null, task.getId(), null, null);
                    taskNotice.setId(UniqueIdUtil.getSuid());
                    taskNotice.setTaskId(task.getId());
                    taskNotice.setNodeId(nodeId);
                    com.hotent.bpm.persistence.util.BpmUtil.bpmTaskNoticeNodeSetHelper(taskNotice, null, task);
                    if (StringUtil.isNotEmpty((String)follow.getCreatorId())) {
                        String creatorId = follow.getCreatorId();
                        IUser user = ServiceUtil.getUserById(creatorId);
                        if (BeanUtils.isNotEmpty((Object)user)) {
                            taskNotice.setOwnerName(user.getFullname());
                            taskNotice.setAssigneeName(user.getFullname());
                        }
                        taskNotice.setOwnerId(creatorId);
                        taskNotice.setAssigneeId(creatorId);
                    }
                    taskNotice.setIsRead(0);
                    noticeManager.create((Model)taskNotice);
                    PendingTask pTask = new PendingTask();
                    pTask.setId(taskNotice.getId());
                    pTask.setProcInstId(cmd.getInstId());
                    pTask.setDefId(task.getProcDefId());
                    pTask.setName(task.getName());
                    pTask.setSubject(task.getSubject());
                    if (StringUtil.isNotEmpty((String)follow.getCreatorId())) {
                        String creatorId = follow.getCreatorId();
                        IUser user = this.userServiceImpl.getUserById(creatorId);
                        if (BeanUtils.isNotEmpty((Object)user)) {
                            pTask.setOwnerName(user.getFullname());
                        }
                        pTask.setOwnerId(creatorId);
                        pTask.setOwnerAccount(user.getAccount());
                    }
                    pTask.setCreateTime(LocalDateTime.now());
                    pTask.setType("follow");
                    pTask.setTaskStatus("START");
                    pTask.setIsRead(0);
                    pTask.setSupportMobile(taskNotice.getSupportMobile());
                    pTask.setProcDefKey(task.getProcDefKey());
                    pTask.setProcDefName(task.getProcDefName());
                    TodoPushUtil.addTodoToPortal(pTask);
                }
            }
        }
    }

    private void updDueTime(BpmTask bpmTask) throws Exception {
        BpmTaskDueTime bpmTaskDueTime = this.bpmTaskDueTimeManager.getByTaskId(bpmTask.getId());
        if (BeanUtils.isEmpty((Object)((Object)bpmTaskDueTime))) {
            return;
        }
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(this.PortalFeignService.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0) {
            remainingTime = 0;
        }
        bpmTaskDueTime.setRemainingTime(remainingTime);
        this.bpmTaskDueTimeManager.update((Model)bpmTaskDueTime);
    }

    public Boolean handleIsSub(BpmDelegateTask delegateTask) throws Exception {
        BpmProcessDef<?> procDef;
        List<BpmNodeDef> bpmNodeDefList;
        BpmNodeDef startNode;
        String nodeId = delegateTask.getTaskDefinitionKey();
        String supperExeId = delegateTask.getSupperExecutionId();
        String bpmnDefId = delegateTask.getBpmnDefId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionService.getBpmNodeDef(bpmnDefId, nodeId);
        BpmNodeDef parentBpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
        if ((StringUtil.isNotEmpty((String)supperExeId) || BeanUtils.isNotEmpty((Object)parentBpmNodeDef) && parentBpmNodeDef instanceof SubProcessNodeDef) && (startNode = (bpmNodeDefList = (procDef = bpmNodeDef.getBpmProcessDef()).getStartNodes()).get(0)).getNodeId().equals(nodeId)) {
            return true;
        }
        return false;
    }

    private void updProcessInstance(TaskFinishCmd cmd) {
        DefaultBpmProcessInstance bpmProcessInstance = (DefaultBpmProcessInstance)cmd.getTransitVars("processInstance");
        ProcessInstanceStatus status = this.getInstStatus(cmd);
        if (!status.getKey().equals(bpmProcessInstance.getStatus())) {
            bpmProcessInstance.setStatus(status.getKey());
            this.bpmProcessInstanceManager.update((Model)bpmProcessInstance);
            TodoPushUtil.updateProcessStatus(bpmProcessInstance);
        }
        if (ProcessInstanceStatus.STATUS_END.getKey().equals(status.getKey())) {
            this.taskFollowManager.remove((Serializable)((Object)bpmProcessInstance.getId()));
        }
    }

    private void updTaskCommuComplete(String taskId) {
        this.taskCommuService.finishTask(taskId);
    }

    private void updTaskTurnComplte(String taskId) {
        IUser user = ContextUtil.getCurrentUser();
        this.bpmTaskTurnManager.updComplete(taskId, user);
    }

    private ProcessInstanceStatus getInstStatus(TaskFinishCmd cmd) {
        ProcessInstanceStatus status = ProcessInstanceStatus.STATUS_RUNNING;
        switch (cmd.getActionType()) {
            case APPROVE: {
                status = ProcessInstanceStatus.STATUS_RUNNING;
                break;
            }
            case BACK_TO_START: {
                status = ProcessInstanceStatus.STATUS_BACK_TOSTART;
                break;
            }
            case BACK: {
                status = ProcessInstanceStatus.STATUS_BACK;
                break;
            }
            case RECOVER: {
                status = ProcessInstanceStatus.STATUS_REVOKE;
                break;
            }
            case RECOVER_TO_START: {
                status = ProcessInstanceStatus.STATUS_REVOKE_TOSTART;
            }
        }
        return status;
    }

    private NodeStatus getNodeStatus(TaskFinishCmd cmd) {
        NodeStatus nodeStatus = NodeStatus.AGREE;
        NodeStatus backNodeStatus = BpmUtil.getBackNodeStatus(cmd);
        if (backNodeStatus != null) {
            return backNodeStatus;
        }
        switch (cmd.getActionType()) {
            case APPROVE: {
                nodeStatus = NodeStatus.fromKey(cmd.getActionName());
                break;
            }
            case BACK_TO_START: {
                nodeStatus = NodeStatus.BACK_TO_START;
                break;
            }
            case BACK: {
                nodeStatus = NodeStatus.BACK;
                break;
            }
            case RECOVER_TO_START: {
                nodeStatus = NodeStatus.RECOVER_TO_START;
                break;
            }
            case RECOVER: {
                nodeStatus = NodeStatus.RECOVER;
            }
        }
        return nodeStatus;
    }

    private void updateCheckOpinion(TaskFinishCmd cmd, String skipType) throws Exception {
        boolean isSkip = BeanUtils.isNotEmpty((Object)skipType);
        DefaultBpmTask bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        String status = this.getStatus(cmd, isSkip);
        this.updateCheckOpinion(cmd, bpmTask, status, isSkip, skipType);
    }

    private void updateCheckOpinion(TaskFinishCmd cmd, DefaultBpmTask bpmTask, String status, boolean isSkip, String skipType) throws Exception {
        DefaultBpmCheckOpinion bpmCheckOpinion;
        if (OpinionStatus.SIGN_BACK_CANCEL.getKey().equals(status) || OpinionStatus.SIGN_RECOVER_CANCEL.getKey().equals(status)) {
            List<DefaultBpmTask> childsTasks = this.bpmTaskManager.getChildsByTaskId(bpmTask.getId());
            for (int i = 0; i < childsTasks.size(); ++i) {
                this.updateCheckOpinion(cmd, childsTasks.get(i), status, isSkip, skipType);
            }
            this.bpmTaskManager.delByParentId(bpmTask.getId());
        }
        if ((bpmCheckOpinion = this.bpmCheckOpinionManager.getByTaskId(bpmTask.getId())) == null) {
            return;
        }
        BpmCheckOpinionUtil.updateExtraPropCheckOpinion(bpmCheckOpinion, bpmTask);
        if (StringUtil.isNotEmpty((String)cmd.getInterPoseOpinion())) {
            this.bpmCheckOpinionManager.remove((Serializable)((Object)bpmCheckOpinion.getId()));
            BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(bpmTask.getProcInstId(), cmd.getInterPoseOpinion(), InterPoseType.fromKey(cmd.getActionName()), (String)cmd.getTransitVars("bpm_opinion_is_done"));
            BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
            bpmInterposeRecored.setTaskName(bpmTask.getName());
            bpmInterposeRecored.setFiles(cmd.getFiles());
            manager.create((Model)bpmInterposeRecored);
            return;
        }
        IUser user = ContextUtil.getCurrentUser();
        bpmCheckOpinion.setStatus(status);
        bpmCheckOpinion.setCompleteTime(LocalDateTime.now());
        long durMs = TimeUtil.getTime((LocalDateTime)bpmCheckOpinion.getCompleteTime(), (LocalDateTime)bpmCheckOpinion.getCreateTime());
        bpmCheckOpinion.setDurMs(durMs);
        if (isSkip && SkipResult.SKIP_EMPTY_USER.equals(skipType)) {
            bpmCheckOpinion.setAuditor("");
            bpmCheckOpinion.setAuditorName("");
        } else if (SkipResult.SKIP_APPROVER.equals(skipType)) {
            bpmCheckOpinion.setAuditor(String.valueOf(ContextThreadUtil.getCommuVar("Auditor", "")));
            bpmCheckOpinion.setAuditorName(String.valueOf(ContextThreadUtil.getCommuVar("auditorName", "")));
        } else if (SkipResult.SKIP_AUTO_RUN.equals(skipType)) {
            bpmCheckOpinion.setAuditor(String.valueOf(ContextThreadUtil.getCommuVar("autoRunAuditor", "")));
            bpmCheckOpinion.setAuditorName(String.valueOf(ContextThreadUtil.getCommuVar("autoRunAuditorName", "")));
        } else {
            String userId = "-1";
            String userName = "\u7cfb\u7edf";
            if (user != null) {
                userId = user.getUserId();
                userName = user.getFullname();
            }
            bpmCheckOpinion.setAuditor(userId);
            bpmCheckOpinion.setAuditorName(userName);
        }
        String opinion = cmd.getApprovalOpinion();
        if (isSkip) {
            if (SkipResult.SKIP_FIRST.equals(skipType)) {
                opinion = "\u8df3\u8fc7\u7b2c\u4e00\u4e2a\u4efb\u52a1\u8282\u70b9";
            } else if (SkipResult.SKIP_EMPTY_USER.equals(skipType)) {
                opinion = "\u6267\u884c\u4eba\u4e3a\u7a7a";
            } else if (SkipResult.SKIP_SAME_USER.equals(skipType)) {
                opinion = "\u548c\u4e0a\u4e00\u4e2a\u8282\u70b9\u6267\u884c\u4eba\u76f8\u540c\u8df3\u8fc7!";
            } else if (SkipResult.SKIP_APPROVER.equals(skipType)) {
                opinion = "\u5ba1\u6279\u8df3\u8fc7";
            } else if (SkipResult.SKIP_AUTO_RUN.equals(skipType)) {
                opinion = SkipConditionUtil.getOpinion(bpmTask, skipType);
            }
            bpmCheckOpinion.setSkipType(skipType);
            bpmCheckOpinion.setCompleteTime(TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)0, (int)1, (long)TimeUtil.getCurrentTimeMillis())));
        }
        if (OpinionStatus.BACK_TO_START.getKey().equals(status) || OpinionStatus.REJECT.getKey().equals(status)) {
            Object backHandMode = cmd.getTransitVars("backHandMode");
            if (BeanUtils.isNotEmpty((Object)backHandMode) && "normal".equals(backHandMode)) {
                bpmCheckOpinion.setInterpose(1);
            } else {
                bpmCheckOpinion.setInterpose(2);
            }
        }
        bpmCheckOpinion.setFormName(cmd.getOpinionIdentity());
        bpmCheckOpinion.setOpinion(opinion);
        bpmCheckOpinion.setFiles(cmd.getFiles());
        bpmCheckOpinion.setZfiles(cmd.getZfiles());
        if (StringUtil.isNotEmpty((String)cmd.getAgentLeaderId()) && !"0".equals(cmd.getAgentLeaderId())) {
            bpmCheckOpinion.setAgentLeaderId(cmd.getAgentLeaderId());
        }
        if (StringUtil.isNotEmpty((String)cmd.getBusData())) {
            try {
                bpmCheckOpinion.setFormData(Base64.getBase64((String)cmd.getBusData()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (BeanUtils.isNotEmpty(cmd.getVariables())) {
            try {
                Map<String, Object> variables = cmd.getVariables();
                Object restful_task = null;
                if (variables.containsKey("restful_task")) {
                    restful_task = variables.get("restful_task");
                    variables.remove("restful_task");
                }
                JsonNode jsonNode = JsonUtil.toJsonNode(variables);
                bpmCheckOpinion.setVars(Base64.getBase64((String)JsonUtil.toJson(cmd.getVariables())));
                if (BeanUtils.isNotEmpty((Object)restful_task)) {
                    variables.put("restful_task", restful_task);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        cmd.addVariable("pre_bpm_check_opinion_id", bpmCheckOpinion.getId());
        this.bpmCheckOpinionManager.update((Model)bpmCheckOpinion);
    }

    private String getStatus(TaskFinishCmd cmd, boolean isSkip) {
        if (isSkip) {
            return OpinionStatus.SKIP.getKey();
        }
        OpinionStatus backOpinionStatus = BpmUtil.getBackOpinionStatus(cmd);
        if (backOpinionStatus != null) {
            return backOpinionStatus.getKey();
        }
        try {
            BpmTaskTurn bpmTaskTurn = this.bpmTaskTurnManager.getByTaskId(cmd.getTaskId());
            if (bpmTaskTurn != null) {
                String status = cmd.getActionName();
                if (status.equals("agree")) {
                    return OpinionStatus.DELIVERTO_AGREE.getKey();
                }
                if (status.equals("oppose")) {
                    return OpinionStatus.DELIVERTO_OPPOSE.getKey();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd.getActionName();
    }

    private void delCandidateAndTask(String ownerId, String taskId) {
        if ("0".equals(ownerId)) {
            this.bpmTaskCandidateManager.removeByTaskId(taskId);
        }
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
    }

    private void updateProcStatus(String instId, BpmDelegateTask delegateTask, NodeStatus nodeStatus, ActionCmd actionCmd) {
        String bpmnDefId = delegateTask.getBpmnDefId();
        String nodeId = delegateTask.getTaskDefinitionKey();
        MultiInstanceType type = delegateTask.multiInstanceType();
        if (MultiInstanceType.NO.equals((Object)type)) {
            this.bpmProStatusManager.createOrUpd(instId, bpmnDefId, nodeId, delegateTask.getName(), nodeStatus);
        }
    }
}

