/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.NoExecutorModel;
import com.hotent.bpm.api.event.TaskCreateEvent;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.SkipResult;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.NodeEmptyUserService;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.exception.NoTaskUserException;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TaskCreateEventListener
implements ApplicationListener<TaskCreateEvent>,
Ordered {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmProcessInstanceManager instanceManager;
    @Resource
    NodeEmptyUserService nodeEmptyUserService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(TaskCreateEvent ev) {
        try {
            boolean isAllowEmptyIdentity;
            BpmProcessInstance instance;
            JsonNode jsonNode;
            Map<String, Object> variables;
            String nodeUserStr;
            BpmDelegateTask delegateTask = (BpmDelegateTask)ev.getSource();
            String instId = (String)delegateTask.getVariable("instanceId_");
            String subject = (String)delegateTask.getVariable("subject_");
            String nodeId = delegateTask.getTaskDefinitionKey();
            ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
            if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
                ThreadMsgUtil.addMapMsg((String)"bpmTask_", (String)delegateTask.getId());
            }
            List<Object> identityList = new ArrayList();
            Map nodeUsers = (Map)taskCmd.getTransitVars("bpm_node_users_");
            if (BeanUtils.isEmpty((Object)nodeUsers) && StringUtil.isNotEmpty((String)(nodeUserStr = (String)(variables = taskCmd.getVariables()).get("bpm_node_users_"))) && (jsonNode = JsonUtil.toJsonNode((String)nodeUserStr)).has(nodeId)) {
                ArrayNode jsonNode2 = (ArrayNode)jsonNode.get(nodeId);
                for (JsonNode jsonNode3 : jsonNode2) {
                    DefaultBpmIdentity identity = (DefaultBpmIdentity)JsonUtil.toBean((JsonNode)jsonNode3, DefaultBpmIdentity.class);
                    identityList.add(identity);
                }
            }
            if (taskCmd.getTransitVars("bpm_next_node_users_") != null) {
                identityList = (List)taskCmd.getTransitVars("bpm_next_node_users_");
            }
            if (nodeUsers != null && nodeUsers.containsKey(nodeId)) {
                identityList = (List)nodeUsers.get(nodeId);
            }
            if (BeanUtils.isEmpty(identityList)) {
                identityList = delegateTask.getExecutors();
            }
            if (BeanUtils.isEmpty(identityList)) {
                Map<String, List<BpmIdentity>> identityMap = taskCmd.getBpmIdentities();
                identityList = identityMap.get(nodeId);
            }
            if (BeanUtils.isEmpty((Object)(instance = (BpmProcessInstance)taskCmd.getTransitVars("processInstance"))) || !instId.equals(instance.getId())) {
                instance = (BpmProcessInstance)this.instanceManager.get((Serializable)((Object)instId));
            }
            if (!(isAllowEmptyIdentity = BpmUtil.isAllowEmptyIdentity(instance, nodeId)) && BeanUtils.isEmpty(identityList)) {
                NoExecutorModel noExcutor = NoExecutorModel.getNoExecutorModel(delegateTask.getId(), delegateTask.getProcessInstanceId(), subject, delegateTask.getTaskDefinitionKey(), delegateTask.getName(), delegateTask.getBpmnDefId());
                BpmUtil.publishNoExecutorEvent(noExcutor);
                String msg = "\u3010" + delegateTask.getName() + "\u3011\u6ca1\u6709\u4efb\u52a1\u6267\u884c\u4eba";
                ThreadMsgUtil.addMapMsg((String)"msg_flow_error", (String)msg);
                throw new NoTaskUserException(msg);
            }
            DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(delegateTask.getId());
            BpmNodeDef bpmNodeDef = null;
            bpmNodeDef = BeanUtils.isNotEmpty((Object)bpmTask) ? this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId()) : this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), delegateTask.getTaskDefinitionKey());
            List<Object> userList = new ArrayList();
            if (BeanUtils.isNotEmpty(identityList)) {
                userList = this.bpmIdentityExtractService.extractUser(identityList);
            }
            if (BeanUtils.isEmpty(userList) && isAllowEmptyIdentity) {
                identityList = this.nodeEmptyUserService.handleByBpmNodeDef(bpmNodeDef, delegateTask);
            }
            this.handleOutSubFlowSubjectAndOpinion(bpmNodeDef, instance, identityList);
            this.addOpinion(delegateTask, identityList);
            this.bpmTaskManager.assignUser(delegateTask, identityList, null);
            this.bpmProStatusManager.createOrUpd(instId, delegateTask.getBpmnDefId(), nodeId, delegateTask.getName(), NodeStatus.PENDING);
            this.sendTodoToPortal(instance.getId(), delegateTask);
            if (!OpinionStatus.REJECT.getKey().equals(taskCmd.getActionName()) || !"direct".equals(taskCmd.getTransitVars("backHandMode")) && BeanUtils.isNotEmpty((Object)instance)) {
                String[] names = new String[]{"bpm_node_users_" + nodeId, "bpm_destination_" + nodeId};
                delegateTask.removeVariables(Arrays.asList(names));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void sendTodoToPortal(String instId, BpmDelegateTask delegateTask) {
        String subject = (String)delegateTask.getVariable("subject_");
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        try {
            BpmTask o = (BpmTask)taskCmd.getTransitVars().get("bpmTask_");
            if (BeanUtils.isNotEmpty((Object)o)) {
                BpmUtil.setTaskSkip(o);
                SkipResult skipResult = o.getSkipResult();
                if (!skipResult.isSkipTask() || Objects.equals("RECOVER", o.getStatus())) {
                    TodoPushUtil.addTodoToPortal(delegateTask, instId, subject);
                }
            }
        }
        catch (Exception e) {
            throw new WorkFlowException("\u63a8\u9001\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void handleOutSubFlowSubjectAndOpinion(BpmNodeDef bpmNodeDef, BpmProcessInstance instance, List<BpmIdentity> identityList) {
        UCFeignService ucFeignService;
        ObjectNode mainGroup;
        if (BeanUtils.isEmpty((Object)instance) || StringUtil.isEmpty((String)instance.getSuperNodeId()) || !(instance instanceof DefaultBpmProcessInstance)) {
            return;
        }
        if (bpmNodeDef.getIncomeNodes().size() != 1 || !bpmNodeDef.getIncomeNodes().get(0).getType().getKey().equals(NodeType.START.getKey())) {
            return;
        }
        if (BeanUtils.isEmpty(identityList) || identityList.size() > 1 || !identityList.get(0).getType().equals("user")) {
            return;
        }
        IUser user = this.userServiceImpl.getUserById(identityList.get(0).getId());
        DefaultBpmProcessInstance defaultInstance = (DefaultBpmProcessInstance)instance;
        defaultInstance.setCreateBy(user.getUserId());
        defaultInstance.setCreator(user.getFullname());
        defaultInstance.setCreateAccount(user.getAccount());
        try {
            ActionCmd subCmd = ContextThreadUtil.getActionCmd();
            DefaultProcessInstCmd cInstCmd = new DefaultProcessInstCmd();
            cInstCmd.setFlowKey(instance.getProcDefKey());
            cInstCmd.setBusData(subCmd.getBusData());
            cInstCmd.setVariables(subCmd.getVariables());
            cInstCmd.putTransitVars(subCmd.getTransitVars());
            cInstCmd.setInstId(instance.getId());
            cInstCmd.setBusinessKey(instance.getBizKey());
            BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId());
            String subject = this.bpmProcessInstanceManager.getSubject(bpmProcessDef, cInstCmd, defaultInstance);
            defaultInstance.setSubject(subject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DefaultBpmDefinition definition = ((BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class)).getMainByDefKey(instance.getProcDefKey(), false);
        if (BeanUtils.isNotEmpty((Object)definition)) {
            defaultInstance.setTypeId(definition.getTypeId());
        }
        if (BeanUtils.isNotEmpty((Object)(mainGroup = (ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class)).getMainGroup(user.getUserId())))) {
            defaultInstance.setCreateOrgPath(JsonUtil.getStrByPath((JsonNode)mainGroup, (String)"path"));
            defaultInstance.setCreateOrgId(JsonUtil.getStrByPath((JsonNode)mainGroup, (String)"id"));
        }
        this.bpmProcessInstanceManager.update((Model)defaultInstance);
        List opinions = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bpmCheckOpinionManager.lambdaQuery().eq(DefaultBpmCheckOpinion::getProcInstId, (Object)instance.getId())).eq(DefaultBpmCheckOpinion::getStatus, (Object)OpinionStatus.START.getKey())).list();
        if (BeanUtils.isEmpty((Object)opinions)) {
            return;
        }
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)opinions.get(0);
        defaultBpmCheckOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        defaultBpmCheckOpinion.setQualfiedNames(user.getFullname());
        defaultBpmCheckOpinion.setAuditor(user.getUserId());
        defaultBpmCheckOpinion.setAuditorName(user.getFullname());
        this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
    }

    private void addOpinion(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) {
        String ids = "";
        String names = "";
        if (BeanUtils.isNotEmpty(identityList)) {
            ids = BpmCheckOpinionUtil.getIdentityIds(identityList);
            names = BpmCheckOpinionUtil.getIdentityNames(identityList);
        }
        String instId = (String)delegateTask.getVariable("instanceId_");
        DefaultBpmCheckOpinion bpmCheckOpinion = BpmCheckOpinionUtil.buildBpmCheckOpinion(delegateTask, instId);
        bpmCheckOpinion.setQualfieds(ids);
        bpmCheckOpinion.setQualfiedNames(names);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        this.setSignType(bpmCheckOpinion, cmd);
        if (cmd instanceof TaskFinishCmd) {
            bpmCheckOpinion.setParentTaskId(((TaskFinishCmd)cmd).getTaskId());
        }
        this.bpmCheckOpinionManager.create((Model)bpmCheckOpinion);
    }

    private void setSignType(DefaultBpmCheckOpinion bpmCheckOpinion, ActionCmd cmd) {
        Object opinionSignType = cmd.getTransitVars("opinion_sign_type");
        if (BeanUtils.isNotEmpty((Object)opinionSignType)) {
            bpmCheckOpinion.setSignType("BeforeSign");
        } else {
            String id;
            DefaultBpmCheckOpinion defaultBpmCheckOpinion;
            Map<String, Object> variables = cmd.getVariables();
            if (variables.containsKey("pre_bpm_check_opinion_id") && BeanUtils.isNotEmpty((Object)variables.get("pre_bpm_check_opinion_id")) && BeanUtils.isNotEmpty((Object)(defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)(id = String.valueOf(variables.get("pre_bpm_check_opinion_id"))))))) && StringUtil.isNotEmpty((String)defaultBpmCheckOpinion.getSignType())) {
                bpmCheckOpinion.setSignType("AfterSign");
            }
        }
    }
}

