/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.model.identity;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.util.LinkedHashSet;

public class DefaultBpmIdentity
implements BpmIdentity,
Serializable {
    private static final long serialVersionUID = 4416404339210896051L;
    private String id;
    private String code;
    private String name;
    private String type;
    private String groupType;
    private ExtractType extractType;

    public DefaultBpmIdentity() {
    }

    public DefaultBpmIdentity(IGroup group) {
        this.id = group.getGroupId();
        this.name = group.getName();
        this.code = group.getGroupCode();
        this.groupType = group.getGroupType();
        this.type = "group";
    }

    public DefaultBpmIdentity(String id, String name, String type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public static BpmIdentity getIdentityByUserId(String userId, String userName) {
        DefaultBpmIdentity identity = new DefaultBpmIdentity();
        identity.setId(userId);
        identity.setName(userName);
        identity.setType("user");
        return identity;
    }

    public DefaultBpmIdentity(IUser user) {
        this.id = user.getUserId();
        this.name = user.getFullname();
        this.code = user.getAccount();
        this.type = "user";
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getGroupType() {
        return this.groupType;
    }

    @Override
    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    @Override
    public ExtractType getExtractType() {
        return this.extractType;
    }

    @Override
    public void setExtractType(ExtractType extractType) {
        this.extractType = extractType;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    public int hashCode() {
        if ("user".equals(this.type) || "groupUser".endsWith(this.type)) {
            if (StringUtil.isNotEmpty((String)this.id)) {
                return this.id.hashCode() + this.type.hashCode();
            }
            return this.code.hashCode() + this.type.hashCode();
        }
        if ("group".equals(this.type)) {
            if (StringUtil.isNotEmpty((String)this.id)) {
                return this.id.hashCode() + this.groupType.hashCode();
            }
            if (StringUtil.isNotEmpty((String)this.code)) {
                return this.code.hashCode() + this.groupType.hashCode();
            }
            throw new BaseException("BpmIdentity\u7684id\u6216code\u4e2d\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u4e0d\u4e3a\u7a7a\u503c");
        }
        return this.id.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultBpmIdentity)) {
            return false;
        }
        DefaultBpmIdentity identity = (DefaultBpmIdentity)obj;
        if (BeanUtils.isEmpty((Object)identity)) {
            return false;
        }
        if ("user".equals(this.type) || "groupUser".endsWith(this.type)) {
            if (StringUtil.isNotEmpty((String)identity.getId())) {
                return identity.getId().equals(this.id);
            }
            return identity.getCode().equals(this.code);
        }
        if ("group".equals(this.type)) {
            boolean tmp = false;
            tmp = StringUtil.isNotEmpty((String)identity.getId()) ? identity.getId().equals(this.id) : identity.getCode().equals(this.code);
            return tmp && identity.getGroupType().equals(this.getGroupType());
        }
        return false;
    }

    public static void main(String[] args) {
        DefaultBpmIdentity id1 = new DefaultBpmIdentity();
        id1.setId("1");
        id1.setType("user");
        DefaultBpmIdentity id2 = new DefaultBpmIdentity();
        id2.setId("1");
        id2.setType("user");
        LinkedHashSet<DefaultBpmIdentity> list = new LinkedHashSet<DefaultBpmIdentity>();
        list.add(id1);
        list.add(id2);
        System.out.println(list.size());
    }
}

