/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.entity.AutoFillModel;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bpm.persistence.dao.BpmAgentDefDao;
import com.hotent.bpm.persistence.dao.BpmAgentSettingDao;
import com.hotent.bpm.persistence.manager.BpmAgentConditionManager;
import com.hotent.bpm.persistence.manager.BpmAgentSettingManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.BpmAgentCondition;
import com.hotent.bpm.persistence.model.BpmAgentDef;
import com.hotent.bpm.persistence.model.BpmAgentSetting;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.ResultMessage;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmAgentSettingManager")
public class BpmAgentSettingManagerImpl
extends BaseManagerImpl<BpmAgentSettingDao, BpmAgentSetting>
implements BpmAgentSettingManager {
    @Resource
    BpmAgentDefDao bpmAgentDefDao;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmAgentConditionManager bpmAgentConditionManager;
    @Resource
    IUserService userServiceImpl;

    @Transactional(readOnly=true)
    public PageList<BpmAgentSetting> query(QueryFilter<BpmAgentSetting> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage result = ((BpmAgentSettingDao)this.baseMapper).selectPage(this.convert2IPage(pageBean), this.convert2Wrapper(queryFilter, BpmAgentSetting.class));
        Set userIds = result.getRecords().stream().filter(r -> StringUtils.isNotEmpty((String)r.getCreateBy())).map(AutoFillModel::getCreateBy).collect(Collectors.toSet());
        if (BeanUtils.isNotEmpty(userIds)) {
            List users = this.userServiceImpl.getUserByIds(StringUtil.join(userIds));
            Map<String, IUser> userMap = users.stream().filter(u -> StringUtil.isNotEmpty((String)u.getUserId())).collect(Collectors.toMap(IUser::getUserId, u -> u, (u1, u2) -> u1));
            result.getRecords().stream().filter(r -> StringUtils.isNotEmpty((String)r.getCreateBy())).forEach(item -> item.setAccount(StrUtil.format((CharSequence)"{}\uff08{}\uff09", (Object[])new Object[]{((IUser)userMap.get(item.getCreateBy())).getFullname(), ((IUser)userMap.get(item.getCreateBy())).getAccount()})));
        }
        return new PageList(result);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        if (ids != null) {
            for (String pk : ids) {
                this.bpmAgentDefDao.removeBySettingId(pk);
                this.bpmAgentConditionManager.removeBySettingId(pk);
            }
        }
        super.removeByIds(ids);
    }

    @Override
    public BpmAgentSetting getById(String id) {
        BpmAgentSetting bpmAgentSetting = (BpmAgentSetting)super.get((Serializable)((Object)id));
        if (bpmAgentSetting != null) {
            if (BpmAgentSetting.TYPE_CONDITION.shortValue() == bpmAgentSetting.getType().shortValue()) {
                DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(bpmAgentSetting.getFlowKey());
                if (BeanUtils.isNotEmpty((Object)bpmDefinition)) {
                    bpmAgentSetting.setFlowName(bpmDefinition.getName());
                }
                List<BpmAgentCondition> conditionList = this.bpmAgentConditionManager.getBySettingId(id);
                for (BpmAgentCondition bpmAgentCondition : conditionList) {
                    IUser user = this.userServiceImpl.getUserById(bpmAgentCondition.getAgentId());
                    if (!BeanUtils.isNotEmpty((Object)user)) continue;
                    bpmAgentCondition.setAgentName(user.getFullname());
                }
                bpmAgentSetting.setConditionList(conditionList);
            } else {
                List<BpmAgentDef> defList = this.bpmAgentDefDao.getBySettingId(id);
                for (BpmAgentDef bpmAgentDef : defList) {
                    DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(bpmAgentDef.getFlowKey());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefinition)) continue;
                    bpmAgentDef.setFlowName(bpmDefinition.getName());
                }
                bpmAgentSetting.setDefList(defList);
            }
        }
        return bpmAgentSetting;
    }

    @Override
    public PageList<BpmAgentSetting> findAll(QueryFilter<BpmAgentSetting> queryFilter) {
        PageList<BpmAgentSetting> bpmAgentSettingList = this.query(queryFilter);
        List bpmAgentSettingListRows = bpmAgentSettingList.getRows();
        bpmAgentSettingListRows.forEach(bpmAgentSetting -> {
            List<BpmAgentDef> defList = this.bpmAgentDefDao.getBySettingId(bpmAgentSetting.getId());
            for (BpmAgentDef bpmAgentDef : defList) {
                DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(bpmAgentDef.getFlowKey());
                if (!BeanUtils.isNotEmpty((Object)bpmDefinition)) continue;
                bpmAgentDef.setFlowName(bpmDefinition.getName());
            }
            bpmAgentSetting.setDefList(defList);
        });
        return bpmAgentSettingList;
    }

    @Transactional
    public void create(BpmAgentSetting entity) {
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            String settingId = UniqueIdUtil.getSuid();
            entity.setId(settingId);
        }
        super.create((Model)entity);
        this.saveSub(entity);
    }

    private void saveSub(BpmAgentSetting entity) {
        List<BpmAgentCondition> conditionList;
        String settingId = entity.getId();
        List<BpmAgentDef> defList = entity.getDefList();
        if (BeanUtils.isNotEmpty(defList)) {
            for (BpmAgentDef def : defList) {
                def.setId(UniqueIdUtil.getSuid());
                def.setSettingId(settingId);
                this.bpmAgentDefDao.insert((Object)def);
            }
        }
        if (BeanUtils.isNotEmpty(conditionList = entity.getConditionList())) {
            for (BpmAgentCondition condition : conditionList) {
                condition.setId(UniqueIdUtil.getSuid());
                condition.setSettingId(settingId);
                this.bpmAgentConditionManager.create((Model)condition);
            }
        }
    }

    @Transactional
    public void update(BpmAgentSetting entity) {
        String settingId = entity.getId();
        super.update((Model)entity);
        this.bpmAgentConditionManager.removeBySettingId(settingId);
        this.bpmAgentDefDao.removeBySettingId(settingId);
        this.saveSub(entity);
    }

    @Override
    public BpmAgentSetting getSettingByFlowAndAuthidAndDate(String authId, String flowKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authid", authId);
        params.put("flowkey", flowKey);
        params.put("date", LocalDateTime.now());
        List<BpmAgentSetting> list = ((BpmAgentSettingDao)this.baseMapper).getSettingByFlowAndAuthidAndDate(authId, flowKey, LocalDateTime.now());
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ResultMessage checkConflict(BpmAgentSetting setting) {
        String settingId = setting.getId();
        String authId = setting.getAuthId();
        LocalDateTime startDate = setting.getStartDate();
        LocalDateTime endDate = setting.getEndDate();
        short type = setting.getType();
        ResultMessage result = ResultMessage.getSuccess();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("settingId", settingId);
        params.put("authid", authId);
        params.put("startDate", DateFormatUtil.formaDateTime((LocalDateTime)startDate));
        params.put("endDate", DateFormatUtil.formaDateTime((LocalDateTime)endDate));
        Integer rtn = ((BpmAgentSettingDao)this.baseMapper).getByAuthAndDate(params);
        if (rtn > 0) {
            result = ResultMessage.getFail("\u6b64\u65f6\u95f4\u6bb5\u5185\u4e0e\u5df2\u6709\u7684\u6709\u6548\u4ee3\u7406\u51b2\u7a81!");
            return result;
        }
        switch (type) {
            case 1: {
                result = ResultMessage.getSuccess();
                break;
            }
            case 2: {
                String msg = this.checkPart(setting);
                if (!StringUtil.isNotEmpty((String)msg)) break;
                result = ResultMessage.getFail(msg + "\u6d41\u7a0b\u51b2\u7a81!");
                break;
            }
            case 3: {
                boolean isConflict = this.checkCondition(setting);
                if (!isConflict) break;
                result = ResultMessage.getFail("\u6761\u4ef6\u4ee3\u7406\u6709\u51b2\u7a81!");
            }
        }
        return result;
    }

    private boolean checkCondition(BpmAgentSetting setting) {
        boolean rtn = false;
        String settingId = setting.getId();
        String authId = setting.getAuthId();
        LocalDateTime startDate = setting.getStartDate();
        LocalDateTime endDate = setting.getEndDate();
        String flowKey = setting.getFlowKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowKey", flowKey);
        params.put("authid", authId);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("settingId", StringUtil.isEmpty((String)settingId) ? null : settingId);
        Integer i = ((BpmAgentSettingDao)this.baseMapper).getForCondition(params);
        if (i > 0) {
            return true;
        }
        i = ((BpmAgentSettingDao)this.baseMapper).getByAuthDateFlowKey(params);
        if (i > 0) {
            return true;
        }
        return rtn;
    }

    private String checkPart(BpmAgentSetting setting) {
        String settingId = setting.getId();
        String authId = setting.getAuthId();
        LocalDateTime startDate = setting.getStartDate();
        LocalDateTime endDate = setting.getEndDate();
        StringBuffer sb = new StringBuffer();
        List<BpmAgentDef> defList = setting.getDefList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authid", authId);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("settingId", StringUtil.isEmpty((String)settingId) ? null : settingId);
        for (BpmAgentDef def : defList) {
            params.put("flowKey", def.getFlowKey());
            Integer i = ((BpmAgentSettingDao)this.baseMapper).getByAuthDateFlowKey(params);
            if (i <= 0) continue;
            sb.append(def.getFlowName() + ",");
        }
        return sb.toString();
    }

    @Override
    public BpmAgentSetting getAgentSetting(BpmAgentSetting agentSetting) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        if (StringUtil.isEmpty((String)agentSetting.getAuthId())) {
            agentSetting.setAuthId(user.getUserId());
            agentSetting.setAuthName(user.getFullname());
        }
        if (StringUtil.isEmpty((String)agentSetting.getAgentId())) {
            agentSetting.setAgentId(user.getUserId());
            agentSetting.setAgent(user.getFullname());
        }
        if (BpmAgentSetting.TYPE_GLOBAL.equals(agentSetting.getType())) {
            agentSetting.getDefList().clear();
            agentSetting.getConditionList().clear();
            agentSetting.setFlowKey(null);
            agentSetting.setFlowName(null);
        } else if (BpmAgentSetting.TYPE_PART.equals(agentSetting.getType())) {
            agentSetting.getConditionList().clear();
            agentSetting.setFlowKey(null);
            agentSetting.setFlowName(null);
        } else if (BpmAgentSetting.TYPE_CONDITION.equals(agentSetting.getType())) {
            agentSetting.getDefList().clear();
            agentSetting.setAgentId(null);
            agentSetting.setAgent(null);
        } else {
            throw new Exception("\u65e0\u6548\u59d4\u6258\u8bbe\u5b9a");
        }
        String id = agentSetting.getId();
        String iGroup = ContextUtil.getCurrentGroupId();
        if (StringUtil.isEmpty((String)id)) {
            agentSetting.setCreateBy(user.getUserId());
            agentSetting.setCreateOrgId(iGroup);
        } else {
            agentSetting.setUpdateBy(user.getUserId());
        }
        return agentSetting;
    }

    @Override
    public CommonResult<String> saveBpmAgentSetting(BpmAgentSetting bpmAgentSet) {
        String resultMsg = "";
        try {
            BpmAgentSetting bpmAgentSetting = this.getAgentSetting(bpmAgentSet);
            ResultMessage result = this.checkConflict(bpmAgentSetting);
            if (0 == result.getResult()) {
                return new CommonResult(false, result.getMessage(), (Object)"");
            }
            String id = bpmAgentSetting.getId();
            if (StringUtil.isEmpty((String)id)) {
                this.create(bpmAgentSetting);
                resultMsg = "\u6dfb\u52a0\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u6210\u529f";
            } else {
                this.update(bpmAgentSetting);
                resultMsg = "\u66f4\u65b0\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u6210\u529f";
            }
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage(), (Object)"");
        }
    }
}

