/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.persistence.dao.BpmDefUserDao;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.CurrentUserService;
import com.hotent.bpm.persistence.model.BpmDefUser;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmDefUserManagerImpl
extends BaseManagerImpl<BpmDefUserDao, BpmDefUser>
implements BpmDefUserManager {
    @Resource(name="bpmCurrentUserService")
    private CurrentUserService currentUserService;

    @Override
    public ArrayNode getRights(String authorizeId, String objType) throws IOException {
        String ownerNameJson = "[]";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizeId", authorizeId);
        params.put("objType", objType);
        List<BpmDefUser> bpmDefUsers = ((BpmDefUserDao)this.baseMapper).getAll(params);
        ownerNameJson = this.toOwnerNameJson(bpmDefUsers);
        return (ArrayNode)JsonUtil.toJsonNode((String)ownerNameJson);
    }

    @Override
    @Transactional
    public void saveRights(String authorizeId, String objType, String ownerNameJson) throws IOException {
        if (StringUtil.isNotEmpty((String)ownerNameJson)) {
            ((BpmDefUserDao)this.baseMapper).delByAuthorizeId(authorizeId, objType);
            List<BpmDefUser> bpmDefUserList = this.toBpmDefUserList(ownerNameJson, authorizeId);
            for (BpmDefUser bpmDefUser : bpmDefUserList) {
                bpmDefUser.setObjType(objType);
                super.create((Model)bpmDefUser);
            }
        }
    }

    private List<BpmDefUser> toBpmDefUserList(String ownNameJson, String authorizeId) throws IOException {
        ArrayList<BpmDefUser> userList = new ArrayList<BpmDefUser>();
        if (StringUtil.isEmpty((String)ownNameJson)) {
            return userList;
        }
        ArrayNode aryJson = (ArrayNode)JsonUtil.toJsonNode((String)ownNameJson);
        for (Object obj : aryJson) {
            ObjectNode jsonObject = (ObjectNode)obj;
            List<BpmDefUser> list = this.getList(jsonObject, authorizeId);
            userList.addAll(list);
        }
        return userList;
    }

    private List<BpmDefUser> getList(ObjectNode json, String authorizeId) {
        ArrayList<BpmDefUser> bpmDefUsers = new ArrayList<BpmDefUser>();
        String type = json.get("type").asText();
        if ("everyone".equals(type)) {
            BpmDefUser defUser = new BpmDefUser();
            defUser.setId(UniqueIdUtil.getSuid());
            defUser.setAuthorizeId(authorizeId);
            defUser.setRightType(type);
            bpmDefUsers.add(defUser);
        } else {
            String ids = json.get("id").asText();
            String names = json.get("name").asText();
            String[] aryId = ids.split(",");
            String[] aryName = names.split(",");
            for (int i = 0; i < aryId.length; ++i) {
                BpmDefUser defUser = new BpmDefUser();
                defUser.setId(UniqueIdUtil.getSuid());
                defUser.setAuthorizeId(authorizeId);
                defUser.setRightType(type);
                defUser.setOwnerId(aryId[i]);
                defUser.setOwnerName(aryName[i]);
                bpmDefUsers.add(defUser);
            }
        }
        return bpmDefUsers;
    }

    private String toOwnerNameJson(List<BpmDefUser> bpmDefUsers) {
        if (BeanUtils.isEmpty(bpmDefUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map<String, String> userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (BpmDefUser user : bpmDefUsers) {
            List<BpmDefUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode ArrayNode2 = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<BpmDefUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            ArrayNode2.add((JsonNode)json);
        }
        return ArrayNode2.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<BpmDefUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<BpmDefUser> list = entry.getValue();
        String ids = "";
        String names = "";
        for (int i = 0; i < list.size(); ++i) {
            BpmDefUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
                continue;
            }
            ids = ids + "," + user.getOwnerId();
            names = names + "," + user.getOwnerName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        return jsonObj;
    }

    @Override
    public List<String> getAuthorizeIdsByUserMap(String objType) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((BpmDefUserDao)this.baseMapper).getAuthorizeIdsByUserMap(userRightMapStr, objType);
        return list;
    }

    @Override
    public boolean hasRights(String authorizeId) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((BpmDefUserDao)this.baseMapper).getAuthByAuthorizeId(userRightMapStr, authorizeId);
        return BeanUtils.isNotEmpty(list);
    }

    @Override
    public List<BpmDefUser> getByUserMap(String objType, String authType) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        String atype = StringUtil.isEmpty((String)authType) ? "instance" : authType;
        return ((BpmDefUserDao)this.baseMapper).getByUserMap(userRightMapStr, objType, atype);
    }

    @Override
    @Transactional
    public void delByAuthorizeId(String authorizeId, String bpmDef) {
        ((BpmDefUserDao)this.baseMapper).delByAuthorizeId(authorizeId, bpmDef);
    }

    @Override
    public List<BpmDefUser> getAll(Map<String, Object> params) {
        return ((BpmDefUserDao)this.baseMapper).getAll(params);
    }

    @Override
    @Transactional
    public CommonResult<String> delDefUser(String ids) throws Exception {
        String[] defUserIds;
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException("id\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (String id : defUserIds = ids.split(",")) {
            ((BpmDefUserDao)this.baseMapper).deleteById((Serializable)((Object)id));
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> operatingDefUser(Map<String, Object> mapObj) throws Exception {
        List defUserIds = (List)mapObj.get("defUserIds");
        List uniqueList = defUserIds.stream().distinct().collect(Collectors.toList());
        String paType = mapObj.get("paType").toString();
        String type = mapObj.get("type").toString();
        String msg = "\u6d41\u7a0b\u6388\u6743\u8f6c\u79fb\u6210\u529f";
        for (String defUserId : uniqueList) {
            BpmDefUser entity;
            BpmDefUser oldBpmDefUser;
            HashMap<String, String> map;
            ObjectNode jsonObject;
            ArrayNode aryJson;
            BpmDefUser bpmDefUser = (BpmDefUser)((Object)((BpmDefUserDao)this.baseMapper).selectById((Serializable)((Object)defUserId)));
            Assert.notNull((Object)((Object)bpmDefUser), (String)String.format("\u672a\u83b7\u53d6\u5230id\u4e3a\uff1a%s\u7684\u6d41\u7a0b\u6388\u6743\u4fe1\u606f\u3002", defUserId));
            if ("user".equals(paType)) {
                aryJson = (ArrayNode)JsonUtil.toJsonNode((Object)mapObj.get("userArray"));
                for (Object obj : aryJson) {
                    jsonObject = (ObjectNode)obj;
                    map = new HashMap<String, String>();
                    map.put("authorizeId", bpmDefUser.getAuthorizeId());
                    map.put("ownerId", jsonObject.get("userId").asText());
                    map.put("ownerName", jsonObject.get("userName").asText());
                    map.put("rightType", paType);
                    oldBpmDefUser = ((BpmDefUserDao)this.baseMapper).getBpmDefUserByTeam(map);
                    if (!BeanUtils.isEmpty((Object)((Object)oldBpmDefUser))) continue;
                    entity = new BpmDefUser();
                    entity = bpmDefUser;
                    entity.setId(UniqueIdUtil.getSuid());
                    entity.setOwnerId(jsonObject.get("userId").asText());
                    entity.setOwnerName(jsonObject.get("userName").asText());
                    ((BpmDefUserDao)this.baseMapper).insert((Object)entity);
                }
            } else if ("org".equals(paType)) {
                aryJson = (ArrayNode)JsonUtil.toJsonNode((Object)mapObj.get("orgArray"));
                for (Object obj : aryJson) {
                    jsonObject = (ObjectNode)obj;
                    map = new HashMap();
                    map.put("authorizeId", bpmDefUser.getAuthorizeId());
                    map.put("ownerId", jsonObject.get("orgId").asText());
                    map.put("ownerName", jsonObject.get("orgName").asText());
                    map.put("rightType", paType);
                    oldBpmDefUser = ((BpmDefUserDao)this.baseMapper).getBpmDefUserByTeam(map);
                    if (!BeanUtils.isEmpty((Object)((Object)oldBpmDefUser))) continue;
                    entity = new BpmDefUser();
                    entity = bpmDefUser;
                    entity.setId(UniqueIdUtil.getSuid());
                    entity.setOwnerId(jsonObject.get("orgId").asText());
                    entity.setOwnerName(jsonObject.get("orgName").asText());
                    ((BpmDefUserDao)this.baseMapper).insert((Object)entity);
                }
            } else if ("post".equals(paType)) {
                aryJson = (ArrayNode)JsonUtil.toJsonNode((Object)mapObj.get("postArray"));
                for (Object obj : aryJson) {
                    jsonObject = (ObjectNode)obj;
                    map = new HashMap();
                    map.put("authorizeId", bpmDefUser.getAuthorizeId());
                    map.put("ownerId", jsonObject.get("postId").asText());
                    map.put("ownerName", jsonObject.get("postName").asText());
                    map.put("rightType", "pos");
                    oldBpmDefUser = ((BpmDefUserDao)this.baseMapper).getBpmDefUserByTeam(map);
                    if (!BeanUtils.isEmpty((Object)((Object)oldBpmDefUser))) continue;
                    entity = new BpmDefUser();
                    entity = bpmDefUser;
                    entity.setId(UniqueIdUtil.getSuid());
                    entity.setOwnerId(jsonObject.get("postId").asText());
                    entity.setOwnerName(jsonObject.get("postName").asText());
                    ((BpmDefUserDao)this.baseMapper).insert((Object)entity);
                }
            } else if ("role".equals(paType)) {
                aryJson = (ArrayNode)JsonUtil.toJsonNode((Object)mapObj.get("roleArray"));
                for (Object obj : aryJson) {
                    jsonObject = (ObjectNode)obj;
                    map = new HashMap();
                    map.put("authorizeId", bpmDefUser.getAuthorizeId());
                    map.put("ownerId", jsonObject.get("roleId").asText());
                    map.put("ownerName", jsonObject.get("roleName").asText());
                    map.put("rightType", paType);
                    oldBpmDefUser = ((BpmDefUserDao)this.baseMapper).getBpmDefUserByTeam(map);
                    if (!BeanUtils.isEmpty((Object)((Object)oldBpmDefUser))) continue;
                    entity = new BpmDefUser();
                    entity = bpmDefUser;
                    entity.setId(UniqueIdUtil.getSuid());
                    entity.setOwnerId(jsonObject.get("roleId").asText());
                    entity.setOwnerName(jsonObject.get("roleName").asText());
                    ((BpmDefUserDao)this.baseMapper).insert((Object)entity);
                }
            }
            if (!"1".equals(type)) continue;
            ((BpmDefUserDao)this.baseMapper).deleteById((Serializable)((Object)defUserId));
        }
        if ("2".equals(type)) {
            msg = "\u6d41\u7a0b\u6388\u6743\u590d\u5236\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)"");
    }
}

