/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultButton;
import com.hotent.bpm.persistence.dao.BpmDefaultButtonDao;
import com.hotent.bpm.persistence.manager.BpmDefaultButtonManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmDefaultButtonManagerImpl
extends BaseManagerImpl<BpmDefaultButtonDao, DefaultButton>
implements BpmDefaultButtonManager {
    @Resource
    BpmDefaultButtonDao bpmDefaultButtonDao;

    @Override
    public Boolean createAndOrder(DefaultButton defaultButton) {
        Integer max = Optional.ofNullable(this.bpmDefaultButtonDao.getMaxOrderByType("top")).orElse(0);
        defaultButton.setOrder(1 + max);
        try {
            return this.save(defaultButton);
        }
        catch (DuplicateKeyException e) {
            throw new BaseException("\u522b\u540d[" + defaultButton.getAlias() + "]\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void setCommonStyle(DefaultButton style) {
        ((BpmDefaultButtonDao)this.baseMapper).updateTopCommonStyle(style);
    }

    @Override
    public List<DefaultButton> getByType(String type, Boolean isInit) {
        List<DefaultButton> result = this.bpmDefaultButtonDao.getByType(type, isInit);
        if ("top".equals(type) && CollUtil.isEmpty(result)) {
            result = this.addFixedTopButtons();
        }
        return result;
    }

    @Override
    public List<DefaultButton> addFixedTopButtons() {
        HashMap<String, List<String>> fixButtonsInfo = new HashMap<String, List<String>>(8){
            {
                this.put("copy", Arrays.asList("\u590d\u5236", "el-icon-document-copy"));
                this.put("print", Arrays.asList("\u6253\u5370", "el-icon-document-copy"));
                this.put("figure", Arrays.asList("\u9884\u6d4b\u56fe", "el-icon-document-copy"));
                this.put("circulate", Arrays.asList("\u4f20\u9605", "icon-chuanyue"));
                this.put("communication", Arrays.asList("\u6c9f\u901a", "icon-goutong2"));
                this.put("follow", Arrays.asList("\u8ddf\u8e2a", "icon-genzong"));
                this.put("chart", Arrays.asList("\u6d41\u7a0b\u56fe", "icon-liuchengtu2"));
                this.put("urgent", Arrays.asList("\u50ac\u529e", "icon-task-reminders"));
                this.put("process", Arrays.asList("\u6d41\u7a0b\u4fe1\u606f", "icon-shujushitu1"));
            }
        };
        ArrayList<DefaultButton> fixedButtons = new ArrayList<DefaultButton>();
        AtomicInteger index = new AtomicInteger();
        fixButtonsInfo.forEach((k, v) -> {
            DefaultButton defaultButton = new DefaultButton();
            defaultButton.setAlias((String)k);
            defaultButton.setName((String)v.get(0));
            defaultButton.setIcon((String)v.get(1));
            defaultButton.setFixed(1);
            defaultButton.setDisabled(1);
            defaultButton.setType("top");
            defaultButton.setTextColor("#409eff");
            defaultButton.setLabelColor("");
            defaultButton.setStyle("textButton");
            defaultButton.setOrder(index.getAndIncrement());
            fixedButtons.add(defaultButton);
        });
        this.saveBatch(fixedButtons);
        return fixedButtons;
    }

    @Override
    @Transactional
    public CommonResult<String> saveButtonById(DefaultButton defaultButton) {
        String alias;
        QueryWrapper wrapper = new QueryWrapper();
        switch (alias = defaultButton.getAlias()) {
            case "hangUp": {
                wrapper.eq((Object)"ALIAS_", (Object)"cancelHangUp");
                DefaultButton cancelHangUpButton = (DefaultButton)this.bpmDefaultButtonDao.selectOne((Wrapper)wrapper);
                cancelHangUpButton.setDisabled(defaultButton.getDisabled());
                this.bpmDefaultButtonDao.updateById(cancelHangUpButton);
                break;
            }
            case "cancelHangUp": {
                wrapper.eq((Object)"ALIAS_", (Object)"hangUp");
                DefaultButton hangUpButton = (DefaultButton)this.bpmDefaultButtonDao.selectOne((Wrapper)wrapper);
                hangUpButton.setDisabled(defaultButton.getDisabled());
                this.bpmDefaultButtonDao.updateById(hangUpButton);
            }
        }
        int update = this.bpmDefaultButtonDao.updateById(defaultButton);
        if (update > 0) {
            return CommonResult.ok().message("\u66f4\u65b0\u6210\u529f\uff01");
        }
        return CommonResult.error().message("\u66f4\u65b0\u5931\u8d25\uff01");
    }

    @Override
    public void switchOrder(List<DefaultButton> buttonList) {
        buttonList.forEach(item -> this.bpmDefaultButtonDao.updateOrder(item.getId(), item.getOrder()));
    }

    @Override
    public void updateDisabled(String id, Integer status) {
        this.bpmDefaultButtonDao.updateDisabled(id, status);
    }
}

