/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.jms.JmsTodoProducer;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.persistence.dao.BpmPushTodoLogDao;
import com.hotent.bpm.persistence.manager.BpmPushTodoLogManager;
import com.hotent.bpm.persistence.model.BpmPushTodoLog;
import com.hotent.bpm.service.TodoMsgPushService;
import com.hotent.sdk.feign.properties.EipSdkProperty;
import com.hotent.sdk.feign.service.EipTodoSdkService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmPushTodoLogManagerImpl
extends BaseManagerImpl<BpmPushTodoLogDao, BpmPushTodoLog>
implements BpmPushTodoLogManager {
    @Resource
    private JmsTodoProducer defaultJmsTodoProducer;
    @Resource
    TodoMsgPushService todoMsgPushService;

    @Override
    @Transactional
    public CommonResult<String> reinvoke(String id) throws Exception {
        BpmPushTodoLog bpmPushTodoLog = (BpmPushTodoLog)this.get((Serializable)((Object)id));
        this.reinvoke(bpmPushTodoLog);
        return new CommonResult("\u8c03\u7528\u6210\u529f");
    }

    private void reinvoke(BpmPushTodoLog bpmPushTodoLog) {
        bpmPushTodoLog.setTryTime(bpmPushTodoLog.getTryTime() + 1);
        try {
            if ("mq".equalsIgnoreCase(bpmPushTodoLog.getPushType())) {
                this.defaultJmsTodoProducer.sendToTodoTopic((Object)bpmPushTodoLog, bpmPushTodoLog.getTodoTopic());
            } else if ("rest".equalsIgnoreCase(bpmPushTodoLog.getPushType())) {
                String tenantId = TenantUtil.getCurrentTenantId();
                this.todoMsgPushService.handlerFlowJmsMessage(bpmPushTodoLog.getContent(), bpmPushTodoLog.getType(), tenantId);
            }
        }
        catch (WorkFlowException e) {
            bpmPushTodoLog.setException(e.getMessage());
            throw new WorkFlowException(e.getMessage());
        }
        bpmPushTodoLog.setStatus(1);
        this.update((Model)bpmPushTodoLog);
    }

    private EipTodoSdkService getEipTodoSdkService(String tenantCode) {
        EipSdkProperty bean = (EipSdkProperty)AppUtil.getBean(EipSdkProperty.class);
        EipSdkProperty olde = null;
        try {
            olde = (EipSdkProperty)JsonUtil.toBean((String)JsonUtil.toJson((Object)bean), EipSdkProperty.class);
        }
        catch (Exception e) {
            olde = bean;
        }
        EipTodoSdkService eipTodoSdkService = new EipTodoSdkService(olde);
        return eipTodoSdkService;
    }

    @Override
    public void revoke(String id) throws Exception {
    }

    @Override
    @Transactional
    public void signSuccess(String id) {
        ((BpmPushTodoLogDao)this.baseMapper).signSuccess(id);
    }

    @Override
    public CommonResult<String> migratingData() {
        ((BpmPushTodoLogDao)this.baseMapper).createHi();
        ((BpmPushTodoLogDao)this.baseMapper).removeBeforeMarch();
        return CommonResult.ok();
    }

    @Override
    public CommonResult<String> reinvokeBatch(QueryFilter queryFilter) {
        if (BeanUtils.isEmpty((Object)queryFilter.getQuerys())) {
            return new CommonResult(false, "\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        queryFilter.getPageBean().setShowTotal(false);
        queryFilter.getPageBean().setPageSize(-1);
        queryFilter.setSorter(new ArrayList<FieldSort>(Arrays.asList(new FieldSort("logTime", Direction.ASC))));
        PageList pageList = this.query(queryFilter);
        int failCount = 0;
        if (BeanUtils.isNotEmpty((Object)pageList) && BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            for (BpmPushTodoLog item : pageList.getRows()) {
                boolean result = this.delayReinvoke(item);
                if (result) continue;
                ++failCount;
            }
        }
        return new CommonResult(String.format("\u91cd\u8c03\u5b8c\u6210\uff0c\u6267\u884c\u6210\u529f\uff1a%s\u6761\uff1b\u5931\u8d25\uff1a%s\uff1b", pageList.getRows().size() - failCount, failCount));
    }

    private boolean delayReinvoke(BpmPushTodoLog log) {
        boolean result = true;
        try {
            int delaySecend = 1000;
            Thread.sleep(delaySecend);
            this.reinvoke(log);
            log.setTryTime(log.getTryTime() + 1);
            log.setStatus(1);
        }
        catch (Exception e) {
            log.setTryTime(log.getTryTime() + 1);
            log.setException(e.getMessage());
            result = false;
        }
        this.update((Model)log);
        return result;
    }

    @Override
    public CommonResult<String> reinvokeBatchByRange(String startTime, String endTime) {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1), Boolean.valueOf(false)));
        ArrayList<LocalDateTime> dateList = new ArrayList<LocalDateTime>();
        dateList.add(TimeUtil.convertString((String)startTime));
        dateList.add(TimeUtil.convertString((String)endTime));
        queryFilter.addFilter("logTime", dateList, QueryOP.BETWEEN, FieldRelation.AND, "logTime");
        queryFilter.addFilter("status", (Object)"0", QueryOP.EQUAL);
        return this.reinvokeBatch(queryFilter);
    }
}

