/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.persistence.dao.BpmTaskDueTimeDao;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.hotent.bpm.persistence.model.BpmTaskDueTime;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTaskDueTimeManager")
public class BpmTaskDueTimeManagerImpl
extends BaseManagerImpl<BpmTaskDueTimeDao, BpmTaskDueTime>
implements BpmTaskDueTimeManager {
    @Resource
    BpmTaskDueTimeDao bpmTaskDueTimeDao;
    @Resource
    PortalFeignService PortalFeignService;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;

    @Override
    public BpmTaskDueTime getByTaskId(String taskId) {
        return this.bpmTaskDueTimeDao.getByTaskId(taskId);
    }

    @Override
    @Transactional
    public void updateAndSave(BpmTaskDueTime bpmTaskDueTime) {
        BpmTaskDueTime dueTime = (BpmTaskDueTime)super.get((Serializable)((Object)bpmTaskDueTime.getId()));
        dueTime.setIsNew((short)0);
        super.update((Model)dueTime);
        bpmTaskDueTime.setId(UniqueIdUtil.getSuid());
        super.create((Model)bpmTaskDueTime);
    }

    @Override
    public CommonResult<String> saveBpmTaskDueTime(BpmTaskDueTime bpmTaskDueTime) {
        String resultMsg = null;
        boolean isTrue = true;
        try {
            String nowtime;
            String expireTime;
            BpmTaskDueTime oldBpmTaskDueTime;
            boolean isExpire = false;
            String id = bpmTaskDueTime.getId();
            if (StringUtil.isNotEmpty((String)id) && BeanUtils.isNotEmpty((Object)((Object)(oldBpmTaskDueTime = (BpmTaskDueTime)this.bpmTaskDueTimeManager.get((Serializable)((Object)id))))) && (isExpire = DateUtil.compare((String)(expireTime = DateFormatUtil.formaDatetTime((LocalDateTime)oldBpmTaskDueTime.getExpirationDate())), (String)(nowtime = DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()))))) {
                resultMsg = "\u5f53\u524d\u4efb\u52a1\u5df2\u8fc7\u671f\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5ef6\u671f\u64cd\u4f5c\uff01";
                isTrue = false;
            }
            if (!isExpire) {
                LocalDateTime expDate = this.getExpDate(bpmTaskDueTime, bpmTaskDueTime.getAddDueTime());
                bpmTaskDueTime.setDueTime(bpmTaskDueTime.getDueTime() + bpmTaskDueTime.getAddDueTime());
                bpmTaskDueTime.setExpirationDate(expDate);
                bpmTaskDueTime.setCreateTime(LocalDateTime.now());
                bpmTaskDueTime.setStatus((short)1);
                bpmTaskDueTime.setParentId(bpmTaskDueTime.getId());
                int remainingTime = this.getRemainingTime(bpmTaskDueTime);
                bpmTaskDueTime.setRemainingTime(remainingTime);
                this.bpmTaskDueTimeManager.updateAndSave(bpmTaskDueTime);
                resultMsg = "\u5ef6\u671f\u6210\u529f";
            }
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage();
            isTrue = false;
        }
        return new CommonResult(isTrue, resultMsg, (Object)"");
    }

    @Override
    public Object getExpirationDate(String id, Integer addDueTime) {
        addDueTime = BeanUtils.isEmpty((Object)addDueTime) ? 0 : addDueTime;
        BpmTaskDueTime bpmTaskDueTime = (BpmTaskDueTime)this.bpmTaskDueTimeManager.get((Serializable)((Object)id));
        LocalDateTime expDate = null;
        try {
            expDate = this.getExpDate(bpmTaskDueTime, addDueTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (BeanUtils.isNotEmpty((Object)expDate)) {
            return TimeUtil.getTimeMillis((LocalDateTime)expDate);
        }
        return "0000-00-00 00:00:00";
    }

    public LocalDateTime getExpDate(BpmTaskDueTime bpmTaskDueTime, int addDueTime) throws Exception {
        LocalDateTime expDate = null;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            expDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)addDueTime, (long)TimeUtil.getTimeMillis((LocalDateTime)bpmTaskDueTime.getExpirationDate())));
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            if (BeanUtils.isNotEmpty((Object)bpmTaskDueTime.getExpirationDate())) {
                params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getExpirationDate()));
            }
            params.put("time", addDueTime);
            String expDateStr = this.PortalFeignService.getEndTimeByUser(params);
            expDate = DateFormatUtil.parse((String)expDateStr);
        }
        return expDate;
    }

    private int getRemainingTime(BpmTaskDueTime bpmTaskDueTime) throws Exception {
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(this.PortalFeignService.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0) {
            remainingTime = 0;
        }
        return remainingTime;
    }
}

