/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.model.process.task.BpmTaskTurn;
import com.hotent.bpm.persistence.dao.BpmTaskTurnDao;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.manager.TaskTurnAssignManager;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskTurn;
import com.hotent.bpm.persistence.model.TaskTurnAssign;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTaskTurnManager")
public class BpmTaskTurnManagerImpl
extends BaseManagerImpl<BpmTaskTurnDao, DefaultBpmTaskTurn>
implements BpmTaskTurnManager {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    TaskTurnAssignManager taskTurnAssignManager;

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        ((BpmTaskTurnDao)this.baseMapper).delByInstList(instList);
    }

    @Override
    @Transactional
    public void updComplete(String taskId, IUser user) {
        String execUserId = BeanUtils.isNotEmpty((Object)user) ? user.getUserId() : "-1";
        String execUserName = BeanUtils.isNotEmpty((Object)user) ? user.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba";
        ((BpmTaskTurnDao)this.baseMapper).updComplete(taskId, execUserId, execUserName, LocalDateTime.now());
    }

    @Override
    public BpmTaskTurn getByTaskId(String taskId) {
        return ((BpmTaskTurnDao)this.baseMapper).getByTaskId(taskId);
    }

    @Override
    public IPage<DefaultBpmTaskTurn> getMyDelegate(String userId, QueryFilter queryFilter) {
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            queryFilter = QueryFilter.build().withDefaultPage();
        }
        queryFilter.addFilter("a.owner_id_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR);
        queryFilter.addFilter("b.from_user_id_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR);
        queryFilter.setDefaultSort("a.create_time_", Direction.DESC);
        String defKey = "";
        IPage<DefaultBpmTaskTurn> taskTurn = ((BpmTaskTurnDao)this.baseMapper).getMyDelegate((IPage<DefaultBpmTaskTurn>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DefaultBpmTaskTurn>)this.convert2Wrapper(queryFilter, this.currentModelClass()), defKey);
        return taskTurn;
    }

    @Override
    public List<Map<String, Object>> getMyDelegateCount(String userId) {
        return ((BpmTaskTurnDao)this.baseMapper).getMyDelegateCount(userId);
    }

    @Override
    public Long getMyDelegateCountByUserId(String userId) {
        return ((BpmTaskTurnDao)this.baseMapper).getMyDelegateCountByUserId(userId);
    }

    @Override
    public List<TaskTurnAssign> getTurnAssignByTaskTurnId(String taskTurnId) {
        return this.taskTurnAssignManager.getByTaskTurnId(taskTurnId, true);
    }

    @Override
    @Transactional
    public void add(DefaultBpmTask bpmTask, IUser owner, IUser agent, String opinion, String type) {
        DefaultBpmTaskTurn taskTurn = new DefaultBpmTaskTurn();
        taskTurn.setId(UniqueIdUtil.getSuid());
        taskTurn.setTaskId(bpmTask.getId());
        taskTurn.setTaskName(bpmTask.getName());
        taskTurn.setTaskSubject(bpmTask.getSubject());
        taskTurn.setNodeId(bpmTask.getNodeId());
        taskTurn.setProcInstId(bpmTask.getProcInstId());
        taskTurn.setOwnerId(owner.getUserId());
        taskTurn.setOwnerName(owner.getFullname());
        taskTurn.setAssigneeId(agent.getUserId());
        taskTurn.setAssigneeName(agent.getFullname());
        taskTurn.setStatus("running");
        taskTurn.setTurnType(type);
        taskTurn.setCreateTime(LocalDateTime.now());
        taskTurn.setTypeId(bpmTask.getTypeId());
        super.create((Model)taskTurn);
        this.addTurnAssign(taskTurn.getId(), agent, opinion);
    }

    @Override
    @Transactional
    public void addTurnAssign(String turnId, IUser user, String opinion) {
        IUser fromUser = ContextUtil.getCurrentUser();
        TaskTurnAssign taskTurnAssign = new TaskTurnAssign();
        taskTurnAssign.setId(UniqueIdUtil.getSuid());
        taskTurnAssign.setTaskTurnId(turnId);
        taskTurnAssign.setFromUser(fromUser.getFullname());
        taskTurnAssign.setFromUserId(fromUser.getUserId());
        taskTurnAssign.setReceiverId(user.getUserId());
        taskTurnAssign.setReceiver(user.getFullname());
        taskTurnAssign.setComment(opinion);
        this.taskTurnAssignManager.create((Model)taskTurnAssign);
    }

    @Override
    @Transactional
    public void delByTaskId(String taskId) {
        ((BpmTaskTurnDao)this.baseMapper).delByTaskId(taskId);
    }

    @Override
    public List<DefaultBpmTaskTurn> getByTaskIdAndAssigneeId(String taskId, String assigneeId) {
        return ((BpmTaskTurnDao)this.baseMapper).getByTaskIdAndAssigneeId(taskId, assigneeId);
    }

    @Override
    public List<DefaultBpmTaskTurn> getByTaskIds(List<String> taskIds) {
        return ((BpmTaskTurnDao)this.baseMapper).getByTaskIds(taskIds);
    }

    @Override
    public void updateSubjectByInstId(String id, String subject) {
        ((BpmTaskTurnDao)this.baseMapper).updateSubjectByInstId(id, subject);
    }
}

