/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bpm.enums.WatermarkStatus;
import com.hotent.bpm.enums.WatermarkType;
import com.hotent.bpm.persistence.dao.BpmWatermarkDao;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmWatermarkManager;
import com.hotent.bpm.persistence.manager.BpmWatermarkProcessManager;
import com.hotent.bpm.persistence.manager.BpmWatermarkTypeManager;
import com.hotent.bpm.persistence.model.BpmWatermark;
import com.hotent.bpm.persistence.model.BpmWatermarkProcess;
import com.hotent.bpm.persistence.model.BpmWatermarkType;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmWatermarkManager")
public class BpmWatermarkManagerImpl
extends BaseManagerImpl<BpmWatermarkDao, BpmWatermark>
implements BpmWatermarkManager {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmWatermarkProcessManager bpmWatermarkProcessManager;
    @Resource
    BpmWatermarkTypeManager bpmWatermarkTypeManager;
    @Resource
    FreeMarkerEngine freeMarkerEngine;

    @Override
    public BpmWatermark getGlobal() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"MARK_TYPE_", (Object)WatermarkType.GLOBAL.getKey());
        wrapper.eq((Object)"STATUS_", (Object)WatermarkStatus.START.getKey());
        List list = ((BpmWatermarkDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (BeanUtils.isEmpty((Object)list)) {
            return null;
        }
        BpmWatermark bpmWatermark = (BpmWatermark)((Object)list.get(0));
        this.handleWatermark(bpmWatermark);
        return bpmWatermark;
    }

    @Override
    public BpmWatermark getData(String id) {
        BpmWatermark bpmWatermark = this.getGlobal();
        if (BeanUtils.isNotEmpty((Object)((Object)bpmWatermark))) {
            return null;
        }
        bpmWatermark = (BpmWatermark)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmWatermark::getId, (Object)id)).eq(BpmWatermark::getStatus, (Object)WatermarkStatus.START.getKey())));
        if (bpmWatermark == null) {
            return null;
        }
        this.handleWatermark(bpmWatermark);
        return bpmWatermark;
    }

    @Override
    @Transactional
    public CommonResult<String> saveData(BpmWatermark bpmWatermark) throws Exception {
        String msg = "\u6dfb\u52a0\u6d41\u7a0b\u6c34\u5370\u6210\u529f";
        if (StringUtil.isEmpty((String)bpmWatermark.getId())) {
            this.create((Model)bpmWatermark);
        } else {
            this.update((Model)bpmWatermark);
            msg = "\u66f4\u65b0\u6d41\u7a0b\u6c34\u5370\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @Override
    public BpmWatermark getByInstId(String instId) {
        BpmWatermark bpmWatermark = this.getGlobal();
        if (BeanUtils.isEmpty((Object)((Object)bpmWatermark))) {
            BpmWatermark procBpmWatermark;
            DefaultBpmProcessInstance instance = this.bpmProcessInstanceManager.getNowAndHistory(instId);
            if (BeanUtils.isEmpty((Object)instance)) {
                throw new RuntimeException("\u4e0d\u5b58\u5728\u6b64\u5b9e\u4f8b");
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"proc_def_key_", (Object)instance.getProcDefKey());
            BpmWatermarkProcess bpmWatermarkProcess = (BpmWatermarkProcess)((Object)this.bpmWatermarkProcessManager.getOne((Wrapper)wrapper));
            if (bpmWatermarkProcess != null && (procBpmWatermark = (BpmWatermark)((Object)((BpmWatermarkDao)this.baseMapper).selectById((Serializable)((Object)bpmWatermarkProcess.getWatermarkId())))) != null) {
                this.handleWatermark(procBpmWatermark);
                return procBpmWatermark;
            }
            bpmWatermark = ((BpmWatermarkDao)this.baseMapper).getByTypeId(instance.getTypeId());
        }
        if (bpmWatermark != null) {
            this.handleWatermark(bpmWatermark);
        }
        return bpmWatermark;
    }

    private void handleWatermark(BpmWatermark bpmWatermark) {
        String rule = bpmWatermark.getMarkRule();
        if (StringUtil.isNotEmpty((String)rule)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            IUser user = ContextUtil.getCurrentUser();
            String date = DateFormatUtil.formatDate((LocalDateTime)LocalDateTime.now());
            vars.put("username", user.getFullname());
            vars.put("account", user.getAccount());
            vars.put("date", date);
            String content = this.parseRule(rule, vars);
            bpmWatermark.setContent(content);
        }
    }

    private String parseRule(String rule, Map<String, Object> vars) {
        String subject = "";
        try {
            subject = this.freeMarkerEngine.parseByTemplate(rule, vars);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return subject;
    }

    @Override
    @Transactional
    public void batchRemove(String ... ids) {
        this.removeByIds(ids);
        ArrayList<String> procIds = new ArrayList<String>();
        ArrayList<String> typeIds = new ArrayList<String>();
        for (String watermarkId : ids) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"watermark_id_", (Object)watermarkId);
            List bpmWatermarkProcesses = this.bpmWatermarkProcessManager.list((Wrapper)wrapper);
            for (BpmWatermarkProcess bpmWatermarkProcess : bpmWatermarkProcesses) {
                if (bpmWatermarkProcess == null || !BeanUtils.isNotEmpty((Object)bpmWatermarkProcess.getId())) continue;
                procIds.add(bpmWatermarkProcess.getId());
            }
            List bpmWatermarkTypes = this.bpmWatermarkTypeManager.list((Wrapper)wrapper);
            for (BpmWatermarkType bpmWatermarkType : bpmWatermarkTypes) {
                if (bpmWatermarkType == null || !BeanUtils.isNotEmpty((Object)bpmWatermarkType.getId())) continue;
                typeIds.add(bpmWatermarkType.getId());
            }
        }
        this.bpmWatermarkProcessManager.removeByIds(procIds);
        this.bpmWatermarkTypeManager.removeByIds(typeIds);
    }

    @Override
    public CommonResult<String> changeStatus(String id, String status) {
        BpmWatermark bpmWatermark = (BpmWatermark)this.get((Serializable)((Object)id));
        if (WatermarkStatus.START.getKey().equals(status)) {
            int count;
            if (WatermarkType.GLOBAL.getKey().equals(bpmWatermark.getMarkType())) {
                int count2 = this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmWatermark::getStatus, (Object)WatermarkStatus.START.getKey())).ne(BpmWatermark::getId, (Object)id));
                if (count2 > 0) {
                    return new CommonResult(false, "\u5df2\u5b58\u5728\u542f\u7528\u7684\u6d41\u7a0b\u3001\u9875\u9762\u6216\u8005\u5168\u5c40\u6c34\u5370");
                }
            } else if (WatermarkType.FLOW.getKey().equals(bpmWatermark.getMarkType())) {
                int count3 = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmWatermark::getStatus, (Object)WatermarkStatus.START.getKey())).ne(BpmWatermark::getId, (Object)id)).in(BpmWatermark::getMarkType, Arrays.asList(WatermarkType.PAGE.getKey(), WatermarkType.GLOBAL.getKey())));
                if (count3 > 0) {
                    return new CommonResult(false, "\u5df2\u5b58\u5728\u542f\u7528\u7684\u9875\u9762\u3001\u5168\u5c40\u6c34\u5370");
                }
            } else if (WatermarkType.PAGE.getKey().equals(bpmWatermark.getMarkType()) && (count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmWatermark::getStatus, (Object)WatermarkStatus.START.getKey())).ne(BpmWatermark::getId, (Object)id)).in(BpmWatermark::getMarkType, Arrays.asList(WatermarkType.FLOW.getKey(), WatermarkType.GLOBAL.getKey())))) > 0) {
                return new CommonResult(false, "\u5df2\u5b58\u5728\u542f\u7528\u7684\u6d41\u7a0b\u3001\u5168\u5c40\u6c34\u5370");
            }
        }
        ((BpmWatermarkDao)this.baseMapper).changeStatus(id, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public List<BpmWatermark> getByType(String type) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"MARK_TYPE_", (Object)type);
        return ((BpmWatermarkDao)this.baseMapper).selectList((Wrapper)wrapper);
    }
}

