/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.persistence.dao.TaskFollowDao;
import com.hotent.bpm.persistence.manager.TaskFollowManager;
import com.hotent.bpm.persistence.model.TaskFollow;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service(value="taskFollowManager")
public class TaskFollowManagerImpl
extends BaseManagerImpl<TaskFollowDao, TaskFollow>
implements TaskFollowManager {
    @Override
    public CommonResult<String> saveTaskFollow(TaskFollow taskFollow) {
        String msg = "";
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PRO_INST_", (Object)taskFollow.getProInst(), QueryOP.EQUAL);
        queryFilter.addFilter("CREATOR_ID_", (Object)AuthenticationUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList list = this.query(queryFilter);
        TaskFollow oldFollow = null;
        if (list.getRows().size() > 0) {
            oldFollow = (TaskFollow)((Object)list.getRows().get(0));
        }
        if (oldFollow == null) {
            msg = "\u6dfb\u52a0\u8ddf\u8e2a\u4efb\u52a1\u6210\u529f";
            taskFollow.setCreatorId(AuthenticationUtil.getCurrentUserId());
            taskFollow.setId(UniqueIdUtil.getSuid());
            this.create((Model)taskFollow);
        } else {
            oldFollow.setTaskId(taskFollow.getTaskId());
            this.update((Model)oldFollow);
            msg = "\u66f4\u65b0\u4efb\u52a1\u8ddf\u8e2a\u6210\u529f";
        }
        return new CommonResult(I18nUtil.handleI18nMessage((String)(oldFollow == null ? "taskAddTrackTaskSucceeded" : "taskUpdateTrackTaskSucceeded"), (String)(oldFollow == null ? "\u6dfb\u52a0\u8ddf\u8e2a\u4efb\u52a1\u6210\u529f" : "\u66f4\u65b0\u4efb\u52a1\u8ddf\u8e2a\u6210\u529f")));
    }

    @Override
    public CommonResult<String> getFollowedNode(String instId) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PRO_INST_", (Object)instId, QueryOP.EQUAL);
        queryFilter.addFilter("CREATOR_ID_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList list = this.query(queryFilter);
        ArrayList<String> ids = new ArrayList<String>();
        for (TaskFollow follow : list.getRows()) {
            ids.add(follow.getTaskId());
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\u6210\u529f", (Object)StringUtil.join(ids, (String)","));
    }
}

