/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.util;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.def.BpmWordPrintDef;
import com.hotent.bpm.api.model.process.def.ExtProperty;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDefComparator;
import com.hotent.bpm.api.model.process.nodedef.MultiInstanceDef;
import com.hotent.bpm.api.model.process.nodedef.ext.BaseBpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CustomSignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.GateWayBpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.ServiceNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.plugin.core.context.AbstractBpmPluginContext;
import com.hotent.bpm.api.plugin.core.context.AbstractProcessInstAopPluginContext;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.context.PluginContext;
import com.hotent.bpm.api.plugin.core.context.ProcessInstAopPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.def.ProcessInstAopPluginDef;
import com.hotent.bpm.defxml.entity.Activity;
import com.hotent.bpm.defxml.entity.CallActivity;
import com.hotent.bpm.defxml.entity.EndEvent;
import com.hotent.bpm.defxml.entity.ExclusiveGateway;
import com.hotent.bpm.defxml.entity.Expression;
import com.hotent.bpm.defxml.entity.FlowElement;
import com.hotent.bpm.defxml.entity.Gateway;
import com.hotent.bpm.defxml.entity.InclusiveGateway;
import com.hotent.bpm.defxml.entity.LoopCharacteristics;
import com.hotent.bpm.defxml.entity.MultiInstanceLoopCharacteristics;
import com.hotent.bpm.defxml.entity.ParallelGateway;
import com.hotent.bpm.defxml.entity.Process;
import com.hotent.bpm.defxml.entity.SequenceFlow;
import com.hotent.bpm.defxml.entity.ServiceTask;
import com.hotent.bpm.defxml.entity.StartEvent;
import com.hotent.bpm.defxml.entity.SubProcess;
import com.hotent.bpm.defxml.entity.UserTask;
import com.hotent.bpm.defxml.entity.ext.BoDef;
import com.hotent.bpm.defxml.entity.ext.BoSaveMode;
import com.hotent.bpm.defxml.entity.ext.ExtDefinitions;
import com.hotent.bpm.defxml.entity.ext.ExtPlugins;
import com.hotent.bpm.defxml.entity.ext.ExtProcess;
import com.hotent.bpm.defxml.entity.ext.ExtProperties;
import com.hotent.bpm.defxml.entity.ext.Form;
import com.hotent.bpm.defxml.entity.ext.FormExt;
import com.hotent.bpm.defxml.entity.ext.MobileForm;
import com.hotent.bpm.defxml.entity.ext.VarDefs;
import com.hotent.bpm.defxml.entity.ext.VariableDef;
import com.hotent.bpm.defxml.entity.ext.WordPrintDef;
import com.hotent.bpm.defxml.entity.ext.WordPrints;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.model.process.nodedef.ext.extmodel.DefaultFormExt;
import com.hotent.bpm.model.var.DefaultBpmVariableDef;
import com.hotent.bpm.model.wordPrint.DefaultBpmWordPrint;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDef;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.HandlerFactory;
import com.hotent.bpm.persistence.model.NodeHandler;
import com.hotent.bpm.persistence.util.BpmDefAccessorUtil;
import com.hotent.bpm.persistence.util.BpmUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BpmProcessDefExtParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmProcessDefExtParse.class);
    private static BpmProcessDefExtParse parser = new BpmProcessDefExtParse();
    private Class<FlowElement>[] aryNodeElement = new Class[]{StartEvent.class, EndEvent.class, ParallelGateway.class, InclusiveGateway.class, ExclusiveGateway.class, UserTask.class, ServiceTask.class, CallActivity.class, SubProcess.class};

    private BpmProcessDefExtParse() {
    }

    public static BpmProcessDefExtParse getInstance() {
        return parser;
    }

    public void handProcessDef(DefaultBpmProcessDef bpmProcessDef, ExtDefinitions def, Process process) throws Exception {
        DefaultBpmProcessDefExt processDefExt = new DefaultBpmProcessDefExt(def);
        ExtProcess extProcess = def.getExtProcess();
        bpmProcessDef.setProcessDefExt(processDefExt);
        if (extProcess != null) {
            this.handBpmPluginContexts(processDefExt, extProcess);
            this.handExtProperties(processDefExt, extProcess);
            this.handVariables(processDefExt, extProcess);
            this.handWordPrints(processDefExt, extProcess);
            this.handNodeVariables(processDefExt, extProcess, bpmProcessDef.getBpmnNodeDefs());
            this.handBoDefList(processDefExt, extProcess);
            this.handInstFormList(processDefExt, extProcess);
            this.handGlobalFormList(processDefExt, extProcess);
        }
        List<JAXBElement<? extends FlowElement>> jaxbElementFlowElements = process.getFlowElement();
        this.setProcessDefNodes(null, jaxbElementFlowElements, bpmProcessDef);
        this.handNodeSetting(bpmProcessDef.getBpmnNodeDefs());
        bpmProcessDef.setProcessDefExt(processDefExt);
    }

    private void handExtProperties(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) {
        ExtProperties extProperties = extProcess.getExtProperties();
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)extProperties), (String)"\u8be5\u6d41\u7a0b\u7684\u6269\u5c55\u5c5e\u6027extProperties\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u52a0\u8f7d\u3002");
        processDefExt.setExtProperties(this.convertExtProperties(extProperties));
    }

    private BpmDefExtProperties convertExtProperties(ExtProperties ext) {
        BpmDefExtProperties tmp = new BpmDefExtProperties();
        String subjectRule = ext.getSubjectRule();
        if (StringUtil.isNotEmpty((String)subjectRule)) {
            tmp.setSubjectRule(subjectRule);
        }
        tmp.setDescription(ext.getDescription());
        tmp.setStartNotifyType(ext.getStartNotifyType());
        tmp.setArchiveNotifyType(ext.getArchiveNotifyType());
        tmp.setNotifyType(ext.getNotifyType());
        tmp.setSkipFirstNode(ext.isSkipFirstNode());
        tmp.setFirstNodeUserAssign(ext.isFirstNodeUserAssign());
        tmp.setSkipSameUser(ext.isSkipSameUser());
        tmp.setAllowCopyTo(ext.isAllowCopyTo());
        tmp.setAllowTransTo(ext.isAllowTransTo());
        tmp.setUseMainForm(ext.getUseMainForm());
        tmp.setAllowReference(ext.isAllowReference());
        tmp.setAllowRefCounts(ext.getAllowRefCounts());
        tmp.setAllowSignet(ext.getAllowSignet());
        tmp.setDateType(ext.getDateType());
        tmp.setDueTime(ext.getDueTime());
        tmp.setCheckLimit(ext.getCheckLimit());
        tmp.setStartLimit(ext.getStartLimit());
        tmp.setCopySetting(ext.getCopySetting());
        tmp.setEndRevoke(ext.isEndRevoke());
        tmp.setMsgConfig(ext.getMsgConfig());
        tmp.setSkipExecutorEmpty(ext.isSkipExecutorEmpty());
        tmp.setAllowExecutorEmpty(ext.isAllowExecutorEmpty());
        tmp.setTestNotifyType(ext.getTestNotifyType());
        tmp.setDoneDataVersion(ext.getDoneDataVersion());
        tmp.setAutoRunConfig(ext.getAutoRunConfig());
        ArrayList<ExtProperty> rtnList = new ArrayList<ExtProperty>();
        List<com.hotent.bpm.defxml.entity.ext.ExtProperty> list = ext.getExtProperty();
        if (BeanUtils.isNotEmpty(list)) {
            for (com.hotent.bpm.defxml.entity.ext.ExtProperty ex : list) {
                ExtProperty extProp = new ExtProperty(ex.getName(), ex.getValue());
                rtnList.add(extProp);
            }
        }
        tmp.setSkipRules(ext.getSkipRules());
        tmp.setExtProperty(rtnList);
        return tmp;
    }

    private void handBpmPluginContexts(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) throws Exception {
        ExtPlugins extPlugins = extProcess.getExtPlugins();
        if (extPlugins == null) {
            return;
        }
        ArrayList<BpmPluginContext> pluginContextList = new ArrayList<BpmPluginContext>();
        ArrayList<ProcessInstAopPluginContext> processInstAopPluginContexts = new ArrayList<ProcessInstAopPluginContext>();
        List<Object> list = extPlugins.getAny();
        for (Object obj : list) {
            Element el;
            BpmPluginContext initPluginContext;
            if (!(obj instanceof Element) || (initPluginContext = (BpmPluginContext)AppUtil.getBean((String)((el = (Element)obj).getLocalName() + "PluginContext"))) == null) continue;
            PluginContext pluginContext = (PluginContext)BeanUtils.cloneBean((Object)initPluginContext);
            if (pluginContext instanceof BpmPluginContext) {
                BpmPluginDef bpmPluginDef = pluginContext.parse(el);
                ((AbstractBpmPluginContext)pluginContext).setBpmPluginDef(bpmPluginDef);
                pluginContextList.add((BpmPluginContext)pluginContext);
                continue;
            }
            if (!(pluginContext instanceof ProcessInstAopPluginContext)) continue;
            ProcessInstAopPluginDef processInstAopPluginDef = (ProcessInstAopPluginDef)pluginContext.parse(el);
            ((AbstractProcessInstAopPluginContext)pluginContext).setProcessInstAopPluginDef(processInstAopPluginDef);
            processInstAopPluginContexts.add((ProcessInstAopPluginContext)pluginContext);
        }
        processDefExt.setPluginContextList(pluginContextList);
        processDefExt.setProcessInstAopPluginContexts(processInstAopPluginContexts);
    }

    private void handVariables(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) {
        VarDefs varDefs = extProcess.getVarDefs();
        if (varDefs == null) {
            return;
        }
        List<VariableDef> list = varDefs.getVariableDef();
        ArrayList<BpmVariableDef> varList = new ArrayList<BpmVariableDef>();
        for (VariableDef v : list) {
            DefaultBpmVariableDef pv = new DefaultBpmVariableDef();
            pv.setDataType(v.getType() != null ? v.getType().value() : "string");
            pv.setName(v.getName());
            pv.setRequired(v.isIsRequired() == null ? false : v.isIsRequired());
            pv.setVarKey(v.getKey());
            pv.setDescription(v.getDescription());
            Object val = DefaultBpmVariableDef.getValue(pv.getDataType(), v.getDefaultVal());
            pv.setDefaultVal(val);
            varList.add(pv);
        }
        processDefExt.setVarList(varList);
    }

    private void handWordPrints(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) {
        WordPrints wordPrintDef = extProcess.getWordPrints();
        if (wordPrintDef == null) {
            return;
        }
        List<WordPrintDef> list = wordPrintDef.getwordPrintDef();
        ArrayList<BpmWordPrintDef> wordPrintList = new ArrayList<BpmWordPrintDef>();
        for (WordPrintDef v : list) {
            DefaultBpmWordPrint pv = new DefaultBpmWordPrint();
            pv.setAlias(v.getAlias());
            pv.setName(v.getName());
            pv.setPreview(v.getPreview());
            pv.setDownload(v.getDownload());
            pv.setWatermark(v.getWatermark());
            pv.setRange(v.getRange());
            pv.setDesc(v.getDesc());
            wordPrintList.add(pv);
        }
        processDefExt.setWordPrintList(wordPrintList);
    }

    private void handNodeVariables(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess, List<BpmNodeDef> list) {
        ExtProcess.ExtNodes extNodes = extProcess.getExtNodes();
        List<Object> baseNodes = extNodes.getUserNodeOrSignNodeOrBaseNode();
        HashMap<String, List<BpmVariableDef>> nodeVariables = new HashMap<String, List<BpmVariableDef>>();
        for (Object baseNode : baseNodes) {
            String nodeId = BpmDefAccessorUtil.getNodeId(baseNode);
            ArrayList<DefaultBpmVariableDef> varList = new ArrayList<DefaultBpmVariableDef>();
            VarDefs varDefs = BpmDefAccessorUtil.getVarDefs(baseNode);
            if (varDefs == null) continue;
            List<VariableDef> varDefList = varDefs.getVariableDef();
            for (VariableDef v : varDefList) {
                DefaultBpmVariableDef pv = new DefaultBpmVariableDef();
                pv.setDataType(v.getType().value());
                pv.setName(v.getName());
                pv.setRequired(v.isIsRequired() == null ? false : v.isIsRequired());
                pv.setVarKey(v.getKey());
                Object val = DefaultBpmVariableDef.getValue(pv.getDataType(), v.getDefaultVal());
                pv.setDefaultVal(val);
                varList.add(pv);
            }
            nodeVariables.put(nodeId, varList);
        }
        processDefExt.setNodeVariables(nodeVariables);
    }

    private void handBoDefList(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) {
        ExtProcess.BoList boList = extProcess.getBoList();
        if (boList == null) {
            return;
        }
        BoSaveMode saveMode = boList.getSaveMode();
        if (BeanUtils.isEmpty((Object)((Object)saveMode))) {
            saveMode = BoSaveMode.DATABASE;
        }
        processDefExt.setBoSaveToDb(saveMode.equals((Object)BoSaveMode.DATABASE));
        List<BoDef> list = boList.getBoDef();
        ArrayList<ProcBoDef> boDefList = new ArrayList<ProcBoDef>();
        for (BoDef bo : list) {
            ProcBoDef procBodef = new ProcBoDef(bo.getName(), bo.getKey());
            procBodef.setParentDefKey(bo.getParentDefKey());
            procBodef.setRequired(bo.isIsRequired());
            boDefList.add(procBodef);
        }
        processDefExt.setBoDefList(boDefList);
    }

    private void handInstFormList(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) {
        ExtProcess.InstForm instForm = extProcess.getInstForm();
        if (instForm == null) {
            return;
        }
        ArrayList<com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt> forms = new ArrayList<com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt>();
        List<Form> list = instForm.getFormOrMobileForm();
        for (Form frm : list) {
            String pareFlowKey = frm.getParentFlowKey();
            DefaultFormExt form = new DefaultFormExt();
            form.setParentFlowKey(pareFlowKey);
            form.setName(frm.getName());
            if (frm instanceof MobileForm) {
                form.setFormType(FormType.MOBILE.value());
            } else {
                FormExt frmExt = (FormExt)frm;
                form.setPrevHandler(frmExt.getPrevHandler());
                form.setPostHandler(frmExt.getPostHandler());
            }
            form.setFormValue(frm.getFormValue());
            form.setFormExtraConf(frm.getFormExtraConf());
            form.setHelpFile(frm.getHelpFile());
            if (frm.getType() != null) {
                form.setType(FormCategory.fromValue(frm.getType().value()));
            }
            forms.add(form);
        }
        processDefExt.setAllInstForm(forms);
    }

    private void handGlobalFormList(DefaultBpmProcessDefExt processDefExt, ExtProcess extProcess) {
        ExtProcess.GlobalForm globalForm = extProcess.getGlobalForm();
        if (globalForm == null) {
            return;
        }
        ArrayList<com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt> forms = new ArrayList<com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt>();
        List<Form> list = globalForm.getFormOrMobileForm();
        for (Form frm : list) {
            String pareFlowKey = frm.getParentFlowKey();
            DefaultFormExt form = new DefaultFormExt();
            form.setParentFlowKey(pareFlowKey);
            form.setName(frm.getName());
            if (frm instanceof MobileForm) {
                form.setFormType(FormType.MOBILE.value());
            } else {
                FormExt frmExt = (FormExt)frm;
                form.setPrevHandler(frmExt.getPrevHandler());
                form.setPostHandler(frmExt.getPostHandler());
            }
            form.setFormValue(frm.getFormValue());
            form.setFormExtraConf(frm.getFormExtraConf());
            form.setHelpFile(frm.getHelpFile());
            if (frm.getType() != null) {
                form.setType(FormCategory.fromValue(frm.getType().value()));
            }
            forms.add(form);
        }
        processDefExt.setAllGlobalForm(forms);
    }

    private void handNodeSetting(List<BpmNodeDef> list) throws Exception {
        for (BpmNodeDef def : list) {
            SubProcessNodeDef subDef;
            BpmProcessDef<? extends BpmProcessDefExt> proc;
            this.handNode((BaseBpmNodeDef)def);
            if (!(def instanceof SubProcessNodeDef) || (proc = (subDef = (SubProcessNodeDef)def).getChildBpmProcessDef()) == null) continue;
            List<BpmNodeDef> templist = proc.getBpmnNodeDefs();
            this.handNodeSetting(templist);
        }
    }

    public void setProcessDefNodes(BpmNodeDef parentNodeDef, List<JAXBElement<? extends FlowElement>> jaxbElementFlowElements, DefaultBpmProcessDef bpmProcessDef) {
        Map<String, FlowElement> nodeMap = this.getNodeList(jaxbElementFlowElements);
        List<SequenceFlow> seqList = this.getSequenceFlowList(jaxbElementFlowElements);
        Map<String, BpmNodeDef> nodeDefMap = this.getBpmNodeDef(nodeMap, parentNodeDef, bpmProcessDef);
        this.setRelateNodeDef(nodeDefMap, seqList);
        ArrayList<BpmNodeDef> nodeDefList = new ArrayList<BpmNodeDef>(nodeDefMap.values());
        Collections.sort(nodeDefList, new BpmNodeDefComparator());
        bpmProcessDef.setBpmnNodeDefs(nodeDefList);
        for (BpmNodeDef nodeDef : nodeDefList) {
            BaseBpmNodeDef node = (BaseBpmNodeDef)nodeDef;
            node.setBpmProcessDef(bpmProcessDef);
        }
    }

    private void handNode(BaseBpmNodeDef nodeDef) throws Exception {
        String nodeId = nodeDef.getNodeId();
        LOGGER.debug("nodeId:{}", (Object)nodeId);
        BpmProcessDef<BpmProcessDefExt> processDef = nodeDef.getRootProcessDef();
        DefaultBpmProcessDefExt processDefExt = (DefaultBpmProcessDefExt)processDef.getProcessDefExt();
        ExtDefinitions def = processDefExt.getDefinitions();
        ExtProcess extProcess = def.getExtProcess();
        if (extProcess == null) {
            return;
        }
        ExtProcess.ExtNodes extNodes = extProcess.getExtNodes();
        if (extNodes == null) {
            return;
        }
        List<Object> nodeList = extNodes.getUserNodeOrSignNodeOrBaseNode();
        if (BeanUtils.isEmpty(nodeList)) {
            return;
        }
        for (Object extNode : nodeList) {
            NodeHandler nodeHanler;
            String bpmnNodeId = BpmDefAccessorUtil.getNodeId(extNode);
            if (!bpmnNodeId.equalsIgnoreCase(nodeId) || (nodeHanler = HandlerFactory.createHandler(nodeDef)) == null) continue;
            nodeHanler.handNode(nodeDef, extNode);
        }
    }

    private Map<String, BpmNodeDef> getBpmNodeDef(Map<String, FlowElement> nodeMap, BpmNodeDef parentNodeDef, DefaultBpmProcessDef bpmProcessDef) {
        HashMap<String, BpmNodeDef> map = new HashMap<String, BpmNodeDef>();
        Set<Map.Entry<String, FlowElement>> set = nodeMap.entrySet();
        for (Map.Entry<String, FlowElement> ent : set) {
            FlowElement flowEl = ent.getValue();
            BaseBpmNodeDef nodeDef = this.getNodeDef(parentNodeDef, flowEl, bpmProcessDef);
            map.put(ent.getKey(), nodeDef);
        }
        return map;
    }

    private void setRelateNodeDef(Map<String, BpmNodeDef> nodeDefMap, List<SequenceFlow> seqList) {
        for (SequenceFlow seq : seqList) {
            Expression conditionEx;
            if (!BeanUtils.isNotEmpty((Object)seq.getSourceRef()) || !BeanUtils.isNotEmpty((Object)seq.getTargetRef())) continue;
            FlowElement source = (FlowElement)seq.getSourceRef();
            FlowElement target = (FlowElement)seq.getTargetRef();
            BpmNodeDef sourceDef = nodeDefMap.get(source.getId());
            BpmNodeDef targetDef = nodeDefMap.get(target.getId());
            sourceDef.addOutcomeNode(targetDef);
            targetDef.addIncomeNode(sourceDef);
            if (seq.getId().equals(sourceDef.getDefaultSequenceFlowId())) {
                sourceDef.setDefaultOutcome(targetDef);
            }
            if ((conditionEx = seq.getConditionExpression()) == null) continue;
            String condition = "";
            List<Serializable> list = conditionEx.getContent();
            for (Serializable str : list) {
                condition = condition + str.toString();
            }
            sourceDef.addCondition(targetDef.getNodeId(), condition);
        }
    }

    private Map<String, FlowElement> getNodeList(List<JAXBElement<? extends FlowElement>> list) {
        HashMap<String, FlowElement> map = new HashMap<String, FlowElement>();
        for (JAXBElement<? extends FlowElement> jAXBElement : list) {
            FlowElement flowElement = (FlowElement)jAXBElement.getValue();
            this.addNode(flowElement, map, this.aryNodeElement);
        }
        return map;
    }

    private List<SequenceFlow> getSequenceFlowList(List<JAXBElement<? extends FlowElement>> list) {
        ArrayList<SequenceFlow> nodeList = new ArrayList<SequenceFlow>();
        for (JAXBElement<? extends FlowElement> jAXBElement : list) {
            FlowElement flowElement = (FlowElement)jAXBElement.getValue();
            if (!(flowElement instanceof SequenceFlow)) continue;
            nodeList.add((SequenceFlow)flowElement);
        }
        return nodeList;
    }

    private BaseBpmNodeDef getNodeDef(BpmNodeDef parentNodeDef, FlowElement flowElement, DefaultBpmProcessDef bpmProcessDef) {
        BaseBpmNodeDef nodeDef = null;
        if (flowElement instanceof StartEvent) {
            nodeDef = new BaseBpmNodeDef();
            nodeDef.setType(NodeType.START);
        } else if (flowElement instanceof EndEvent) {
            nodeDef = new BaseBpmNodeDef();
            nodeDef.setType(NodeType.END);
        } else if (flowElement instanceof Gateway) {
            nodeDef = new GateWayBpmNodeDef();
            if (flowElement instanceof ParallelGateway) {
                nodeDef.setType(NodeType.PARALLELGATEWAY);
            } else if (flowElement instanceof InclusiveGateway) {
                nodeDef.setType(NodeType.INCLUSIVEGATEWAY);
                InclusiveGateway exclusiveGateway = (InclusiveGateway)flowElement;
                if (exclusiveGateway.getDefault() instanceof SequenceFlow) {
                    nodeDef.setDefaultSequenceFlowId(((SequenceFlow)exclusiveGateway.getDefault()).getId());
                }
            } else if (flowElement instanceof ExclusiveGateway) {
                nodeDef.setType(NodeType.EXCLUSIVEGATEWAY);
                ExclusiveGateway exclusiveGateway = (ExclusiveGateway)flowElement;
                if (exclusiveGateway.getDefault() instanceof SequenceFlow) {
                    nodeDef.setDefaultSequenceFlowId(((SequenceFlow)exclusiveGateway.getDefault()).getId());
                }
            }
        } else if (flowElement instanceof Activity) {
            String multi = this.getNodeDefLoop((Activity)flowElement);
            if (flowElement instanceof UserTask) {
                Map<QName, String> otherAttributes = flowElement.getOtherAttributes();
                QName signType = new QName("signType");
                if ("no".equals(multi)) {
                    UserTaskNodeDef userTaskDef = new UserTaskNodeDef();
                    nodeDef = userTaskDef;
                    nodeDef.setType(NodeType.USERTASK);
                } else if (otherAttributes.containsKey(signType) && StringUtils.isNotEmpty((String)otherAttributes.get(signType))) {
                    CustomSignNodeDef customSignNodeDef = new CustomSignNodeDef();
                    boolean isParallel = "parallel".equals(multi);
                    customSignNodeDef.setParallel(isParallel);
                    customSignNodeDef.setSignType(otherAttributes.get(signType));
                    nodeDef = customSignNodeDef;
                    nodeDef.setType(NodeType.CUSTOMSIGNTASK);
                    nodeDef.setAttribute("signtype", otherAttributes.get(signType));
                } else {
                    SignNodeDef signNodeDef = new SignNodeDef();
                    boolean isParallel = "parallel".equals(multi);
                    signNodeDef.setParallel(isParallel);
                    nodeDef = signNodeDef;
                    nodeDef.setType(NodeType.SIGNTASK);
                }
            } else if (flowElement instanceof ServiceTask) {
                nodeDef = new ServiceNodeDef();
            } else if (flowElement instanceof CallActivity) {
                CallActivityNodeDef callNodeDef = new CallActivityNodeDef();
                CallActivity call = (CallActivity)flowElement;
                String flowKey = call.getCalledElement();
                callNodeDef.setType(NodeType.CALLACTIVITY);
                callNodeDef.setFlowKey(flowKey);
                this.setMulti(callNodeDef, multi);
                nodeDef = callNodeDef;
            } else if (flowElement instanceof SubProcess) {
                SubProcessNodeDef subProcessDef = new SubProcessNodeDef();
                this.setMulti(subProcessDef, multi);
                nodeDef = subProcessDef;
                nodeDef.setNodeId(flowElement.getId());
                nodeDef.setName(flowElement.getName());
                nodeDef.setParentBpmNodeDef(parentNodeDef);
                subProcessDef.setBpmProcessDef(bpmProcessDef);
                SubProcess subProcess = (SubProcess)flowElement;
                this.handSubProcess(nodeDef, subProcess, bpmProcessDef);
            }
        }
        nodeDef.setParentBpmNodeDef(parentNodeDef);
        nodeDef.setNodeId(flowElement.getId());
        nodeDef.setName(flowElement.getName());
        nodeDef.setOrder(BpmUtil.getFlowElementOrder(flowElement));
        return nodeDef;
    }

    private void setMulti(MultiInstanceDef nodeDef, String multi) {
        if ("no".equals(multi)) {
            nodeDef.setSupportMuliInstance(false);
        } else {
            nodeDef.setSupportMuliInstance(true);
            boolean isParallel = "parallel".equals(multi);
            nodeDef.setParallel(isParallel);
        }
    }

    private void addNode(FlowElement flowElement, Map<String, FlowElement> map, Class<? extends FlowElement> ... flowTypes) {
        for (Class<? extends FlowElement> flowType : flowTypes) {
            if (!flowType.isInstance(flowElement)) continue;
            map.put(flowElement.getId(), flowElement);
            break;
        }
    }

    private void handSubProcess(BaseBpmNodeDef nodeDef, SubProcess subProcess, DefaultBpmProcessDef parentProcessDef) {
        DefaultBpmProcessDef bpmProcessDef = new DefaultBpmProcessDef();
        bpmProcessDef.setProcessDefinitionId(subProcess.getId());
        bpmProcessDef.setName(subProcess.getName());
        bpmProcessDef.setDefKey(subProcess.getId());
        bpmProcessDef.setParentProcessDef(parentProcessDef);
        SubProcessNodeDef subNodeDef = (SubProcessNodeDef)nodeDef;
        subNodeDef.setBpmProcessDef(parentProcessDef);
        subNodeDef.setChildBpmProcessDef(bpmProcessDef);
        List<JAXBElement<? extends FlowElement>> list = subProcess.getFlowElement();
        this.setProcessDefNodes(nodeDef, list, bpmProcessDef);
    }

    private String getNodeDefLoop(Activity flowElement) {
        JAXBElement<? extends LoopCharacteristics> jaxbloop = flowElement.getLoopCharacteristics();
        if (jaxbloop == null) {
            return "no";
        }
        LoopCharacteristics loop = (LoopCharacteristics)jaxbloop.getValue();
        if (loop instanceof MultiInstanceLoopCharacteristics) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = (MultiInstanceLoopCharacteristics)loop;
            return multiInstanceLoopCharacteristics.isIsSequential() ? "sequence" : "parallel";
        }
        return "no";
    }
}

