/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.util;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.task.NodeDefTransient;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.model.NodeAndTargetNode;
import com.hotent.bpm.model.def.SubProcessStartOrEndEventModel;
import com.hotent.bpm.persistence.dao.BpmExeStackRelationDao;
import com.hotent.bpm.persistence.manager.ActExecutionManager;
import com.hotent.bpm.persistence.manager.ActTaskManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmExeStackRelationManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.ActExecution;
import com.hotent.bpm.persistence.model.ActTask;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.model.BpmExeStackRelation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BpmStackRelationUtil {
    public static List<NodeDefTransient> getInComeGateway(String defId, String nodeId, BpmExeStack fromStack) throws Exception {
        String isSubProcessMultiStartOrEndEvent;
        ArrayList<NodeDefTransient> listResult = new ArrayList<NodeDefTransient>();
        if (fromStack == null) {
            return null;
        }
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        String currentEventType = cmd.getTransitVars("CurrentEventType") != null ? cmd.getTransitVars("CurrentEventType").toString() : null;
        String string = isSubProcessMultiStartOrEndEvent = cmd.getTransitVars("SubProcessMultiStartOrEndEvent") != null ? cmd.getTransitVars("SubProcessMultiStartOrEndEvent").toString() : null;
        if (isSubProcessMultiStartOrEndEvent != null) {
            Object variable;
            SubProcessStartOrEndEventModel model = (SubProcessStartOrEndEventModel)cmd.getTransitVars("SubProcessMultiStartOrEndEventModel");
            String nodeType = model.getNoteType();
            String inComeNodeId = model.getNodeId();
            BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(fromStack.getPrcoDefId(), inComeNodeId);
            if (bpmNodeDef == null && model.bpmDelegateExecution != null && (variable = model.bpmDelegateExecution.getVariable("processDefId_")) != null) {
                bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(variable.toString(), inComeNodeId);
            }
            NodeDefTransient nodeDef = new NodeDefTransient(bpmNodeDef);
            nodeDef.setType(NodeType.fromKey(nodeType));
            listResult.add(nodeDef);
            return listResult;
        }
        if (currentEventType != null && currentEventType.equals("SubProcessStartOrEndEvent")) {
            Object variable;
            SubProcessStartOrEndEventModel model = (SubProcessStartOrEndEventModel)cmd.getTransitVars("SubProcessStartOrEndEventModel");
            String nodeType = model.getNoteType();
            String inComeNodeId = model.getNodeId();
            BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(fromStack.getPrcoDefId(), inComeNodeId);
            if (bpmNodeDef == null && model.bpmDelegateExecution != null && (variable = model.bpmDelegateExecution.getVariable("processDefId_")) != null) {
                bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(variable.toString(), inComeNodeId);
            }
            NodeDefTransient nodeDef = new NodeDefTransient(bpmNodeDef);
            nodeDef.setType(NodeType.fromKey(nodeType));
            listResult.add(nodeDef);
            return listResult;
        }
        NodeDefTransient nodeDef = null;
        ArrayList<NodeDefTransient> histSearchNodeList = new ArrayList<NodeDefTransient>();
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<BpmNodeDef> inComeList = bpmNodeDef.getIncomeNodes();
        String parentNodeId = fromStack.getNodeId();
        for (BpmNodeDef node : inComeList) {
            if (nodeDef != null) break;
            NodeType noteType = node.getType();
            if (!noteType.equals((Object)NodeType.EXCLUSIVEGATEWAY) && !noteType.equals((Object)NodeType.PARALLELGATEWAY) && !noteType.equals((Object)NodeType.INCLUSIVEGATEWAY)) continue;
            histSearchNodeList.add(new NodeDefTransient(node));
            nodeDef = BpmStackRelationUtil.getInComeDateWay(node, parentNodeId, histSearchNodeList);
        }
        return histSearchNodeList;
    }

    private static NodeDefTransient getInComeDateWay(BpmNodeDef node, String parentNodeId, List<NodeDefTransient> histSearchNodeList) {
        NodeDefTransient resultNode = null;
        List<BpmNodeDef> inList = node.getIncomeNodes();
        for (BpmNodeDef theNode : inList) {
            if (theNode.getNodeId().equals(parentNodeId)) {
                resultNode = new NodeDefTransient(node);
                break;
            }
            NodeType noteType = theNode.getType();
            if (!noteType.equals((Object)NodeType.EXCLUSIVEGATEWAY) && !noteType.equals((Object)NodeType.PARALLELGATEWAY) && !noteType.equals((Object)NodeType.INCLUSIVEGATEWAY)) continue;
            histSearchNodeList.add(new NodeDefTransient(theNode));
            resultNode = BpmStackRelationUtil.getInComeDateWay(theNode, parentNodeId, histSearchNodeList);
        }
        if (BeanUtils.isNotEmpty(histSearchNodeList) && resultNode == null) {
            for (NodeDefTransient item : histSearchNodeList) {
                if (!item.getNodeId().equals(node.getNodeId())) continue;
                histSearchNodeList.remove(item);
                break;
            }
        }
        if (resultNode != null && histSearchNodeList != null && histSearchNodeList.size() > 0) {
            resultNode = histSearchNodeList.get(0);
        }
        return resultNode;
    }

    public static boolean isHaveAndOrGateway(String bpmProcInstId, String ondeId, String direction) throws Exception {
        BpmExeStackRelationDao relationDao = (BpmExeStackRelationDao)AppUtil.getBean(BpmExeStackRelationDao.class);
        List<BpmExeStackRelation> list = relationDao.getListByProcInstId(bpmProcInstId);
        return BpmStackRelationUtil.isHaveAndOrGateway(bpmProcInstId, ondeId, direction, list);
    }

    public static boolean isHaveAndOrGateway(String bpmProcInstId, String nodeId, String direction, List<BpmExeStackRelation> list) throws Exception {
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmExeStackRelation relation = null;
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            Object toNodeId;
            String fromNodeId = bpmExeStackRelation.getFromNodeId();
            if (fromNodeId.equals(toNodeId = bpmExeStackRelation.getToNodeId())) continue;
            if ("pre".equals(direction)) {
                if (!((String)toNodeId).equals(nodeId)) continue;
                relation = bpmExeStackRelation;
                break;
            }
            if (!"after".equals(direction) || !fromNodeId.equals(nodeId)) continue;
            relation = bpmExeStackRelation;
            break;
        }
        if (relation == null) {
            return false;
        }
        String rnodeType = relation.getToNodeType();
        String noteType = relation.getFromNodeType();
        if ("after".equals(direction)) {
            rnodeType = relation.getFromNodeType();
            noteType = relation.getToNodeType();
        }
        if (noteType.equals(NodeType.PARALLELGATEWAY.getKey()) || noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) || noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) || noteType.equals(NodeType.SUBENDGATEWAY.getKey()) || noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey()) && !rnodeType.equals(NodeType.SIGNTASK.getKey())) {
            return true;
        }
        boolean hasHistoryNode = false;
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            if (!bpmExeStackRelation.getToNodeType().equals(NodeType.PARALLELGATEWAY.getKey()) && !noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) && !noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) && !noteType.equals(NodeType.SUBENDGATEWAY.getKey()) && !noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey())) continue;
            hasHistoryNode = true;
            break;
        }
        if (!hasHistoryNode) {
            return false;
        }
        BpmProcessInstance instance = (BpmProcessInstance)instanceManager.get((Serializable)((Object)bpmProcInstId));
        String defId = instance.getProcDefId();
        BpmNodeDef bpmNodeDef = direction.equals("pre") ? BpmStackRelationUtil.getPreParallelBpmNodeDef(list, relation, defId) : BpmStackRelationUtil.getAfterParallelBpmNodeDef(list, relation, defId);
        return bpmNodeDef != null;
    }

    public static void createBpmExeStackRelation(String procInstId, BpmExeStack fromBpmExeStack, BpmExeStack toBpmExeStack) {
        BpmExeStackRelation bpmExeStackRelation;
        if (fromBpmExeStack == null) {
            return;
        }
        BpmExeStackRelationManager bpmExeStackRelationManager = (BpmExeStackRelationManager)AppUtil.getBean(BpmExeStackRelationManager.class);
        if (!fromBpmExeStack.getId().equals(toBpmExeStack.getId()) && BeanUtils.isEmpty((Object)((Object)(bpmExeStackRelation = bpmExeStackRelationManager.getById(procInstId, fromBpmExeStack.getId(), toBpmExeStack.getId()))))) {
            BpmExeStackRelation entity = new BpmExeStackRelation();
            entity.setRelationId(UniqueIdUtil.getSuid());
            entity.setFromStackId(fromBpmExeStack.getId());
            entity.setToStackId(toBpmExeStack.getId());
            entity.setToNodeId(toBpmExeStack.getNodeId());
            entity.setToNodeType(toBpmExeStack.getNodeType());
            entity.setFromNodeId(fromBpmExeStack.getNodeId());
            String fromNodeType = fromBpmExeStack.getNodeType();
            entity.setFromNodeType(fromNodeType);
            entity.setProcInstId(procInstId);
            bpmExeStackRelationManager.create((Model)entity);
        }
    }

    private static BpmNodeDef getPreParallelBpmNodeDef(List<BpmExeStackRelation> list, BpmExeStackRelation relation, String defId) throws Exception {
        BpmExeStackRelation bpmExeStackRelation2;
        if (relation == null) {
            return null;
        }
        BpmNodeDef bpmNodeDef = null;
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        String noteType = relation.getFromNodeType();
        if (noteType.equals(NodeType.PARALLELGATEWAY.getKey()) || noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) || noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) || noteType.equals(NodeType.SUBENDGATEWAY.getKey()) || noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey())) {
            bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, relation.getToNodeId());
            return bpmNodeDef;
        }
        ArrayList<BpmExeStackRelation> listNewBpmExeStacks = new ArrayList<BpmExeStackRelation>();
        String fromStackId = relation.getFromStackId();
        for (BpmExeStackRelation bpmExeStackRelation2 : list) {
            if (bpmExeStackRelation2.getFromNodeId().equals(bpmExeStackRelation2.getToNodeId()) || !bpmExeStackRelation2.getToStackId().equals(fromStackId) || listNewBpmExeStacks.contains((Object)bpmExeStackRelation2)) continue;
            listNewBpmExeStacks.add(bpmExeStackRelation2);
        }
        Iterator<BpmExeStackRelation> iterator = listNewBpmExeStacks.iterator();
        while (iterator.hasNext() && (bpmNodeDef = BpmStackRelationUtil.getPreParallelBpmNodeDef(list, bpmExeStackRelation2 = iterator.next(), defId)) == null) {
        }
        return bpmNodeDef;
    }

    private static BpmNodeDef getAfterParallelBpmNodeDef(List<BpmExeStackRelation> list, BpmExeStackRelation relation, String defId) throws Exception {
        BpmNodeDef bpmNodeDef;
        block3: {
            BpmExeStackRelation bpmExeStackRelation2;
            if (relation == null) {
                return null;
            }
            bpmNodeDef = null;
            BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
            String noteType = relation.getToNodeType();
            if (noteType.equals(NodeType.PARALLELGATEWAY.getKey()) || noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) || noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) || noteType.equals(NodeType.SUBENDGATEWAY.getKey()) || noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey())) {
                bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, relation.getToNodeId());
                return bpmNodeDef;
            }
            ArrayList<BpmExeStackRelation> listNewBpmExeStacks = new ArrayList<BpmExeStackRelation>();
            String toStackId = relation.getToStackId();
            for (BpmExeStackRelation bpmExeStackRelation2 : list) {
                if (!bpmExeStackRelation2.getFromStackId().equals(toStackId) || listNewBpmExeStacks.contains((Object)bpmExeStackRelation2)) continue;
                listNewBpmExeStacks.add(bpmExeStackRelation2);
            }
            Iterator<BpmExeStackRelation> iterator = listNewBpmExeStacks.iterator();
            if (!iterator.hasNext()) break block3;
            bpmExeStackRelation2 = iterator.next();
            bpmNodeDef = BpmStackRelationUtil.getAfterParallelBpmNodeDef(list, bpmExeStackRelation2, defId);
        }
        return bpmNodeDef;
    }

    public static List<BpmNodeDef> getHistoryListBpmNodeDef(String bpmProcInstId, String ondeId, String direction) throws Exception {
        ArrayList<BpmNodeDef> listResult = new ArrayList<BpmNodeDef>();
        BpmExeStackRelationDao relationDao = (BpmExeStackRelationDao)AppUtil.getBean(BpmExeStackRelationDao.class);
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        List<BpmExeStackRelation> list = relationDao.getListByProcInstId(bpmProcInstId);
        BpmExeStackRelation relation = null;
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            if ("pre".equals(direction) && bpmExeStackRelation.getToNodeId().equals(ondeId) && !bpmExeStackRelation.getFromNodeId().equals(bpmExeStackRelation.getToNodeId())) {
                relation = bpmExeStackRelation;
                break;
            }
            if (!"after".equals(direction) || !bpmExeStackRelation.getFromNodeId().equals(ondeId) || bpmExeStackRelation.getFromNodeId().equals(bpmExeStackRelation.getToNodeId())) continue;
            relation = bpmExeStackRelation;
            break;
        }
        if (relation == null) {
            return listResult;
        }
        BpmProcessInstance instance = (BpmProcessInstance)instanceManager.get((Serializable)((Object)bpmProcInstId));
        String defId = instance.getProcDefId();
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        List<BpmNodeDef> allNodeDef = bpmDefinitionAccessor.getAllNodeDef(defId);
        HashMap<String, BpmNodeDef> nodeMap = new HashMap<String, BpmNodeDef>();
        for (BpmNodeDef bpmNodeDef : allNodeDef) {
            nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
        }
        HashMap<String, BpmNodeDef> resultMap = new HashMap<String, BpmNodeDef>();
        ArrayList<BpmExeStackRelation> resultRelation = new ArrayList<BpmExeStackRelation>();
        BpmStackRelationUtil.getHistoryListBpmNodeDef(list, relation, direction, nodeMap, resultMap, resultRelation);
        if (BeanUtils.isEmpty(resultRelation)) {
            return listResult;
        }
        Collections.sort(resultRelation, new Comparator<BpmExeStackRelation>(){

            @Override
            public int compare(BpmExeStackRelation opinion1, BpmExeStackRelation opinion2) {
                return opinion2.getCreatedTime().compareTo(opinion1.getCreatedTime());
            }
        });
        for (BpmExeStackRelation bpmExeStackRelation : resultRelation) {
            String nodeId = direction.equals("pre") ? bpmExeStackRelation.getFromNodeId() : bpmExeStackRelation.getToNodeId();
            if (!resultMap.containsKey(nodeId)) continue;
            listResult.add((BpmNodeDef)resultMap.get(nodeId));
        }
        return listResult;
    }

    private static void getHistoryListBpmNodeDef(List<BpmExeStackRelation> list, BpmExeStackRelation relation, String direction, Map<String, BpmNodeDef> nodeMap, Map<String, BpmNodeDef> resultMap, List<BpmExeStackRelation> resultRelation) throws Exception {
        String nodeId;
        if (relation == null || relation.getToNodeId().equals(relation.getFromNodeId())) {
            return;
        }
        String string = nodeId = direction.equals("pre") ? relation.getFromNodeId() : relation.getToNodeId();
        if (resultMap.containsKey(nodeId)) {
            return;
        }
        BpmNodeDef bpmNodeDef = nodeMap.get(nodeId);
        if (bpmNodeDef != null && (bpmNodeDef instanceof UserTaskNodeDef || bpmNodeDef instanceof SignNodeDef || bpmNodeDef instanceof CallActivityNodeDef)) {
            resultMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
            resultRelation.add(relation);
        }
        String fromStackId = relation.getFromStackId();
        String toStackId = relation.getToStackId();
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            if (bpmExeStackRelation.getFromStackId().equals(bpmExeStackRelation.getToStackId())) continue;
            if (direction.equals("pre") && bpmExeStackRelation.getToStackId().equals(fromStackId)) {
                BpmStackRelationUtil.getHistoryListBpmNodeDef(list, bpmExeStackRelation, direction, nodeMap, resultMap, resultRelation);
                continue;
            }
            if (!direction.equals("after") || !bpmExeStackRelation.getFromStackId().equals(toStackId)) continue;
            BpmStackRelationUtil.getHistoryListBpmNodeDef(list, bpmExeStackRelation, direction, nodeMap, resultMap, resultRelation);
        }
    }

    public static boolean isHaveMultiGatewayByBetweenNode(String bpmProcInstId, String startNodeId, String endNodeId) throws Exception {
        List<BpmNodeDef> list = BpmStackRelationUtil.getHistoryListByBetweenNode(bpmProcInstId, startNodeId, endNodeId);
        for (BpmNodeDef bpmNodeDef : list) {
            SubProcessNodeDef subNodeDef;
            if (SubProcessNodeDef.class.getName().equals(bpmNodeDef.getClass().getName()) && (subNodeDef = (SubProcessNodeDef)bpmNodeDef).isParallel()) {
                return true;
            }
            String noteType = bpmNodeDef.getType().getKey();
            if (!noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey()) && !noteType.equals(NodeType.SUBENDGATEWAY.getKey())) continue;
            return true;
        }
        return false;
    }

    public static List<BpmNodeDef> getHistoryListByBetweenNode(String bpmProcInstId, String startNodeId, String endNodeId) throws Exception {
        ArrayList<BpmNodeDef> list = new ArrayList<BpmNodeDef>();
        List<BpmNodeDef> listStartNodeIdPre = BpmStackRelationUtil.getHistoryListBpmNodeDef(bpmProcInstId, startNodeId, "after");
        List<BpmNodeDef> listEndNodeIdafter = BpmStackRelationUtil.getHistoryListBpmNodeDef(bpmProcInstId, endNodeId, "pre");
        for (BpmNodeDef startNode : listStartNodeIdPre) {
            for (BpmNodeDef endNode : listEndNodeIdafter) {
                if (!startNode.getNodeId().equals(endNode.getNodeId())) continue;
                list.add(startNode);
            }
        }
        return list;
    }

    public static boolean instancesRejectDirectAdjust(String rejectDirectExecutionId) {
        List<String> parentsId;
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)rejectDirectExecutionId));
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if (currentExecution == null) {
            return true;
        }
        Object rejectDirectParentId = cmd.getTransitVars("rejectDirectParentId");
        if (rejectDirectParentId != null && !rejectDirectParentId.toString().equals(currentExecution.getParentId()) && currentExecution.getParentId().equals(currentExecution.getProcInstId()) && BeanUtils.isNotEmpty(parentsId = actExecutionManager.getByParentsId(currentExecution.getParentId())) && parentsId.size() > 1) {
            for (String parentId : parentsId) {
                if (parentId.equals(currentExecution.getId())) continue;
                currentExecution.setParentId(parentId);
                actExecutionManager.update((Model)currentExecution);
                break;
            }
        }
        return true;
    }

    public static boolean parallelGatewayRejectDirectAdjust(String parentExecutionId) {
        List<String> parentsId;
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        ActExecution parentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)parentExecutionId));
        ActTaskManager actTaskManager = (ActTaskManager)AppUtil.getBean(ActTaskManager.class);
        if (parentExecution == null) {
            return true;
        }
        String actProcInstanceId = parentExecution.getProcInstId();
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        String rejectTargetNodeId = cmd.getDestination();
        String actionName = cmd.getActionName();
        if (StringUtil.isNotEmpty((String)rejectTargetNodeId) && !"reject".equals(actionName) && !"backToStart".equals(actionName) && BeanUtils.isNotEmpty(parentsId = actExecutionManager.getByParentsId(parentExecution.getId()))) {
            ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)parentsId.get(0)));
            if (parentExecution.isConcurrent() && !parentExecutionId.equals(parentExecution.getProcInstId())) {
                parentExecution.setActive(true);
                parentExecution.setActId(currentExecution.getActId());
                actExecutionManager.update((Model)parentExecution);
                List<ActTask> actTasks = actTaskManager.getByInstId(actProcInstanceId);
                if (BeanUtils.isNotEmpty(actTasks)) {
                    for (ActTask actTask : actTasks) {
                        if (actTask.getTaskDefKey() == null || !actTask.getTaskDefKey().equals(parentExecution.getActId())) continue;
                        actTask.setExecutionId(parentExecutionId);
                        actTaskManager.update((Model)actTask);
                    }
                }
                actExecutionManager.remove((Serializable)((Object)currentExecution.getId()));
            }
        }
        return true;
    }

    public static boolean singleInstancesRejectAdjust(String rejectSingleExecutionId) {
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        BpmExeStackManager bpmExeStackManager = (BpmExeStackManager)AppUtil.getBean(BpmExeStackManager.class);
        ActTaskManager actTaskManager = (ActTaskManager)AppUtil.getBean(ActTaskManager.class);
        ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)rejectSingleExecutionId));
        if (currentExecution == null) {
            return true;
        }
        String actProcInstanceId = currentExecution.getProcInstId();
        bpmExeStackManager.multipleInstancesRejectAdjustOnActTask(rejectSingleExecutionId);
        bpmExeStackManager.multipleInstancesRejectAdjustOnActExecution(actProcInstanceId);
        if (actExecutionManager.get((Serializable)((Object)currentExecution.getId())) == null) {
            currentExecution.setParentId(actProcInstanceId);
            currentExecution.setScope(true);
            currentExecution.setConcurrent(false);
            actExecutionManager.create((Model)currentExecution);
            List<ActTask> actTasks = actTaskManager.getByInstId(actProcInstanceId);
            if (BeanUtils.isNotEmpty(actTasks)) {
                for (ActTask actTask : actTasks) {
                    actTask.setExecutionId(currentExecution.getId());
                    actTaskManager.update((Model)actTask);
                }
            }
        }
        return true;
    }

    public static boolean multipleInstancesRejectAdjust(String rejectAfterExecutionId) {
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        BpmExeStackManager bpmExeStackManager = (BpmExeStackManager)AppUtil.getBean(BpmExeStackManager.class);
        ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)rejectAfterExecutionId));
        if (currentExecution == null) {
            return true;
        }
        String nodeId = currentExecution.getActId();
        String actProcInstanceId = currentExecution.getProcInstId();
        bpmExeStackManager.multipleInstancesRejectAdjustOnBpmTask(rejectAfterExecutionId);
        bpmExeStackManager.multipleInstancesRejectAdjustOnActTask(rejectAfterExecutionId);
        bpmExeStackManager.multipleInstancesRejectAdjustOnActExecution(actProcInstanceId);
        currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)actProcInstanceId));
        currentExecution.setActId(nodeId);
        actExecutionManager.update((Model)currentExecution);
        return true;
    }

    public static List<BpmNodeDef> getAfterListNode(String defId, String nodeId) throws Exception {
        ArrayList<BpmNodeDef> listResult = new ArrayList<BpmNodeDef>();
        return BpmStackRelationUtil.getAfterListNode(defId, nodeId, listResult);
    }

    public static Set<String> getTaskNodeIdsFromStartNodeId(String procDefId, String procInstId, String startNodeId) throws Exception {
        HashSet<String> taskNodeIds = new HashSet();
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        List<String> nodeIds = bpmTaskManager.getNodeIdByProcInstId(procInstId);
        List<BpmNodeDef> after = BpmStackRelationUtil.getAllAfterListNodeAndTargetNode(procDefId, procInstId, startNodeId);
        taskNodeIds = after.stream().filter(bpmNodeDef -> nodeIds.contains(bpmNodeDef.getNodeId())).map(BpmNodeDef::getNodeId).collect(Collectors.toSet());
        return taskNodeIds;
    }

    public static List<BpmNodeDef> getAllAfterListNodeAndTargetNode(String defId, String procInstId, String nodeId) throws Exception {
        ArrayList<BpmNodeDef> listResult = new ArrayList<BpmNodeDef>();
        List<BpmNodeDef> afterListNode = BpmStackRelationUtil.getAfterListNode(defId, nodeId, listResult, true, true);
        List<String> afterNodeIds = afterListNode.stream().map(BpmNodeDef::getNodeId).collect(Collectors.toList());
        List<BpmNodeDef> targetNodes = BpmStackRelationUtil.getRejectTargetNode(defId, procInstId, afterNodeIds);
        afterListNode.addAll(targetNodes);
        return afterListNode;
    }

    public static List<BpmNodeDef> getRejectTargetNode(String defId, String procInstId, List<String> afterNodeIds) {
        ArrayList<BpmNodeDef> resultBpmNodeDef = new ArrayList<BpmNodeDef>();
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        List<NodeAndTargetNode> nodeIds = bpmTaskManager.getRejectTargetNode(procInstId, afterNodeIds);
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
        ((List)Optional.ofNullable(nodeIds).orElse(new ArrayList())).stream().forEach(nodeAndTargetNode -> {
            try {
                BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeAndTargetNode.getNodeId());
                bpmNodeDef.setTargetNode(nodeAndTargetNode.getTargetNode());
                resultBpmNodeDef.add(bpmNodeDef);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException("\u83b7\u53d6\u8282\u70b9\u5931\u8d25", (Throwable)e);
            }
        });
        return resultBpmNodeDef;
    }

    private static List<BpmNodeDef> getAfterListNode(String defId, String nodeId, List<BpmNodeDef> listResult, boolean searchAll, boolean containsNodeId) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmNodeDef nodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (containsNodeId) {
            listResult.add(nodeDef);
        }
        BpmStackRelationUtil.collectAfterListNode(nodeDef, listResult, searchAll);
        return listResult;
    }

    private static List<BpmNodeDef> getAfterListNode(String defId, String nodeId, List<BpmNodeDef> listResult, boolean searchAll) throws Exception {
        return BpmStackRelationUtil.getAfterListNode(defId, nodeId, listResult, searchAll, false);
    }

    private static void collectAfterListNode(BpmNodeDef nodeDef, List<BpmNodeDef> listResult, boolean searchAll) throws Exception {
        List<BpmNodeDef> listOut = nodeDef.getOutcomeNodes();
        ArrayList<String> userTaskTypes = new ArrayList<String>();
        userTaskTypes.add(NodeType.USERTASK.getKey());
        userTaskTypes.add(NodeType.SIGNTASK.getKey());
        for (BpmNodeDef outNode : listOut) {
            if (listResult.contains(outNode)) continue;
            BpmStackRelationUtil.collectSubProcessNodes(listResult, userTaskTypes, outNode);
            if (userTaskTypes.contains(outNode.getType().getKey())) {
                listResult.add(outNode);
                if (!searchAll) continue;
                BpmStackRelationUtil.collectAfterListNode(outNode, listResult, searchAll);
                continue;
            }
            BpmStackRelationUtil.collectAfterListNode(outNode, listResult, searchAll);
        }
    }

    private static void collectSubProcessNodes(List<BpmNodeDef> listResult, List<String> userTaskTypes, BpmNodeDef outNode) {
        if (NodeType.SUBPROCESS.equals((Object)outNode.getType())) {
            SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)outNode;
            List<BpmNodeDef> bpmnNodeDefs = subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs();
            List subProcessNodes = bpmnNodeDefs.stream().filter(childBpmNodeDef -> userTaskTypes.contains(childBpmNodeDef.getType().getKey())).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(subProcessNodes)) {
                listResult.addAll(subProcessNodes);
            }
            List subProcessNodeDefs = bpmnNodeDefs.stream().filter(childBpmNodeDef -> NodeType.SUBPROCESS.equals((Object)childBpmNodeDef.getType())).collect(Collectors.toList());
            subProcessNodeDefs = Optional.ofNullable(subProcessNodeDefs).orElse(new ArrayList());
            for (int i = 0; i < subProcessNodeDefs.size(); ++i) {
                BpmStackRelationUtil.collectSubProcessNodes(listResult, userTaskTypes, (BpmNodeDef)subProcessNodeDefs.get(i));
            }
        }
    }

    private static List<BpmNodeDef> getAfterListNode(String defId, String nodeId, List<BpmNodeDef> listResult) throws Exception {
        return BpmStackRelationUtil.getAfterListNode(defId, nodeId, listResult, false);
    }
}

