/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.util;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.ProcessInstCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.constant.BPMN20ExtConst;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.PrivilegeMode;
import com.hotent.bpm.api.constant.TaskActionType;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.NoExecutorEvent;
import com.hotent.bpm.api.event.NoExecutorModel;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.inst.ISkipCondition;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.IGlobalRestfulPluginDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.def.Restful;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.SkipResult;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginFactory;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.runtime.BpmExecutionPlugin;
import com.hotent.bpm.api.plugin.core.runtime.BpmTaskPlugin;
import com.hotent.bpm.api.plugin.core.task.TaskActionHandlerConfig;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.api.service.RestfulService;
import com.hotent.bpm.api.service.SignService;
import com.hotent.bpm.defxml.entity.ExtensionElements;
import com.hotent.bpm.defxml.entity.FlowElement;
import com.hotent.bpm.engine.form.BpmFormFactory;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.engine.task.skip.SkipConditionUtil;
import com.hotent.bpm.listener.BusDataUtil;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.dao.BpmExeStackRelationDao;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.DefaultBpmDefinitionAccessor;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.BpmExeStackRelation;
import com.hotent.bpm.persistence.model.BpmTaskDueTime;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.bpm.plugin.core.factory.DefaultBpmPluginFactory;
import com.hotent.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.hotent.bpm.plugin.task.userassign.def.UserAssignPluginDef;
import com.hotent.bpm.plugin.task.userassign.plugin.UserQueryPlugin;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.GrantedAuthority;
import org.w3c.dom.Element;

public class BpmUtil {
    public static BpmTask convertTask(BpmDelegateTask delegateTask) throws Exception {
        String taskId = delegateTask.getId();
        String subject = (String)delegateTask.getVariable("subject_");
        String instId = (String)delegateTask.getVariable("instanceId_");
        String bpmnDefId = delegateTask.getBpmnDefId();
        BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinitionService.getByBpmnDefId(bpmnDefId);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        BpmProcessInstance bpmProcessInstance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
        if (StringUtils.isNotEmpty((String)bpmProcessInstance.getSubject()) && !Objects.equals(subject, bpmProcessInstance.getSubject())) {
            subject = bpmProcessInstance.getSubject();
        }
        BpmFormService bpmFormService = BpmFormFactory.getFormService(FormType.MOBILE);
        FormModel formModel = bpmFormService.getByDefId(def.getId(), delegateTask.getTaskDefinitionKey(), bpmProcessInstance, true);
        int supportMobile = 0;
        if (formModel != null && !formModel.isFormEmpty()) {
            supportMobile = 1;
        }
        DefaultBpmTask task = new DefaultBpmTask();
        task.setId(taskId);
        task.setSubject(subject);
        task.setTaskId(taskId);
        task.setDueTime(delegateTask.getDueDate());
        task.setSuspendState((short)delegateTask.getSuspensionState());
        task.setExecId(delegateTask.getExecutionId());
        task.setName(delegateTask.getName());
        task.setNodeId(delegateTask.getTaskDefinitionKey());
        task.setProcInstId(instId);
        task.setBpmnInstId(delegateTask.getProcessInstanceId());
        task.setOwnerId("0");
        task.setAssigneeId("0");
        task.setPriority(Long.valueOf(delegateTask.getPriority()));
        task.setProcDefId(def.getDefId());
        task.setProcDefKey(def.getDefKey());
        task.setProcDefName(def.getName());
        task.setStatus(TaskType.NORMAL.name());
        task.setBpmnDefId(bpmnDefId);
        task.setTypeId(def.getTypeId());
        task.setSupportMobile(supportMobile);
        task.setCreateTime(delegateTask.getCreateTime());
        if (ActionType.BACK.getKey().equals(cmd.getActionName()) || ActionType.BACK_TO_START.getKey().equals(cmd.getActionName()) || ActionType.REJECT.getKey().equals(cmd.getActionName())) {
            task.setStatus(TaskType.BACK.name());
        } else if (ActionType.RECOVER.getKey().equals(cmd.getActionName()) || ActionType.RECOVER_TO_START.getKey().equals(cmd.getActionName())) {
            task.setStatus(TaskType.RECOVER.name());
        }
        return task;
    }

    public static DefaultBpmTask convertTask(DefaultBpmTask task, String parentTaskId, TaskType taskType, IUser user) {
        DefaultBpmTask cloneTask = (DefaultBpmTask)task.clone();
        cloneTask.setId(UniqueIdUtil.getSuid());
        cloneTask.setParentId(parentTaskId);
        cloneTask.setTaskId("");
        cloneTask.setStatus(taskType.name());
        cloneTask.setAssigneeId(user.getUserId());
        cloneTask.setAssigneeName(user.getFullname());
        cloneTask.setOwnerId(user.getUserId());
        cloneTask.setOwnerName(user.getFullname());
        cloneTask.setCreateTime(LocalDateTime.now());
        return cloneTask;
    }

    public static BpmDefExtProperties getExtProperties(String bpmnDefId) throws Exception {
        BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionService.getBpmProcessDef(bpmnDefId);
        BpmProcessDefExt procExt = procDef.getProcessDefExt();
        BpmDefExtProperties extProperties = procExt.getExtProperties();
        return extProperties;
    }

    private static Object[] getDefProperties(BpmProcessInstance instance, String nodeId) throws Exception {
        BpmProcessInstanceManager instanceManager;
        BpmProcessInstance parentInstance;
        Object[] aryObj = new Object[3];
        String defId = instance.getProcDefId();
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmDefinitionManager bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
        DefaultBpmDefinition bpmDefinition = bpmDefinitionManager.getById(defId);
        BpmNodeDef nodeDef = null;
        BpmProcessDef processDef = null;
        UserTaskNodeDef taskNodeDef = null;
        NodeProperties properties = null;
        String parentId = instance.getParentInstId();
        if (StringUtil.isNotZeroEmpty((String)parentId) && BeanUtils.isNotEmpty((Object)(nodeDef = bpmDefinitionAccessor.getBpmNodeDef((parentInstance = (BpmProcessInstance)(instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class)).get((Serializable)((Object)parentId))).getProcDefId(), nodeId)))) {
            taskNodeDef = (UserTaskNodeDef)nodeDef;
            properties = taskNodeDef.getLocalProperties();
            processDef = nodeDef.getRootProcessDef();
        }
        if (BeanUtils.isEmpty(nodeDef)) {
            nodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            taskNodeDef = (UserTaskNodeDef)nodeDef;
            properties = taskNodeDef.getLocalProperties();
            processDef = nodeDef.getRootProcessDef();
        }
        aryObj[0] = properties;
        aryObj[1] = processDef;
        aryObj[2] = bpmDefinition;
        return aryObj;
    }

    public static boolean isAllowEmptyIdentity(BpmProcessInstance instance, String nodeId) throws Exception {
        boolean isAllowEmpty = false;
        Object[] aryObj = BpmUtil.getDefProperties(instance, nodeId);
        NodeProperties properties = (NodeProperties)aryObj[0];
        BpmProcessDef procDef = (BpmProcessDef)aryObj[1];
        if (properties != null) {
            isAllowEmpty = properties.isAllowExecutorEmpty();
        }
        if (!isAllowEmpty) {
            Object procExt = procDef.getProcessDefExt();
            BpmDefExtProperties extProperties = procExt.getExtProperties();
            isAllowEmpty = extProperties.isAllowExecutorEmpty();
        }
        return isAllowEmpty;
    }

    public static boolean getSkipFirstNode(String defId) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmProcessDefExt procExt = procDef.getProcessDefExt();
        BpmDefExtProperties extProperties = procExt.getExtProperties();
        return extProperties.isSkipFirstNode();
    }

    public static BpmProcessDef<BpmProcessDefExt> getProcessDef(String bpmnDefId) throws Exception {
        BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionService.getBpmProcessDef(bpmnDefId);
        return procDef;
    }

    public static BpmProcessDef<BpmProcessDefExt> getProcessDefByDefId(String defId) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionAccessor.getBpmProcessDef(defId);
        return procDef;
    }

    public static boolean IsAllowTransTo(BpmNodeDef bpmNodeDef) {
        boolean isAllowTransTo = true;
        if (bpmNodeDef.getBpmProcessDef().getProcessDefExt() == null) {
            bpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
        }
        try {
            isAllowTransTo = bpmNodeDef.getBpmProcessDef().getProcessDefExt().getExtProperties().isAllowTransTo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isAllowTransTo;
    }

    public static String getUseMainForm(BpmNodeDef bpmNodeDef) {
        String useMainForm = "";
        if (bpmNodeDef.getBpmProcessDef().getProcessDefExt() == null) {
            bpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
        }
        try {
            useMainForm = bpmNodeDef.getBpmProcessDef().getProcessDefExt().getExtProperties().getUseMainForm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return useMainForm;
    }

    public static void finishTask(BpmTask bpmTask) throws Exception {
        String taskId = bpmTask.getId();
        SkipResult result = bpmTask.getSkipResult();
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        String destination = actionCmd.getDestination();
        Map<String, List<BpmIdentity>> identityMap = actionCmd.getBpmIdentities();
        BpmTaskActionService bpmTaskActionService = (BpmTaskActionService)AppUtil.getBean(BpmTaskActionService.class);
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.addTransitVars("bo_inst_", boMap);
        if (!result.isSkipTask()) {
            cmd.setDestination(destination);
        } else {
            cmd.setDestination("");
        }
        cmd.setTaskId(taskId);
        cmd.addTransitVars("bpmTask_", bpmTask);
        cmd.setBpmIdentities(identityMap);
        cmd.setBusData(actionCmd.getBusData());
        cmd.setDataMode(actionCmd.getDataMode());
        cmd.setActionName(TaskActionType.AGREE.getKey());
        String skipType = result.getSkipType();
        cmd.addTransitVars("skipType_", skipType);
        bpmTaskActionService.finishTask(cmd);
    }

    public static String getNotifyType(BpmProcessInstance instance, String nodeId) throws Exception {
        Object[] aryObj = BpmUtil.getDefProperties(instance, nodeId);
        NodeProperties properties = (NodeProperties)aryObj[0];
        BpmProcessDef procDef = (BpmProcessDef)aryObj[1];
        Object ext = procDef.getProcessDefExt();
        BpmDefExtProperties prop = ext.getExtProperties();
        String notifyType = "";
        if (properties != null) {
            notifyType = properties.getNotifyType();
        }
        if (StringUtil.isNotEmpty((String)notifyType)) {
            return notifyType;
        }
        notifyType = prop.getNotifyType();
        return notifyType;
    }

    public static void publishNoExecutorEvent(NoExecutorModel model) {
        NoExecutorEvent ev = new NoExecutorEvent(model);
        AppUtil.publishEvent((ApplicationEvent)ev);
    }

    public static void setTaskSkip(BpmTask bpmTask) throws Exception {
        block8: {
            String[] aryRules;
            BpmDefExtProperties extProperties;
            BpmProcessDef<BpmProcessDefExt> procDef;
            ActionCmd cmd;
            SkipResult skipResult;
            block7: {
                if (bpmTask.getSkipResult().isHasGetSkip()) {
                    return;
                }
                skipResult = new SkipResult();
                bpmTask.setSkipResult(skipResult);
                cmd = ContextThreadUtil.getActionCmd();
                procDef = BpmUtil.getProcessDefByDefId(bpmTask.getProcDefId());
                extProperties = procDef.getProcessDefExt().getExtProperties();
                if (!(cmd instanceof ProcessInstCmd)) break block7;
                boolean skipFirstNode = extProperties.isSkipFirstNode();
                BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
                List<BpmNodeDef> startNodes = bpmDefinitionAccessor.getStartNodes(bpmTask.getProcDefId());
                if (!skipFirstNode || !bpmTask.getNodeId().equals(startNodes.get(0).getNodeId())) break block8;
                skipResult.setSkipTask(true);
                skipResult.setSkipType(SkipResult.SKIP_FIRST);
                break block8;
            }
            String skipRules = extProperties.getSkipRules();
            try {
                BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
                Object[] aryObj = BpmUtil.getDefProperties(instance, bpmTask.getNodeId());
                NodeProperties properties = (NodeProperties)aryObj[0];
                if (properties.isSkipExecutorEmpty()) {
                    skipRules = StringUtil.isEmpty((String)skipRules) ? SkipResult.SKIP_EMPTY_USER : SkipResult.SKIP_EMPTY_USER + "," + skipRules;
                }
            }
            catch (Exception instance) {
                // empty catch block
            }
            if (StringUtil.isEmpty((String)skipRules)) {
                return;
            }
            for (String rule : aryRules = skipRules.split(",")) {
                ISkipCondition condition = SkipConditionUtil.getSkipConditionByType(rule);
                if (!Objects.isNull(condition) && !condition.canSkip(bpmTask)) continue;
                if (!BpmUtil.isBackoff(cmd).booleanValue() && procDef.getBpmnNodeDefs().size() > 0) {
                    BpmUtil.handlerOpininAndSignatureField(procDef, bpmTask, cmd);
                }
                skipResult.setSkipTask(true);
                if (Objects.isNull(condition)) break;
                skipResult.setSkipType(condition.getType());
                break;
            }
        }
    }

    public static Boolean isBackoff(ActionCmd cmd) {
        if (BeanUtils.isNotEmpty((Object)cmd)) {
            String actionName = cmd.getActionName();
            return ActionType.REJECT.getKey().equals(actionName) || ActionType.BACK.getKey().equals(actionName) || ActionType.BACK_TO_START.getKey().equals(actionName) || ActionType.RECOVER.getKey().equals(actionName) || ActionType.RECOVER_TO_START.getKey().equals(actionName);
        }
        return false;
    }

    private static void handlerOpininAndSignatureField(BpmProcessDef<BpmProcessDefExt> procDef, BpmTask bpmTask, ActionCmd cmd) throws Exception {
        for (int i = 0; i < procDef.getBpmnNodeDefs().size(); ++i) {
            if (!procDef.getBpmnNodeDefs().get(i).getNodeId().equals(bpmTask.getNodeId()) || procDef.getBpmnNodeDefs().get(i).getNodeProperties().size() < 1) continue;
            for (int k = 0; k < procDef.getBpmnNodeDefs().get(i).getNodeProperties().size(); ++k) {
                NodeProperties nodeProperties = procDef.getBpmnNodeDefs().get(i).getNodeProperties().get(k);
                JsonNode jsonNode = JsonUtil.toJsonNode((String)cmd.getBusData());
                if (!jsonNode.isObject()) continue;
                Boolean flag = false;
                if (BeanUtils.isNotEmpty((Object)nodeProperties.getOpinionField())) {
                    String msg;
                    flag = true;
                    String opinionField = nodeProperties.getOpinionField();
                    ObjectNode boDataZhu = (ObjectNode)jsonNode.get(opinionField.split("\\.")[0]);
                    if (nodeProperties.isAppendOpinion()) {
                        msg = "\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09 " + bpmTask.getOwnerName() + " " + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss") + "";
                        boDataZhu.put(opinionField.split("\\.")[1], msg);
                    } else if (BeanUtils.isNotEmpty((Object)boDataZhu.get(opinionField.split("\\.")[1]))) {
                        msg = boDataZhu.get(opinionField.split("\\.")[1]).asText();
                        msg = msg + "\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09 " + bpmTask.getOwnerName() + " " + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss") + "";
                        boDataZhu.put(opinionField.split("\\.")[1], msg);
                    } else {
                        boDataZhu.put(opinionField.split("\\.")[1], "\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09 " + bpmTask.getOwnerName() + " " + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                }
                if (nodeProperties.isSecretFree() && BeanUtils.isNotEmpty((Object)nodeProperties.getSignatureField())) {
                    ObjectNode seal;
                    flag = true;
                    String signatureField = nodeProperties.getSignatureField();
                    ObjectNode boDataSeal = (ObjectNode)jsonNode.get(signatureField.split("\\.")[0]);
                    UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
                    List<BpmIdentity> identitys = bpmTask.getIdentityList();
                    String userId = bpmTask.getAssigneeId();
                    if ((StringUtil.isEmpty((String)userId) || "0".equals(userId)) && BeanUtils.isNotEmpty(bpmTask.getIdentityList())) {
                        userId = identitys.get(0).getId();
                    }
                    if (BeanUtils.isNotEmpty((Object)(seal = (ObjectNode)ucFeignService.getSealByUserId(userId)))) {
                        ObjectNode objectNode = JsonUtil.createObjectNode();
                        String fileId = seal.get("fileId").asText();
                        if (nodeProperties.isSignatureCover()) {
                            ArrayList<ObjectNode> arrayList = new ArrayList<ObjectNode>();
                            objectNode.put("index", 1);
                            objectNode.put("userId", bpmTask.getAssigneeId());
                            objectNode.put("name", bpmTask.getAssigneeName());
                            objectNode.put("signature", fileId);
                            objectNode.put("createTime", DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                            arrayList.add(objectNode);
                            String signatureStringList = JsonUtil.toJsonString(arrayList);
                            boDataSeal.put(signatureField.split("\\.")[1], signatureStringList);
                        } else {
                            String signatureStringList;
                            String signatureFieldVal = JsonUtil.getString((JsonNode)boDataSeal, (String)signatureField.split("\\.")[1], (String)"");
                            if (StringUtil.isNotEmpty((String)signatureFieldVal)) {
                                List signatureList = (List)JsonUtil.toBean((String)signatureFieldVal, (TypeReference)new TypeReference<List<ObjectNode>>(){});
                                objectNode.put("index", signatureList.size() + 1);
                                objectNode.put("userId", bpmTask.getAssigneeId());
                                objectNode.put("name", bpmTask.getAssigneeName());
                                objectNode.put("signature", fileId);
                                objectNode.put("createTime", DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                                signatureList.add(objectNode);
                                signatureStringList = JsonUtil.toJsonString((Object)signatureList);
                                boDataSeal.put(signatureField.split("\\.")[1], signatureStringList);
                            } else {
                                ArrayList<ObjectNode> arrayList = new ArrayList<ObjectNode>();
                                objectNode.put("index", 1);
                                objectNode.put("userId", bpmTask.getAssigneeId());
                                objectNode.put("name", bpmTask.getAssigneeName());
                                objectNode.put("signature", fileId);
                                objectNode.put("createTime", DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                                arrayList.add(objectNode);
                                signatureStringList = JsonUtil.toJsonString(arrayList);
                                boDataSeal.put(signatureField.split("\\.")[1], signatureStringList);
                            }
                        }
                        cmd.setBusData(boDataSeal.asText());
                    }
                }
                if (!flag.booleanValue()) continue;
                BusDataUtil.updateBoData(bpmTask.getProcInstId(), bpmTask.getNodeId(), JsonUtil.toJson((Object)jsonNode));
                DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
                defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
                defaultBpmCheckOpinion.setProcDefId(bpmTask.getProcDefId());
                defaultBpmCheckOpinion.setProcInstId(bpmTask.getProcInstId());
                defaultBpmCheckOpinion.setTaskId(bpmTask.getTaskId());
                defaultBpmCheckOpinion.setTaskKey(bpmTask.getNodeId());
                defaultBpmCheckOpinion.setTaskName(bpmTask.getName());
                defaultBpmCheckOpinion.setStatus(OpinionStatus.AGREE.getKey());
                defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setOpinion("\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09");
                defaultBpmCheckOpinion.setQualfiedNames(bpmTask.getOwnerName());
                defaultBpmCheckOpinion.setAuditorName(bpmTask.getOwnerName());
                defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setDurMs(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime()));
                defaultBpmCheckOpinion.setAuditor(bpmTask.getAssigneeId());
                defaultBpmCheckOpinion.setFiles("");
                defaultBpmCheckOpinion.setIsRead(1);
                BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
                bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
            }
        }
    }

    public static IUser getUser(String userId, String userName) {
        IUser user = new IUser(){
            private static final long serialVersionUID = -3279144470311301256L;
            String userId = "";
            String fullName = "";

            public String getIdentityType() {
                return null;
            }

            public void setUserId(String userId) {
                this.userId = userId;
            }

            public void setFullname(String fullName) {
                this.fullName = fullName;
            }

            public void setAccount(String account) {
            }

            public String getUserId() {
                return this.userId;
            }

            public String getPassword() {
                return null;
            }

            public String getMobile() {
                return null;
            }

            public String getFullname() {
                return this.fullName;
            }

            public String getEmail() {
                return null;
            }

            public String getAccount() {
                return null;
            }

            public void setAttributes(Map<String, String> map) {
            }

            public Map<String, String> getAttributes() {
                return null;
            }

            public boolean isAdmin() {
                return false;
            }

            public String getAttrbuite(String key) {
                return "";
            }

            public boolean isEnable() {
                return true;
            }

            public Collection<GrantedAuthority> getAuthorities() {
                return null;
            }

            public String getUsername() {
                return null;
            }

            public boolean isAccountNonExpired() {
                return false;
            }

            public boolean isAccountNonLocked() {
                return false;
            }

            public boolean isCredentialsNonExpired() {
                return false;
            }

            public boolean isEnabled() {
                return false;
            }

            public Integer getStatus() {
                return 1;
            }

            public String getPhoto() {
                return null;
            }

            public String getWeixin() {
                return null;
            }

            public Integer getHasSyncToWx() {
                return null;
            }

            public String getTenantId() {
                return null;
            }

            public LocalDateTime getPwdCreateTime() {
                return null;
            }

            public LocalDate getExpireDate() {
                return null;
            }

            public String getClientId() {
                return null;
            }

            public String getClientToken() {
                return null;
            }

            public LocalDate getEntryDate() {
                return null;
            }
        };
        user.setUserId(userId);
        user.setFullname(userName);
        return user;
    }

    public static IUser getUser(String userId) {
        IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userService.getUserById(userId);
        return user;
    }

    public static BpmBusLink buildBusLink(BpmProcessInstance instance, ObjectNode result, String saveMode) {
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        instance = instanceManager.getTopBpmProcessInstance(instance);
        BpmBusLink busLink = BpmUtil.buildBusLink(instance);
        busLink.setSaveMode(saveMode);
        busLink.setIsMain(result.get("parentId").asText().equals("0") ? 1 : 0);
        busLink.setBoDefCode(result.get("boCode").asText());
        busLink.setFormIdentify(result.get("boEnt").get("name").asText());
        if ("number".equals(result.get("boEnt").get("isPkNumber").asText())) {
            busLink.setBusinesskey(new Long(result.get("pk").asText()));
        } else {
            busLink.setBusinesskeyStr(result.get("pk").asText());
        }
        if (StringUtil.isNotEmpty((String)instance.getSysCode())) {
            busLink.setSysCode(instance.getSysCode());
        }
        return busLink;
    }

    public static BpmBusLink buildBusLink(BpmProcessInstance instance) {
        BpmBusLink busLink = new BpmBusLink();
        busLink.setId(UniqueIdUtil.getSuid());
        busLink.setDefId(instance.getProcDefId());
        busLink.setProcInstId(instance.getId());
        IUser curUser = ContextUtil.getCurrentUser();
        busLink.setStartId(curUser.getUserId());
        busLink.setStartor(curUser.getFullname());
        busLink.setCreateDate(LocalDateTime.now());
        if (StringUtil.isNotEmpty((String)instance.getSysCode())) {
            busLink.setSysCode(instance.getSysCode());
        }
        return busLink;
    }

    public static List<Object> getFlowElementExtension(FlowElement flowElement, QName qname) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        ExtensionElements extensionElements = flowElement.getExtensionElements();
        if (extensionElements == null) {
            return extensions;
        }
        List<Object> objects = extensionElements.getAny();
        for (Object obj : objects) {
            Element el;
            QName qn;
            if (!(obj instanceof Element) || !qname.equals(qn = new QName((el = (Element)obj).getNamespaceURI(), el.getLocalName()))) continue;
            extensions.add(el.getNodeValue());
        }
        return extensions;
    }

    public static Integer getFlowElementOrder(FlowElement flowElement) {
        String s;
        Integer nodeOrder = 0;
        List<Object> extensions = BpmUtil.getFlowElementExtension(flowElement, BPMN20ExtConst._ORDER_QNAME);
        if (BeanUtils.isNotEmpty(extensions) && StringUtil.isNotEmpty((String)(s = (String)extensions.get(0))) && !"null".equals(s)) {
            nodeOrder = Integer.parseInt(s);
        }
        return nodeOrder;
    }

    public static List<Button> getButtons(BpmNodeDef bpmNodeDef) throws Exception {
        return BpmUtil.getButtons(bpmNodeDef, null);
    }

    public static List<Button> getButtons(BpmNodeDef bpmNodeDef, DefaultBpmTask task) throws Exception {
        List<Button> buttons = bpmNodeDef.getButtons();
        if (task == null) {
            return buttons;
        }
        ArrayList<Button> buttons2remove = new ArrayList<Button>();
        Map<String, Button> buttonMap = BpmUtil.convertToMap(buttons);
        String status = task.getStatus();
        BpmDefExtProperties prop = bpmNodeDef.getBpmProcessDef().getProcessDefExt() == null ? bpmNodeDef.getBpmProcessDef().getParentProcessDef().getProcessDefExt().getExtProperties() : bpmNodeDef.getBpmProcessDef().getProcessDefExt().getExtProperties();
        boolean isAllowTransTo = prop.isAllowTransTo();
        buttons = BpmUtil.getCommonButtons(buttons, status);
        BpmUtil.handDelegateButton(buttonMap, buttons2remove, isAllowTransTo);
        BpmUtil.handSignButtons(task.getTaskId(), bpmNodeDef, buttons, buttons2remove);
        BpmUtil.handLockButton(task, buttons, buttons2remove);
        BpmUtil.handTaskDelay(task.getTaskId(), bpmNodeDef, prop, buttonMap, buttons2remove);
        buttons.removeAll(buttons2remove);
        return buttons;
    }

    private static void handTaskDelay(String taskId, BpmNodeDef bpmNodeDef, BpmDefExtProperties prop, Map<String, Button> buttonMap, List<Button> buttons2remove) throws Exception {
        if (!buttonMap.containsKey("taskDelay")) {
            return;
        }
        BpmTaskDueTimeManager bpmTaskDueTimeManager = (BpmTaskDueTimeManager)AppUtil.getBean(BpmTaskDueTimeManager.class);
        PortalFeignService PortalFeignService2 = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        BpmTaskDueTime bpmTaskDueTime = bpmTaskDueTimeManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)((Object)bpmTaskDueTime)) && buttonMap.containsKey("taskDelay")) {
            buttons2remove.add(buttonMap.get("taskDelay"));
            return;
        }
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(PortalFeignService2.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0 && buttonMap.containsKey("taskDelay")) {
            buttons2remove.add(buttonMap.get("taskDelay"));
        }
    }

    private static void handDelegateButton(Map<String, Button> buttonMap, List<Button> buttons2remove, boolean isAllowTransTo) {
        boolean rtn = buttonMap.containsKey("delegate");
        if (!isAllowTransTo && rtn) {
            buttons2remove.add(buttonMap.get("delegate"));
        }
    }

    private static List<Button> getCommonButtons(List<Button> buttonsDef, String status) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        TaskActionHandlerConfig config = (TaskActionHandlerConfig)AppUtil.getBean((String)"taskActionHandlerConfig");
        if (BeanUtils.isEmpty((Object)config)) {
            return buttons;
        }
        List<? extends TaskActionHandlerDef> listDef = config.getAllActionHandlerDefList();
        ArrayList<String> allActions = new ArrayList<String>();
        for (TaskActionHandlerDef taskActionHandlerDef : listDef) {
            allActions.add(taskActionHandlerDef.getName());
        }
        Map defButtonsMap = (Map)AppUtil.getBean((String)"buttonsMap");
        String string = (String)defButtonsMap.get(status);
        String[] aryDefault = null;
        if (string != null) {
            aryDefault = string.split(",");
        }
        for (Button btn : buttonsDef) {
            if (allActions.contains(btn.getAlias()) && !BpmUtil.isInDefault(btn.getAlias(), aryDefault)) continue;
            buttons.add(btn);
        }
        return buttons;
    }

    private static boolean isInDefault(String alias, String[] aryDefault) {
        for (String tmp : aryDefault) {
            if (!tmp.equals(alias)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Button> convertToMap(List<Button> buttons) {
        HashMap<String, Button> btnMap = new HashMap<String, Button>();
        for (Button btn : buttons) {
            btnMap.put(btn.getAlias(), btn);
        }
        return btnMap;
    }

    private static void handSignButtons(String taskId, BpmNodeDef bpmNodeDef, List<Button> buttons, List<Button> buttons2remove) throws Exception {
        if (!bpmNodeDef.getType().equals((Object)NodeType.SIGNTASK) || StringUtil.isEmpty((String)taskId)) {
            return;
        }
        NatTaskService natTaskService = (NatTaskService)AppUtil.getBean(NatTaskService.class);
        SignService signService = (SignService)AppUtil.getBean(SignService.class);
        Map<String, Object> variables = natTaskService.getVariables(taskId);
        List<PrivilegeMode> privilege = signService.getPrivilege(ContextUtil.getCurrentUserId(), (SignNodeDef)bpmNodeDef, variables);
        if (!privilege.contains((Object)PrivilegeMode.ALL) && !privilege.contains((Object)PrivilegeMode.ALLOW_ADD_SIGN)) {
            for (Button bnt : buttons) {
                if (!"addSign".equals(bnt.getAlias())) continue;
                buttons2remove.add(bnt);
                break;
            }
        }
    }

    private static void handLockButton(DefaultBpmTask task, List<Button> buttons, List<Button> buttons2remove) {
        if (task == null) {
            return;
        }
        String taskId = task.getTaskId();
        BpmTaskManager taskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        int canLock = taskManager.canLockTask(taskId);
        Button button = null;
        for (Button btn : buttons) {
            if (!btn.getAlias().equals("lockUnlock")) continue;
            button = btn;
        }
        if (button == null) {
            return;
        }
        if (canLock == 0 || canLock == 4 || canLock == 5 || canLock == 2) {
            buttons2remove.add(button);
        }
        if (canLock == 1) {
            button.setName("\u9501\u5b9a");
        }
        if (canLock == 3) {
            button.setName("\u89e3\u9501");
        }
    }

    public static NodeProperties getNodeProperties(BpmProcessInstance instance, String nodeId) throws Exception {
        Object[] defProperties = BpmUtil.getDefProperties(instance, nodeId);
        Object obj = defProperties[0];
        if (BeanUtils.isNotEmpty((Object)obj) && obj instanceof NodeProperties) {
            return (NodeProperties)obj;
        }
        return null;
    }

    public static void handOpinion(String data, DefaultTaskFinishCmd cmd) throws IOException {
        if (StringUtil.isEmpty((String)data)) {
            return;
        }
        ObjectNode dataJson = (ObjectNode)JsonUtil.toJsonNode((String)data);
        if (dataJson.findValue("__form_opinion") == null) {
            return;
        }
        ObjectNode opinionJson = (ObjectNode)dataJson.get("__form_opinion");
        Iterator field = opinionJson.fields();
        while (field.hasNext()) {
            Map.Entry ent = (Map.Entry)field.next();
            String opinion = (String)ent.getKey();
            if (!StringUtil.isNotEmpty((String)opinion)) continue;
            cmd.setOpinionIdentity(opinion);
            cmd.setApprovalOpinion(((JsonNode)ent.getValue()).asText());
            break;
        }
        dataJson.remove("__form_opinion");
        data = dataJson.toString();
        cmd.setBusData(data);
    }

    public static int isHandlerValidNoCmd(String handler, Class<?>[] parameterTypes) {
        if (handler.indexOf(".") == -1) {
            return -1;
        }
        String[] aryHandler = handler.split("[.]");
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = null;
        try {
            serviceBean = AppUtil.getBean((String)beanId);
        }
        catch (Exception ex) {
            return -2;
        }
        if (serviceBean == null) {
            return -2;
        }
        try {
            Method invokeMethod = serviceBean.getClass().getMethod(method, parameterTypes);
            if (invokeMethod != null) {
                return 0;
            }
            return -3;
        }
        catch (NoSuchMethodException e) {
            return -3;
        }
        catch (Exception e) {
            return -4;
        }
    }

    public static void restfulPluginExecut(DefaultBpmTask task, EventType eventType) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(DefaultBpmDefinitionAccessor.class);
        BpmPluginFactory bpmPluginFactory = (BpmPluginFactory)AppUtil.getBean(DefaultBpmPluginFactory.class);
        RestfulService restfulService = (RestfulService)AppUtil.getBean(RestfulService.class);
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = bpmDefinitionAccessor.getBpmProcessDef(task.getProcDefId());
        List<BpmPluginContext> pluginContextList = bpmProcessDef.getProcessDefExt().getBpmPluginContexts();
        if (BeanUtils.isNotEmpty(pluginContextList)) {
            for (BpmPluginContext bpmPluginContext : pluginContextList) {
                IGlobalRestfulPluginDef restfulPluginDef;
                List<Restful> restfuls;
                BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
                if (!(bpmPluginDef instanceof BpmExecutionPluginDef)) continue;
                BpmExecutionPluginDef bpmExecutionPluginDef = (BpmExecutionPluginDef)bpmPluginDef;
                BpmExecutionPlugin bpmExecutionPlugin = bpmPluginFactory.buildExecutionPlugin(bpmPluginContext, eventType);
                if (bpmExecutionPlugin == null || !bpmPluginContext.getEventTypes().contains((Object)eventType) || !(bpmExecutionPluginDef instanceof IGlobalRestfulPluginDef) || !BeanUtils.isNotEmpty(restfuls = (restfulPluginDef = (IGlobalRestfulPluginDef)((Object)bpmExecutionPluginDef)).getRestfulList())) continue;
                restfulService.outTaskPluginExecute(task, restfuls, eventType);
            }
        }
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(task.getProcDefId(), task.getNodeId());
        for (BpmPluginContext bpmPluginContext : bpmNodeDef.getBpmPluginContexts()) {
            IGlobalRestfulPluginDef restfulPluginDef;
            List<Restful> restfuls;
            BpmPluginDef bpmPluginDef;
            if (BeanUtils.isEmpty(bpmPluginContext.getEventTypes()) || !((bpmPluginDef = bpmPluginContext.getBpmPluginDef()) instanceof BpmTaskPluginDef)) continue;
            BpmTaskPluginDef bpmTaskPluginDef = (BpmTaskPluginDef)bpmPluginDef;
            BpmTaskPlugin bpmTaskPlugin = bpmPluginFactory.buildTaskPlugin(bpmPluginContext, eventType);
            if (bpmTaskPlugin == null || !bpmPluginContext.getEventTypes().contains((Object)eventType) || !(bpmTaskPluginDef instanceof IGlobalRestfulPluginDef) || !BeanUtils.isNotEmpty(restfuls = (restfulPluginDef = (IGlobalRestfulPluginDef)((Object)bpmTaskPluginDef)).getRestfulList())) continue;
            restfulService.outTaskPluginExecute(task, restfuls, eventType);
        }
    }

    public static String getRejectPreDestination(String taskId) throws Exception {
        boolean canRejectPreAct = true;
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean((String)"bpmTaskManager");
        DefaultBpmTask task = (DefaultBpmTask)bpmTaskManager.get((Serializable)((Object)taskId));
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        boolean canReject = false;
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmNodeDef taskNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<Button> buttons = BpmUtil.getButtons(taskNodeDef, task);
        for (Button button : buttons) {
            if (!"reject".equals(button.getAlias())) continue;
            canReject = true;
        }
        if (!canReject) {
            return "";
        }
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        String backMode = nodeProperties.getBackMode();
        if (StringUtil.isEmpty((String)backMode)) {
            backMode = "normal";
        }
        String procInstId = task.getProcInstId();
        List<BpmNodeDef> listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef(procInstId, task.getNodeId(), "pre");
        ArrayList<BpmNodeDef> bpmExeStacksUserNode = new ArrayList<BpmNodeDef>();
        ArrayList<BpmNodeDef> bpmExeStacksGoMapUserNode = new ArrayList<BpmNodeDef>();
        BpmExeStackRelationDao relationDao = (BpmExeStackRelationDao)AppUtil.getBean((String)"bpmExeStackRelationDaoImpl");
        List<BpmExeStackRelation> relationList = relationDao.getListByProcInstId(procInstId);
        for (BpmNodeDef node : listBpmNodeDef) {
            if (!node.getType().equals((Object)NodeType.USERTASK) && !node.getType().equals((Object)NodeType.SIGNTASK) || node.getNodeId().equals(nodeId)) continue;
            bpmExeStacksUserNode.add(node);
            boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway(procInstId, node.getNodeId(), "pre", relationList);
            boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway(procInstId, node.getNodeId(), "after", relationList);
            if (!isHavePre || !isHaveAfter) {
                bpmExeStacksGoMapUserNode.add(node);
                continue;
            }
            List<BpmNodeDef> incomeNodes = node.getIncomeNodes();
            if (!BeanUtils.isNotEmpty(incomeNodes)) continue;
            BpmNodeDef nodeDef = incomeNodes.get(0);
            if (!node.getType().equals((Object)NodeType.USERTASK) || !nodeDef.getType().equals((Object)NodeType.START) && !nodeDef.getType().equals((Object)NodeType.USERTASK)) continue;
            bpmExeStacksGoMapUserNode.add(node);
        }
        boolean bl = canRejectPreAct = bpmExeStacksGoMapUserNode.size() > 0 || bpmExeStacksUserNode.size() > 0;
        if (!canRejectPreAct) {
            return "";
        }
        if ("direct".equals(backMode)) {
            return ((BpmNodeDef)bpmExeStacksUserNode.get(0)).getNodeId();
        }
        return ((BpmNodeDef)bpmExeStacksGoMapUserNode.get(0)).getNodeId();
    }

    public static void autoTrans(BpmNodeDef bpmNodeDef, String instId, String taskId) {
        try {
            for (BpmPluginContext bpmPluginContext : bpmNodeDef.getBpmPluginContexts()) {
                if (!"\u4f20\u9605\u7528\u6237\u5206\u914d\u63d2\u4ef6".equals(bpmPluginContext.getTitle())) continue;
                BpmPluginSessionFactory bpmPluginSessionFactory = (BpmPluginSessionFactory)AppUtil.getBean(BpmPluginSessionFactory.class);
                BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
                UserAssignPluginDef userAssignPluginDef = (UserAssignPluginDef)bpmPluginContext.getBpmPluginDef();
                UserQueryPlugin userQueryPlugin = (UserQueryPlugin)AppUtil.getBean(UserQueryPlugin.class);
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                Map<String, Object> variables = cmd.getVariables();
                variables.putAll(cmd.getTransitVars());
                List<BpmIdentity> bpmIdentities = userQueryPlugin.execute(bpmPluginSessionFactory.buildBpmUserCalcPluginSession(variables), userAssignPluginDef);
                List<IUser> iUsers = bpmIdentityExtractService.extractUser(bpmIdentities);
                if (BeanUtils.isEmpty(iUsers)) {
                    return;
                }
                BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
                BpmProcessInstance instance = (BpmProcessInstance)instanceManager.get((Serializable)((Object)instId));
                String notifyType = BpmUtil.getNotifyType(instance, bpmNodeDef.getNodeId());
                ArrayList<String> copyUsers = new ArrayList<String>();
                String opinionId = UniqueIdUtil.getSuid();
                String curUserId = ContextUtil.getCurrentUserId();
                for (IUser entity : iUsers) {
                    if (curUserId.equals(entity.getUserId())) continue;
                    copyUsers.add(entity.getFullname());
                    BpmUtil.transToMore(instance, entity.getUserId(), notifyType, taskId, bpmNodeDef.getNodeId(), opinionId);
                }
                DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
                defaultBpmCheckOpinion.setId(opinionId);
                defaultBpmCheckOpinion.setProcDefId(instance.getBpmnDefId());
                defaultBpmCheckOpinion.setProcInstId(instance.getId());
                defaultBpmCheckOpinion.setTaskId(BeanUtils.isEmpty((Object)taskId) ? null : taskId);
                defaultBpmCheckOpinion.setTaskKey(null);
                defaultBpmCheckOpinion.setTaskName("\u4f20\u9605\u4efb\u52a1");
                defaultBpmCheckOpinion.setStatus(OpinionStatus.COPYTO.getKey());
                defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setOpinion("\u7cfb\u7edf\u81ea\u52a8\u4f20\u9605");
                defaultBpmCheckOpinion.setQualfiedNames(StringUtil.join(copyUsers, (String)","));
                defaultBpmCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
                defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setDurMs(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime()));
                defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
                defaultBpmCheckOpinion.setFiles("");
                defaultBpmCheckOpinion.setIsRead(1);
                if (StringUtil.isNotEmpty((String)cmd.getBusData())) {
                    defaultBpmCheckOpinion.setFormData(Base64.getBase64((String)cmd.getBusData()));
                }
                BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
                bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
            }
            BpmUtil.executeRestfulPlugin(EventType.COPY_TO_AUTO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException("\u7cfb\u7edf\u81ea\u52a8\u4f20\u9605\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void executeRestfulPlugin(String taskId, String instId, EventType eventType) throws Exception {
        block3: {
            String[] instIds;
            RestfulService restfulService;
            block2: {
                String[] taskIds;
                restfulService = (RestfulService)AppUtil.getBean(RestfulService.class);
                if (!StringUtil.isNotEmpty((String)taskId)) break block2;
                for (String id : taskIds = taskId.split(",")) {
                    restfulService.executePluginByTaskId(id, eventType);
                }
                break block3;
            }
            if (!StringUtil.isNotEmpty((String)instId)) break block3;
            for (String id : instIds = instId.split(",")) {
                restfulService.executePluginByInstId(id, eventType);
            }
        }
    }

    public static void executeRestfulPlugin(EventType eventType) throws Exception {
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        BpmTask task = (BpmTask)actionCmd.getTransitVars("bpmTask_");
        RestfulService restfulService = (RestfulService)AppUtil.getBean(RestfulService.class);
        restfulService.executePluginByTask(task, eventType);
    }

    public static void setBaseUrl(Map<String, Object> variables) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
        String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
        String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
        variables.put("baseUrl", baseUrl);
        variables.put("manageBaseUrl", manage);
        variables.put("frontBaseUrl", front);
        variables.put("mobileBaseUrl", mobile);
    }

    private static void transToMore(BpmProcessInstance instance, String userId, String messageType, String taskId, String nodeId, String opinionId) {
        IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserById(userId);
        IUser currentUser = userServiceImpl.getUserById(ContextUtil.getCurrentUserId());
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice taskNotice = new BpmTaskNotice("\u4f20\u9605\u4efb\u52a1", instance.getSubject(), instance.getId(), instance.getProcDefId(), instance.getProcDefKey(), instance.getProcDefName(), userId, user.getFullname(), TaskType.COPYTO.getKey(), ((DefaultBpmProcessInstance)instance).getSupportMobile(), BeanUtils.isNotEmpty((Object)currentUser) ? currentUser.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba", BeanUtils.isNotEmpty((Object)currentUser) ? currentUser.getUserId() : "-1", 0, BeanUtils.isEmpty((Object)taskId) ? null : taskId, null, null);
        taskNotice.setNodeId(nodeId);
        taskNotice.setOpinionId(opinionId);
        BpmUtil.bpmTaskNoticeNodeSetHelper(taskNotice, taskId, null);
        noticeManager.create((Model)taskNotice);
        try {
            NotifyHelper notifyHelper = (NotifyHelper)AppUtil.getBean(NotifyHelper.class);
            ArrayList<IUser> receiverUsers = new ArrayList<IUser>();
            receiverUsers.add(user);
            if (StringUtil.isEmpty((String)messageType)) {
                messageType = "inner";
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            if (actionCmd instanceof TaskFinishCmd) {
                variables.put("instId", actionCmd.getInstId());
                BpmTask task = (BpmTask)actionCmd.getTransitVars("bpmTask_");
                variables.put("taskId", task.getId());
                variables.put("taskSubject", task.getSubject());
                variables.put("nodeName", task.getName());
                variables.put("instSubject", task.getSubject());
                variables.put("date", instance.getCreateTime());
                variables.put("creator", instance.getCreator());
                variables.put("bpmName", instance.getProcDefName());
                if (currentUser != null) {
                    variables.put("sender", currentUser.getFullname());
                    variables.put("delegate", currentUser.getFullname());
                    variables.put("agent", currentUser.getFullname());
                }
                BpmUtil.setBaseUrl(variables);
                String cause = ((TaskFinishCmd)actionCmd).getApprovalOpinion();
                variables.put("cause", cause);
                variables.put("readId", taskNotice.getId());
            }
            notifyHelper.notify(receiverUsers, Arrays.asList(messageType.split(",")), "copyTo", variables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void bpmTaskNoticeNodeSetHelper(BpmTaskNotice taskNotice, String taskId, BpmTask bpmTask) {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)taskNotice)), (String)"BpmTaskNotice\u4e0d\u80fd\u4e3a\u7a7a");
        if (BeanUtils.isEmpty((Object)bpmTask) && StringUtil.isNotEmpty((String)taskId)) {
            taskNotice.setTaskId(taskId);
            BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
            try {
                bpmTask = bpmTaskManager.getByTaskId(taskId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (BeanUtils.isNotEmpty((Object)bpmTask)) {
            taskNotice.setName(bpmTask.getName());
            taskNotice.setNodeId(bpmTask.getNodeId());
        }
    }

    public static List<BpmIdentity> gethisOpinionQualfieds(BpmTask task, String preNodeId) throws Exception {
        DefaultBpmCheckOpinion curOpinion;
        BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        List<DefaultBpmCheckOpinion> opinions = bpmCheckOpinionManager.getByInstId(task.getProcInstId());
        DefaultBpmCheckOpinion desNodeOpinion = BpmUtil.getDesNodeOpinion(opinions, preNodeId, (curOpinion = opinions.stream().filter(o -> task.getTaskId().equals(o.getTaskId())).findFirst().get()).getParentTaskId());
        if (BeanUtils.isNotEmpty((Object)desNodeOpinion)) {
            List bean = (List)JsonUtil.toBean((String)desNodeOpinion.getQualfieds(), (TypeReference)new TypeReference<List<DefaultBpmIdentity>>(){});
            List<BpmIdentity> identityList = bean.stream().map(defaultBpmIdentity -> defaultBpmIdentity).collect(Collectors.toList());
            return identityList;
        }
        return null;
    }

    private static DefaultBpmCheckOpinion getDesNodeOpinion(List<DefaultBpmCheckOpinion> opinions, String desNodeId, String parentId) {
        for (DefaultBpmCheckOpinion opinion : opinions) {
            if (!StringUtil.isNotEmpty((String)opinion.getTaskId()) || !opinion.getTaskId().equals(parentId)) continue;
            if (desNodeId.equals(opinion.getTaskKey()) && OpinionStatus.AGREE.getKey().equals(opinion.getStatus())) {
                return opinion;
            }
            return BpmUtil.getDesNodeOpinion(opinions, desNodeId, opinion.getParentTaskId());
        }
        return null;
    }

    public static String getInnerSubStartNodeId(BpmNodeDef bpmNodeDef) {
        BpmNodeDef parentNodeDef = bpmNodeDef.getParentBpmNodeDef();
        if (BeanUtils.isEmpty((Object)parentNodeDef) || !(parentNodeDef instanceof SubProcessNodeDef)) {
            return null;
        }
        SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)parentNodeDef;
        List<BpmNodeDef> subNodes = subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs();
        String startNodeId = subNodes.stream().filter(node -> node.getType().getKey().equals(NodeType.START.getKey())).findFirst().get().getOutcomeNodes().get(0).getNodeId();
        return startNodeId;
    }
}

