/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.util;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.util.List;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.Assert;

public class ServiceUtil {
    public static IUser getUserById(String userId) throws Exception {
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException("\u5fc5\u987b\u4f20\u5165\u7528\u6237ID(userId)!");
        }
        IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserById(userId);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new Exception("\u8be5\u7528\u6237\u4e0d\u5b58\u5728,\u8bf7\u786e\u8ba4\u4f20\u5165\u7684userId\u662f\u5426\u5b58\u5728");
        }
        return user;
    }

    public static IUser getUserByAccount(String account) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)account), (String)"\u5fc5\u987b\u4f20\u5165\u7528\u6237\u8d26\u53f7");
        UserDetailsService userDetailsService = (UserDetailsService)AppUtil.getBean(UserDetailsService.class);
        IUser user = (IUser)userDetailsService.loadUserByUsername(account);
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)String.format("\u8d26\u53f7\u4e3a\uff1a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728", account));
        return user;
    }

    public static List<IUser> extractUser(List<BpmIdentity> bpmIdentities) throws Exception {
        if (BeanUtils.isEmpty(bpmIdentities)) {
            throw new RuntimeException("\u5fc5\u987b\u4f20\u5165\u6d41\u7a0b\u5904\u7406\u4eba(bpmIdentities)!");
        }
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        List<IUser> extractUser = bpmIdentityExtractService.extractUser(bpmIdentities);
        BeanUtils.removeDuplicate(extractUser);
        return extractUser;
    }

    public static void setCurrentUser(String account) throws Exception {
        ContextUtil.setCurrentUserByAccount((String)account);
    }
}

