/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.task.config;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.exception.NoTaskActionHandlerException;
import com.hotent.bpm.api.plugin.core.context.TaskActionHandlerContext;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.runtime.TaskActionHandler;
import com.hotent.bpm.api.plugin.core.task.TaskActionHandlerConfig;
import com.hotent.bpm.plugin.core.task.def.DefaultTaskActionHandlerDef;
import com.hotent.bpm.plugin.core.task.entity.TaskAction;
import com.hotent.bpm.plugin.core.task.entity.TaskActions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DefaultTaskActionHandlerConfig
implements TaskActionHandlerConfig {
    private String actionConfigXml = "/conf/taskActionPlugins.xml";
    private TaskActionHandlerContext taskActionHandleContext;
    private List<TaskActionHandlerDef> actionHandlerDefs = new ArrayList<TaskActionHandlerDef>();

    @Override
    public void init() {
        try {
            InputStream is = DefaultTaskActionHandlerConfig.class.getResourceAsStream(this.actionConfigXml);
            TaskActions taskActions = (TaskActions)JAXBUtil.unmarshall((InputStream)is, TaskActions.class);
            for (TaskAction taskAction : taskActions.getTaskAction()) {
                DefaultTaskActionHandlerDef def = this.actionToActionHandlerDef(taskAction);
                this.actionHandlerDefs.add(def);
                String taskName = def.getName();
                String handlerClass = def.getHandlerClass();
                this.taskActionHandleContext.getTaskActionHandlerDefs().put(taskName, def);
                if (StringUtil.isEmpty((String)handlerClass)) continue;
                this.taskActionHandleContext.getTaskActionHandlers().put(taskName, handlerClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DefaultTaskActionHandlerDef actionToActionHandlerDef(TaskAction taskAction) {
        DefaultTaskActionHandlerDef def = new DefaultTaskActionHandlerDef();
        def.setName(taskAction.getName());
        def.setDescription(taskAction.getDescription());
        def.setSupportType(taskAction.getSupportType().value());
        def.setHandlerClass(taskAction.getHandlerClass());
        def.setActionType(ActionType.fromKey(taskAction.getActionType().value()));
        def.setSupportScript(taskAction.isScript());
        def.setDefaultInit(taskAction.isInit());
        return def;
    }

    @Override
    public TaskActionHandler getTaskActionHandler(String actionName) {
        boolean rtn = this.taskActionHandleContext.getTaskActionHandlers().containsKey(actionName);
        if (!rtn) {
            throw new NoTaskActionHandlerException("No TaskActionHandler found by " + actionName);
        }
        String name = this.taskActionHandleContext.getTaskActionHandlers().get(actionName);
        return (TaskActionHandler)AppUtil.getBean((String)name);
    }

    @Override
    public TaskActionHandlerDef getTaskActionHandlerDef(String actionName) {
        boolean rtn = this.taskActionHandleContext.getTaskActionHandlerDefs().containsKey(actionName);
        if (!rtn) {
            return null;
        }
        return this.taskActionHandleContext.getTaskActionHandlerDefs().get(actionName);
    }

    public void setActionConfigXml(String actionConfigXml) {
        this.actionConfigXml = actionConfigXml;
    }

    public void setTaskActionHandleContext(TaskActionHandlerContext taskActionHandleContext) {
        this.taskActionHandleContext = taskActionHandleContext;
    }

    public List<TaskActionHandlerDef> getAllActionHandlerDefList() {
        return this.actionHandlerDefs;
    }
}

