/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.util;

import com.hotent.base.util.AppUtil;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.context.UserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmUserCalcPluginDef;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginContextUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PluginContextUtil.class);

    public static List<UserCalcPluginContext> getUserCalcPluginContexts(Element parentNode) {
        ArrayList<UserCalcPluginContext> list = new ArrayList<UserCalcPluginContext>();
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            String name = node.getNodeName();
            if (name == null || !(node instanceof Element)) continue;
            Element el = (Element)node;
            String pluginContextBeanId = name + "PluginContext";
            UserCalcPluginContext pluginContext = (UserCalcPluginContext)AppUtil.getBean((String)pluginContextBeanId);
            if (pluginContext == null) continue;
            BpmUserCalcPluginDef bpmPluginDef = (BpmUserCalcPluginDef)pluginContext.parse(el);
            AbstractUserCalcPluginContext calcPluginContext = (AbstractUserCalcPluginContext)pluginContext;
            calcPluginContext.setBpmPluginDef(bpmPluginDef);
            list.add(pluginContext);
        }
        return list;
    }

    public static List<EventType> getEventTypes(String eventTypeString) {
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        StringTokenizer st = new StringTokenizer(eventTypeString, ",");
        while (st.hasMoreTokens()) {
            String event = st.nextToken();
            EventType eventType = EventType.fromKey(event);
            if (eventType == null) continue;
            eventTypes.add(eventType);
        }
        return eventTypes;
    }
}

