/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.XmlUtil;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.hotent.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.context.PluginParse;
import com.hotent.bpm.api.plugin.core.context.UserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmUserCalcPluginDef;
import com.hotent.bpm.plugin.core.util.PluginContextUtil;
import com.hotent.bpm.plugin.usercalc.hrScript.def.HrScriptPluginDef;
import com.jamesmurty.utils.BaseXMLBuilder;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UserAssignRuleParser {
    public static UserAssignRule getUserAssignRule(ObjectNode jsonObj) throws Exception {
        UserAssignRule rule = new UserAssignRule();
        String condition = jsonObj.get("condition").asText();
        rule.setCondition(condition);
        String conditionMode = jsonObj.get("conditionMode").asText();
        rule.setConditionMode(conditionMode);
        String description = jsonObj.get("description").asText();
        rule.setDescription(description);
        int groupNo = JsonUtil.getInt((JsonNode)jsonObj, (String)"groupNo", (int)1);
        rule.setGroupNo(groupNo);
        ArrayNode calcAry = (ArrayNode)JsonUtil.toJsonNode((Object)jsonObj.get("calcs"));
        ArrayList<UserCalcPluginContext> calcPluginContextList = new ArrayList<UserCalcPluginContext>();
        for (Object obj : calcAry) {
            ObjectNode calcObj = (ObjectNode)obj;
            String pluginContext = String.format("%s%s", JsonUtil.getString((JsonNode)calcObj, (String)"pluginType"), "PluginContext");
            AbstractUserCalcPluginContext ctx = (AbstractUserCalcPluginContext)AppUtil.getBean((String)pluginContext);
            ctx.parse(JsonUtil.toJson((Object)calcObj));
            calcPluginContextList.add(ctx);
        }
        rule.setCalcPluginContextList(calcPluginContextList);
        return rule;
    }

    public static List<UserAssignRule> parse(Element el) {
        ArrayList<UserAssignRule> ruleList = new ArrayList<UserAssignRule>();
        if (el == null || el.getChildNodes().getLength() == 0) {
            return ruleList;
        }
        NodeList nodeList = el.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element ruleNode;
            String tagName;
            if (!(nodeList.item(i) instanceof Element) || StringUtil.isEmpty((String)(tagName = (ruleNode = (Element)nodeList.item(i)).getTagName())) || !"userRule".equals(tagName)) continue;
            UserAssignRule userRule = UserAssignRuleParser.getUserRule(ruleNode);
            ruleList.add(userRule);
        }
        return ruleList;
    }

    private static UserAssignRule getUserRule(Element ruleNode) {
        Element parentFlowKey;
        Element conditionModeNode;
        Element conditionNode;
        UserAssignRule userRule = new UserAssignRule();
        String name = ruleNode.getAttribute("name");
        userRule.setName(name);
        int groupNo = Integer.parseInt(ruleNode.getAttribute("groupNo"));
        userRule.setGroupNo(groupNo);
        Element descriptionNode = XmlUtil.getChildNodeByName((Element)ruleNode, (String)"description");
        if (descriptionNode != null) {
            userRule.setDescription(descriptionNode.getTextContent());
        }
        if ((conditionNode = XmlUtil.getChildNodeByName((Element)ruleNode, (String)"condition")) != null) {
            userRule.setCondition(conditionNode.getTextContent());
        }
        if ((conditionModeNode = XmlUtil.getChildNodeByName((Element)ruleNode, (String)"conditionMode")) != null) {
            userRule.setConditionMode(conditionModeNode.getTextContent());
        }
        if ((parentFlowKey = XmlUtil.getChildNodeByName((Element)ruleNode, (String)"parentFlowKey")) != null) {
            userRule.setParentFlowKey(parentFlowKey.getTextContent());
        }
        Element calcsNode = XmlUtil.getChildNodeByName((Element)ruleNode, (String)"calcs");
        List<UserCalcPluginContext> calcPluginContextList = PluginContextUtil.getUserCalcPluginContexts(calcsNode);
        userRule.setCalcPluginContextList(calcPluginContextList);
        return userRule;
    }

    public static void handJsonConfig(ArrayNode config, List<UserAssignRule> ruleList) throws IOException {
        if (BeanUtils.isEmpty(ruleList)) {
            return;
        }
        for (UserAssignRule rule : ruleList) {
            ObjectNode objRule = (ObjectNode)JsonUtil.toJsonNode((Object)rule);
            List<UserCalcPluginContext> list = rule.getCalcPluginContextList();
            ArrayNode caclsArr = JsonUtil.getMapper().createArrayNode();
            if (BeanUtils.isEmpty(list)) continue;
            for (UserCalcPluginContext ctx : list) {
                BpmUserCalcPluginDef bpmPluginDef = (BpmUserCalcPluginDef)ctx.getBpmPluginDef();
                if (bpmPluginDef instanceof HrScriptPluginDef) {
                    ((HrScriptPluginDef)bpmPluginDef).setParams(JsonUtil.clearJsonStrBackslash((String)((HrScriptPluginDef)bpmPluginDef).getParams()));
                }
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((Object)bpmPluginDef);
                obj.put("pluginType", ((PluginParse)((Object)ctx)).getType());
                obj.put("description", ctx.getDescription());
                obj.put("extract", bpmPluginDef.getExtract().getKey());
                obj.put("logicCal", bpmPluginDef.getLogicCal().getKey());
                caclsArr.add((JsonNode)obj);
            }
            objRule.set("calcs", (JsonNode)caclsArr);
            config.add((JsonNode)objRule);
        }
    }

    public static XMLBuilder getCalcXmlBuilder(UserCalcPluginContext userCalcPluginContext) {
        try {
            PluginParse calcPluginXmlBuilder = (PluginParse)((Object)userCalcPluginContext);
            String calcXml = calcPluginXmlBuilder.getPluginXml();
            StringReader sr = new StringReader(calcXml);
            InputSource is = new InputSource(sr);
            XMLBuilder calcXmlBuilder = XMLBuilder.parse((InputSource)is);
            return calcXmlBuilder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void handXmlBulider(XMLBuilder xmlBuilder, List<UserAssignRule> userRuleList) {
        for (UserAssignRule userAssignRule : userRuleList) {
            if (userAssignRule.getCalcPluginContextList().size() == 0) continue;
            xmlBuilder = xmlBuilder.e("userRule").a("xmlns", "http://www.jee-soft.cn/bpm/plugins/userCalc/base").a("groupNo", String.valueOf(userAssignRule.getGroupNo())).e("description").t(userAssignRule.getDescription()).up().e("condition").t(userAssignRule.getCondition()).up().e("conditionMode").t(userAssignRule.getConditionMode()).up().e("parentFlowkey").t(userAssignRule.getParentFlowKey()).up().e("type").t(userAssignRule.getType()).up().e("calcs");
            for (UserCalcPluginContext userCalcPluginContext : userAssignRule.getCalcPluginContextList()) {
                XMLBuilder calcXmlBuilder;
                if (!(userCalcPluginContext instanceof PluginParse) || (calcXmlBuilder = UserAssignRuleParser.getCalcXmlBuilder(userCalcPluginContext)) == null) continue;
                xmlBuilder = xmlBuilder.importXMLBuilder((BaseXMLBuilder)calcXmlBuilder);
            }
            xmlBuilder = xmlBuilder.up().up();
        }
    }

    private static final class EL_NAME {
        public static final String USER_RULE = "userRule";
        public static final String NAME = "name";
        public static final String GROUP_NO = "groupNo";
        public static final String DESCRIPTION = "description";
        public static final String CONDITION = "condition";
        public static final String CONDITION_MODE = "conditionMode";
        public static final String CALCS = "calcs";
        public static final String PARENT_FLOW_KEY = "parentFlowKey";

        private EL_NAME() {
        }
    }
}

