/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.execution.procnotify.plugin;

import com.hotent.base.util.AppUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.hotent.bpm.api.service.BpmCopyToService;
import com.hotent.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.hotent.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.hotent.bpm.plugin.execution.procnotify.def.ProcNotifyPluginDef;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyVo;
import com.hotent.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class ProcNotifyPlugin
extends AbstractBpmExecutionPlugin {
    private NotifyHelper notifyHelper = (NotifyHelper)AppUtil.getBean(NotifyHelper.class);
    @Resource
    private BpmCopyToService bpmCopyToService;

    @Override
    public Void execute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef) throws Exception {
        BpmDelegateExecution delegateExecution = pluginSession.getBpmDelegateExecution();
        Map<String, Object> variables = delegateExecution.getVariables();
        NotifyVo notifyVo = ((ProcNotifyPluginDef)pluginDef).getNotifyVoMap().get((Object)pluginSession.getEventType());
        if (notifyVo != null) {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            BpmProcessInstance instance = (BpmProcessInstance)actionCmd.getTransitVars("processInstance");
            if (actionCmd instanceof TaskFinishCmd) {
                String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
                String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
                String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
                String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
                variables.put("baseUrl", baseUrl);
                variables.put("instId", actionCmd.getInstId());
                BpmTask task = (BpmTask)actionCmd.getTransitVars("bpmTask_");
                variables.put("taskId", task.getId());
                variables.put("taskSubject", task.getSubject());
                variables.put("nodeName", task.getName());
                variables.put("instSubject", task.getSubject());
                IUser user = ContextUtil.getCurrentUser();
                if (user != null) {
                    variables.put("sender", user.getFullname());
                    variables.put("delegate", user.getFullname());
                    variables.put("agent", user.getFullname());
                }
                variables.put("manageBaseUrl", manage);
                variables.put("frontBaseUrl", front);
                variables.put("mobileBaseUrl", mobile);
                String cause = ((TaskFinishCmd)actionCmd).getApprovalOpinion();
                variables.put("cause", cause);
            }
            for (NotifyItem notifyItem : notifyVo.getNotifyItemList()) {
                List<IUser> toUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(notifyItem.getUserAssignRules(), variables);
                this.bpmCopyToService.copyTo(toUsers, instance, delegateExecution.getNodeId());
                this.notifyHelper.notify(toUsers, notifyItem.getMsgTypes(), "processEnd", variables);
            }
        }
        return null;
    }
}

