/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.execution.webservice.plugin;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.service.InvokeResult;
import com.hotent.base.service.ServiceClient;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.hotent.bpm.plugin.execution.webservice.def.WebServiceNodePluginDef;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class WebServiceTaskPlugin
extends AbstractBpmExecutionPlugin {
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    private ServiceClient serviceClient;

    @Override
    public Void execute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef) throws Exception {
        WebServiceNodePluginDef webServiceDef = (WebServiceNodePluginDef)pluginDef;
        Map<String, Object> variables = pluginSession.getBpmDelegateExecution().getVariables();
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty(boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(variables.get("instanceId_").toString());
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext(boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty(boMap)) {
            variables.putAll(boMap);
        }
        variables.putAll(this.getConfParam(webServiceDef, variables));
        if (this.serviceClient == null) {
            this.serviceClient = (ServiceClient)AppUtil.getBean(ServiceClient.class);
        }
        InvokeResult invokeResult = this.serviceClient.invoke(webServiceDef.getAlias(), variables);
        this.handleResult(invokeResult, pluginSession, webServiceDef, variables);
        return null;
    }

    private Map<String, Object> getConfParam(WebServiceNodePluginDef webServiceDef, Map<String, Object> variables) throws IOException {
        HashMap<String, Object> p = new HashMap<String, Object>();
        String inputStr = webServiceDef.getParams();
        ArrayNode params = (ArrayNode)JsonUtil.toJsonNode((String)inputStr);
        if (BeanUtils.isEmpty((Object)params)) {
            return p;
        }
        try {
            for (int i = 0; i < params.size(); ++i) {
                Object value;
                ObjectNode param = (ObjectNode)JsonUtil.toJsonNode((Object)params.get(i));
                String bindType = param.get("bindType").asText();
                String bindValue = param.get("bindValue").asText();
                String key = param.get("name").asText();
                if ("var".equals(bindType)) {
                    value = variables.get(bindValue);
                } else if ("bo".equals(bindType)) {
                    String[] boStr = bindValue.split("\\.");
                    ObjectNode bo = (ObjectNode)variables.get(boStr[0]);
                    value = bo.get(boStr[1]);
                } else {
                    value = this.groovyScriptEngine.executeObject(bindValue, variables);
                }
                p.put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("webService \u8282\u70b9\u89e3\u6790 \u8f93\u5165\u53c2\u6570\u5f02\u5e38\uff01    \u8be6\u7ec6\u4fe1\u606f\uff1a" + inputStr, e);
        }
        return p;
    }

    private void handleResult(InvokeResult invokeResult, BpmExecutionPluginSession pluginSession, WebServiceNodePluginDef webServiceDef, Map<String, Object> variables) throws IOException {
        if (invokeResult.isFault().booleanValue()) {
            throw new WorkFlowException("webService \u8c03\u7528\u5f02\u5e38\uff01");
        }
        String script = webServiceDef.getOutPutScript();
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        String jsonStr = invokeResult.getJson();
        variables.put("invokeResult", invokeResult);
        variables.put("pluginSession", pluginSession);
        if (!invokeResult.isVoid().booleanValue() && StringUtil.isNotEmpty((String)jsonStr)) {
            variables.put("data", JsonUtil.toJsonNode((String)jsonStr));
        }
        this.groovyScriptEngine.execute(script, variables);
    }
}

