/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.task.tasknotify.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.hotent.bpm.plugin.core.util.UserAssignRuleParser;
import com.hotent.bpm.plugin.task.tasknotify.def.TaskNotifyPluginDef;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyVo;
import com.hotent.bpm.plugin.task.userassign.context.EnumTypeProcessor;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NotifyUtil {
    public static List<NotifyItem> parseNotifyItems(Element parentOfNotifyElement) {
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>();
        NodeList nodeList = parentOfNotifyElement.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return notifyItems;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node obj = nodeList.item(i);
            if (!(obj instanceof Element) || !((Element)obj).getTagName().equals("notify")) continue;
            Element notifyEl = (Element)obj;
            List<UserAssignRule> userAssignRules = UserAssignRuleParser.parse(notifyEl);
            String msgTypes = notifyEl.getAttribute("msgTypes");
            NotifyItem notifyItem = new NotifyItem();
            notifyItem.setUserAssignRules(userAssignRules);
            notifyItem.setMsgTypes(msgTypes);
            notifyItems.add(notifyItem);
        }
        return notifyItems;
    }

    public static NotifyVo getNotifyVo(ArrayNode jsonAry) throws Exception {
        NotifyVo vo = new NotifyVo();
        if (jsonAry.size() == 0) {
            return vo;
        }
        ArrayList<NotifyItem> notifys = new ArrayList<NotifyItem>();
        for (Object obj : jsonAry) {
            ObjectNode notifyItemJson = (ObjectNode)JsonUtil.toJsonNode(obj);
            NotifyItem notifyItem = NotifyUtil.getNotifyItemByJson(notifyItemJson);
            notifys.add(notifyItem);
        }
        vo.setNotifyItemList(notifys);
        return vo;
    }

    public static NotifyItem getNotifyItemByJson(ObjectNode obj) throws Exception {
        NotifyItem notifyItem = new NotifyItem();
        String messageTypes = obj.get("msgTypes").asText();
        ArrayNode rules = (ArrayNode)obj.get("userAssignRules");
        notifyItem.setMsgTypes(messageTypes);
        ArrayList<UserAssignRule> ruleList = new ArrayList<UserAssignRule>();
        for (Object ruleObj : rules) {
            ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode(ruleObj);
            UserAssignRule rule = UserAssignRuleParser.getUserAssignRule(jsonObj);
            ruleList.add(rule);
        }
        notifyItem.setUserAssignRules(ruleList);
        return notifyItem;
    }

    public static void handXmlBuilder(NotifyVo completeVo, XMLBuilder xmlBuilder) {
        List<NotifyItem> notifyItems = completeVo.getNotifyItemList();
        for (NotifyItem item : notifyItems) {
            xmlBuilder = xmlBuilder.e("notify").a("xmlns", "http://www.jee-soft.cn/bpm/plugins/task/baseNotify").a("msgTypes", item.getMessageTypes());
            List<UserAssignRule> rules = item.getUserAssignRules();
            UserAssignRuleParser.handXmlBulider(xmlBuilder, rules);
            xmlBuilder = xmlBuilder.up();
        }
    }

    public static List<UserAssignRule> getRules(Collection<NotifyVo> listVo) {
        ArrayList<UserAssignRule> list = new ArrayList<UserAssignRule>();
        for (NotifyVo vo : listVo) {
            List<NotifyItem> notifyItems = vo.getNotifyItemList();
            for (NotifyItem item : notifyItems) {
                list.addAll(item.getUserAssignRules());
            }
        }
        return list;
    }

    public static void getJsonConfig(ObjectNode config, Collection<NotifyVo> assignRules) throws IOException {
        List<UserAssignRule> ruleList = NotifyUtil.getRules(assignRules);
        config.put(EventType.class.toString(), JsonUtil.toJsonNode((String)new EnumTypeProcessor().getTypeName()));
        config.put(NotifyItem.class.toString(), JsonUtil.toJson((Object)new String[]{"msgTypes"}));
        config.put(NotifyVo.class.toString(), JsonUtil.toJson((Object)new String[]{"eventType"}));
        config.put(NotifyVo.class.getName(), "notify");
        config.put(NotifyItem.class.getName(), "msgTypes");
        TaskNotifyPluginDef def = (TaskNotifyPluginDef)JsonUtil.toBean((JsonNode)config, TaskNotifyPluginDef.class);
        Map<EventType, NotifyVo> map = def.getNotifyVos();
        Map<EventType, List<NotifyItem>> rtnMap = NotifyUtil.convertNotifys(map);
        config.set(TaskNotifyPluginDef.class.getName(), (JsonNode)((ObjectNode)rtnMap));
    }

    private static Map<EventType, List<NotifyItem>> convertNotifys(Map<EventType, NotifyVo> map) {
        HashMap<EventType, List<NotifyItem>> rtnMaps = new HashMap<EventType, List<NotifyItem>>();
        Set<EventType> set = map.keySet();
        for (EventType eventType : set) {
            NotifyVo notifyVo = map.get((Object)eventType);
            rtnMaps.put(eventType, notifyVo.getNotifyItemList());
        }
        return rtnMaps;
    }
}

