/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.task.userassign;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.plugin.task.userassign.context.UserAssignPluginContext;
import com.hotent.bpm.plugin.task.userassign.def.UserAssignPluginDef;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class UserDefBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<String> {
    @Override
    protected String getXml(String defId, String nodeId, String json) {
        throw new RuntimeException("\u8be5\u65b9\u6cd5\u5df2\u7ecf\u8fc7\u65f6\uff01");
    }

    public void saveNodeXml(String defId, Map<String, String> userMap, String parentFlowKey) throws Exception {
        if (BeanUtils.isEmpty(userMap)) {
            return;
        }
        Set<Map.Entry<String, String>> entrySet = userMap.entrySet();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defxml = def.getBpmnXml();
        Element root = this.updateRoot(defxml);
        String rtnXml = "";
        for (Map.Entry<String, String> entry : entrySet) {
            String nodeId = entry.getKey();
            String nodeJson = entry.getValue();
            if (StringUtil.isEmpty((String)parentFlowKey)) {
                parentFlowKey = "local_";
            }
            String xml = this.getXmlByJson(nodeJson, defId, nodeId, parentFlowKey);
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins/user:userAssign";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins";
            rtnXml = DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
            root = this.updateRoot(rtnXml);
        }
        this.updateXml(defId, rtnXml);
    }

    private Element updateRoot(String rtnXml) {
        Document doc = Dom4jUtil.loadXml((String)rtnXml);
        Element root = doc.getRootElement();
        root.addNamespace("user", "http://www.jee-soft.cn/bpm/plugins/task/userAssign");
        return root;
    }

    @Deprecated
    public void saveNodeXml(String defId, String nodeId, String nodeJson, String parentFlowKey) throws Exception {
        if (StringUtil.isEmpty((String)parentFlowKey)) {
            parentFlowKey = "local_";
        }
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String xml = this.getXmlByJson(nodeJson, defId, nodeId, parentFlowKey);
        String defxml = def.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defxml);
        Element root = doc.getRootElement();
        root.addNamespace("user", "http://www.jee-soft.cn/bpm/plugins/task/userAssign");
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins/user:userAssign";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins";
        String rtnXml = DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
        this.updateXml(defId, rtnXml);
    }

    private String getXmlByJson(String json, String defId, String nodeId, String parentFlowKey) throws Exception {
        UserAssignPluginContext context = (UserAssignPluginContext)AppUtil.getBean(UserAssignPluginContext.class);
        context.parse(json);
        this.handelContext(context, parentFlowKey, defId, nodeId);
        String xml = context.getPluginXml();
        return xml;
    }

    private void handelContext(UserAssignPluginContext context, String parentFlowKey, String defId, String nodeId) throws Exception {
        UserAssignPluginDef def = (UserAssignPluginDef)context.getBpmPluginDef();
        List<UserAssignRule> ruleList = def.getRuleList();
        for (UserAssignRule rule : ruleList) {
            rule.setParentFlowKey(parentFlowKey);
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        UserAssignPluginContext oldContext = nodeDef.getPluginContext(UserAssignPluginContext.class);
        if (oldContext == null) {
            return;
        }
        UserAssignPluginDef oldDef = (UserAssignPluginDef)oldContext.getBpmPluginDef();
        List<UserAssignRule> oldRuleList = oldDef.getRuleList();
        if (BeanUtils.isEmpty(oldRuleList)) {
            return;
        }
        for (UserAssignRule oldRule : oldRuleList) {
            if (StringUtil.isEmpty((String)oldRule.getParentFlowKey())) {
                oldRule.setParentFlowKey("local_");
            }
            if (oldRule.getParentFlowKey().equals(parentFlowKey)) continue;
            ruleList.add(oldRule);
        }
    }

    public String copyNodeUser(String sourceNodeId, String targetNodeId, String bpmnXml, String parentDefKey) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        if ("local_".equals(parentDefKey)) {
            String xParentPath = "//ext:*[@bpmnElement='%s']/ext:extPlugins";
            String subElName = "userAssign";
            Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
            Element element = parentEl.element(subElName);
            DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        }
        return root.asXML();
    }
}

