/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.grouprel.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.XmlUtil;
import com.hotent.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.hotent.bpm.plugin.usercalc.cuserrel.def.ExecutorVar;
import com.hotent.bpm.plugin.usercalc.grouprel.def.GroupRelPluginDef;
import com.hotent.bpm.plugin.usercalc.grouprel.runtime.GroupRelPlugin;
import org.w3c.dom.Element;

public class GroupRelPluginContext
extends AbstractUserCalcPluginContext {
    private static final long serialVersionUID = -6084686546165511275L;

    @Override
    public String getDescription() {
        GroupRelPluginDef def = (GroupRelPluginDef)this.getBpmPluginDef();
        if (def == null) {
            return "";
        }
        String source = def.getSource();
        StringBuffer sb = new StringBuffer();
        if ("start".equals(source)) {
            sb.append("\u53d1\u8d77\u4eba");
        } else if ("prev".equals(source)) {
            sb.append("\u4e0a\u4e00\u6b65\u6267\u884c\u4eba");
        } else if ("var".equals(source)) {
            sb.append(def.getVar().getSource() + "[" + def.getVar().getExecutorType() + ":" + def.getVar().getName() + "]");
        } else if ("spec".equals(source)) {
            sb.append("\u6307\u5b9a\u7528\u6237\u7ec4");
            sb.append("[");
            sb.append(def.getGroupName());
            sb.append("]");
        }
        if (def.isSupportRelation()) {
            sb.append("\u5173\u7cfb\u7c7b\u578b[");
            sb.append(def.getRelationTypeName());
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return "\u7ec4\u5173\u7cfb";
    }

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return GroupRelPlugin.class;
    }

    @Override
    public String getPluginXml() {
        GroupRelPluginDef def = (GroupRelPluginDef)this.getBpmPluginDef();
        if (def == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<groupRel xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/groupRel\" ");
        sb.append("   source=\"" + def.getSource() + "\"  groupType=\"" + def.getGroupType() + "\"  groupTypeName=\"" + def.getGroupTypeName() + "\" relationType=\"" + def.getRelationType() + "\" relationTypeName=\"" + def.getRelationTypeName() + "\" logicCal=\"" + def.getLogicCal().getKey() + "\" supportRelation=\"" + (def.isSupportRelation() ? "true" : "false") + "\" extract=\"" + def.getExtract().getKey() + "\"> ");
        if ("spec".equals(def.getSource())) {
            sb.append("<groups groupKey=\"" + def.getGroupKey() + "\" groupName=\"" + def.getGroupName() + "\"/>");
        }
        if ("var".equals(def.getSource())) {
            sb.append("<var source=\"" + def.getVar().getSource() + "\" name=\"" + def.getVar().getName() + "\"    executorType=\"" + def.getVar().getExecutorType() + "\" userValType=\"" + def.getVar().getUserValType() + "\"  groupValType=\"" + def.getVar().getGroupValType() + "\"\tdimension=\"" + def.getVar().getDimension() + "\" />  ");
        }
        sb.append("</groupRel>");
        return sb.toString();
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        GroupRelPluginDef def = new GroupRelPluginDef();
        String source = element.getAttribute("source");
        String groupType = element.getAttribute("groupType");
        String groupTypeName = element.getAttribute("groupTypeName");
        String supportRelation = element.getAttribute("supportRelation");
        def.setSource(source);
        def.setGroupType(groupType);
        def.setGroupTypeName(groupTypeName);
        if (StringUtil.isNotEmpty((String)supportRelation)) {
            boolean blnSupportRelation = "true".equals(supportRelation);
            def.setSupportRelation(blnSupportRelation);
            if (blnSupportRelation) {
                String relationType = element.getAttribute("relationType");
                String relationTypeName = element.getAttribute("relationTypeName");
                def.setRelationType(relationType);
                def.setRelationTypeName(relationTypeName);
            }
        }
        if ("spec".equals(def.getSource())) {
            Element groupEl = XmlUtil.getChildNodeByName((Element)element, (String)"groups");
            String groupKey = groupEl.getAttribute("groupKey");
            String groupName = groupEl.getAttribute("groupName");
            def.setGroupKey(groupKey);
            def.setGroupName(groupName);
        }
        if ("var".equals(source)) {
            Element varEl = XmlUtil.getChildNodeByName((Element)element, (String)"var");
            String name = varEl.getAttribute("name");
            String source1 = varEl.getAttribute("source");
            String executorType = varEl.getAttribute("executorType");
            String userValType = varEl.getAttribute("userValType");
            String groupValType = varEl.getAttribute("groupValType");
            String dimension = varEl.getAttribute("dimension");
            ExecutorVar executorVar = new ExecutorVar(source1, name, executorType, userValType, groupValType, dimension);
            def.setExecutorVar(executorVar);
        }
        return def;
    }

    @Override
    protected BpmPluginDef parseJson(ObjectNode pluginJson) throws Exception {
        GroupRelPluginDef def = new GroupRelPluginDef();
        String source = JsonUtil.getString((JsonNode)pluginJson, (String)"source");
        String groupType = JsonUtil.getString((JsonNode)pluginJson, (String)"groupType");
        String groupTypeName = JsonUtil.getString((JsonNode)pluginJson, (String)"groupTypeName");
        def.setSource(source);
        def.setGroupType(groupType);
        def.setGroupTypeName(groupTypeName);
        if ("spec".equals(source)) {
            String groupKey = JsonUtil.getString((JsonNode)pluginJson, (String)"groupKey");
            String groupName = JsonUtil.getString((JsonNode)pluginJson, (String)"groupName");
            def.setGroupKey(groupKey);
            def.setGroupName(groupName);
        }
        if ("var".equals(source)) {
            ExecutorVar executorVar = (ExecutorVar)JsonUtil.toBean((String)pluginJson.get("var").asText(), ExecutorVar.class);
            def.setExecutorVar(executorVar);
        }
        boolean supportRelation = JsonUtil.getBoolean((ObjectNode)pluginJson, (String)"supportRelation");
        def.setSupportRelation(supportRelation);
        if (supportRelation) {
            String relationType = JsonUtil.getString((JsonNode)pluginJson, (String)"relationType");
            String relationTypeName = JsonUtil.getString((JsonNode)pluginJson, (String)"relationTypeName");
            def.setRelationTypeName(relationTypeName);
            def.setRelationType(relationType);
        }
        return def;
    }
}

