/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.job.runtime;

import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.job.def.JobPluginDef;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.OrgJob;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IOrgService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JobPlugin
extends AbstractUserCalcPlugin {
    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        JobPluginDef def = (JobPluginDef)pluginDef;
        String jobCode = def.getJobCode();
        String jobName = def.getJobName();
        if (StringUtil.isEmpty((String)jobCode)) {
            return identityList;
        }
        String[] jobCodes = jobCode.split(",");
        IOrgService orgEngine = pluginSession.getOrgEngine();
        Map<String, Object> vars = pluginSession.getVariables();
        boolean isReqUc = StringUtil.isEmpty((String)((String)vars.get("not_request_uc")));
        List groups = isReqUc || ExtractType.EXACT_EXACT_USER.equals((Object)def.getExtract()) ? orgEngine.getUserGroupService().getGroupsByIdsOrCodes(GroupTypeConstant.JOB.key(), Stream.of(jobCodes).collect(Collectors.toList())) : this.buildJobGroup(jobCode, jobName);
        for (IGroup group : groups) {
            BpmIdentity bpmIdentity = this.getBpmIdentityConverter().convertGroup(group);
            identityList.add(bpmIdentity);
        }
        return identityList;
    }

    private List<OrgJob> buildJobGroup(String jobCode, String jobName) {
        String[] jobCodes = jobCode.split(",");
        String[] jobNames = jobName.split(",");
        ArrayList<OrgJob> groups = new ArrayList<OrgJob>();
        for (int i = 0; i < jobCodes.length; ++i) {
            String jobCode1 = jobCodes[i];
            String jobName1 = jobNames[i];
            OrgJob job = new OrgJob();
            job.setCode(jobCode1);
            job.setName(jobName1);
            groups.add(job);
        }
        return groups;
    }
}

