/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.org.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.hotent.bpm.plugin.usercalc.org.def.OrgPluginDef;
import com.hotent.bpm.plugin.usercalc.org.runtime.OrgPlugin;
import org.w3c.dom.Element;

public class OrgPluginContext
extends AbstractUserCalcPluginContext {
    private static final long serialVersionUID = -5261531157333798291L;

    @Override
    public String getDescription() {
        OrgPluginDef def = (OrgPluginDef)this.getBpmPluginDef();
        if (def == null) {
            return "";
        }
        return def.getOrgName();
    }

    @Override
    public String getTitle() {
        return "\u7ec4\u7ec7";
    }

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return OrgPlugin.class;
    }

    @Override
    public String getPluginXml() {
        BpmPluginDef bpmPluginDef = this.getBpmPluginDef();
        OrgPluginDef def = (OrgPluginDef)bpmPluginDef;
        if (def == null) {
            return "";
        }
        String xml = String.format("<org xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/org\" logicCal=\"%s\"  extract=\"%s\" orgCode=\"%s\" orgName=\"%s\" currLevelOrSubLevel=\"%s\"/>", new Object[]{def.getLogicCal(), def.getExtract(), def.getOrgCode(), def.getOrgName(), def.getCurrLevelOrSubLevel()});
        return xml;
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        OrgPluginDef def = new OrgPluginDef();
        String orgCode = element.getAttribute("orgCode");
        String orgName = element.getAttribute("orgName");
        String currLevelOrSubLevel = element.getAttribute("currLevelOrSubLevel");
        def.setOrgCode(orgCode);
        def.setOrgName(orgName);
        if (StringUtil.isNotEmpty((String)currLevelOrSubLevel)) {
            def.setCurrLevelOrSubLevel(Boolean.valueOf(currLevelOrSubLevel));
        }
        return def;
    }

    @Override
    protected BpmPluginDef parseJson(ObjectNode pluginJson) throws Exception {
        OrgPluginDef def = new OrgPluginDef();
        String orgCode = JsonUtil.getString((JsonNode)pluginJson, (String)"orgCode");
        String orgName = JsonUtil.getString((JsonNode)pluginJson, (String)"orgName");
        boolean currLevelOrSubLevel = JsonUtil.getBoolean((ObjectNode)pluginJson, (String)"currLevelOrSubLevel", (boolean)false);
        def.setOrgCode(orgCode);
        def.setOrgName(orgName);
        def.setCurrLevelOrSubLevel(currLevelOrSubLevel);
        return def;
    }
}

