/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.position.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.position.def.PositionPluginDef;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.OrgRel;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IOrgService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PositionPlugin
extends AbstractUserCalcPlugin {
    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        JsonNode node;
        Object rust;
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        PositionPluginDef def = (PositionPluginDef)pluginDef;
        String posCode = "";
        String posName = "";
        String source = def.getSource();
        if (StringUtil.isEmpty((String)source)) {
            return identityList;
        }
        IOrgService orgEngine = pluginSession.getOrgEngine();
        Map<String, Object> vars = pluginSession.getVariables();
        if ("startSuper".equals(source)) {
            String startId = (String)vars.get("startUser");
            rust = orgEngine.getUserService().getSuperiorPost(startId);
            if (BeanUtils.isNotEmpty((Object)rust)) {
                node = (JsonNode)rust;
                posCode = node.get("code").asText();
                posName = node.get("name").asText();
            }
        } else if ("prevSuper".equals(source)) {
            String userId = ContextUtil.getCurrentUser().getUserId();
            rust = orgEngine.getUserService().getSuperiorPost(userId);
            if (BeanUtils.isNotEmpty((Object)rust)) {
                node = (JsonNode)rust;
                posCode = node.get("code").asText();
                posName = node.get("name").asText();
            }
        } else if ("spec".equals(source)) {
            posCode = def.getPosCode();
            posName = def.getPosName();
        }
        if (StringUtil.isEmpty((String)posCode)) {
            return identityList;
        }
        String[] posCodes = posCode.split(",");
        boolean isReqUc = StringUtil.isEmpty((String)((String)vars.get("not_request_uc")));
        List groups = isReqUc || ExtractType.EXACT_EXACT_USER.equals((Object)def.getExtract()) ? orgEngine.getUserGroupService().getGroupsByIdsOrCodes(GroupTypeConstant.POSITION.key(), Stream.of(posCodes).collect(Collectors.toList())) : this.buildPositionGroup(posCode, posName);
        for (IGroup group : groups) {
            BpmIdentity bpmIdentity = this.getBpmIdentityConverter().convertGroup(group);
            identityList.add(bpmIdentity);
        }
        return identityList;
    }

    private List<OrgRel> buildPositionGroup(String posCode, String posName) {
        String[] posCodes = posCode.split(",");
        String[] posNames = posName.split(",");
        ArrayList<OrgRel> groups = new ArrayList<OrgRel>();
        for (int i = 0; i < posCodes.length; ++i) {
            String postCode = posCodes[i];
            String postName = posNames[i];
            OrgRel pos = new OrgRel();
            pos.setCode(postCode);
            pos.setName(postName);
            groups.add(pos);
        }
        return groups;
    }
}

