/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.role.runtime;

import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.role.def.RolePluginDef;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.Role;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IOrgService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RolePlugin
extends AbstractUserCalcPlugin {
    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        RolePluginDef def = (RolePluginDef)pluginDef;
        String roleCode = def.getRoleCode();
        String roleName = def.getRoleName();
        if (StringUtil.isEmpty((String)roleCode)) {
            return identityList;
        }
        IOrgService orgEngine = pluginSession.getOrgEngine();
        Map<String, Object> vars = pluginSession.getVariables();
        boolean isReqUc = StringUtil.isEmpty((String)((String)vars.get("not_request_uc")));
        List groups = isReqUc || ExtractType.EXACT_EXACT_USER.equals((Object)def.getExtract()) ? orgEngine.getUserGroupService().getGroupsByIdsOrCodes(GroupTypeConstant.ROLE.key(), Stream.of(roleCode).collect(Collectors.toList())) : this.buildRoleGroup(roleCode, roleName);
        for (IGroup group : groups) {
            BpmIdentity bpmIdentity = this.getBpmIdentityConverter().convertGroup(group);
            identityList.add(bpmIdentity);
        }
        return identityList;
    }

    private List<Role> buildRoleGroup(String roleCode, String roleName) {
        String[] roleCodes = roleCode.split(",");
        String[] roleNames = roleName.split(",");
        ArrayList<Role> groups = new ArrayList<Role>();
        for (int i = 0; i < roleCodes.length; ++i) {
            String roleCode1 = roleCodes[i];
            String roleName1 = roleNames[i];
            Role role = new Role();
            role.setCode(roleCode1);
            role.setName(roleName1);
            groups.add(role);
        }
        return groups;
    }
}

