/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.service.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.jms.FlowMessage;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmFlowMqLogManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.service.FlowMessageService;
import com.hotent.bpm.service.PortalMsgPushService;
import com.hotent.bpm.todo.constant.FlowStatusType;
import com.hotent.bpm.todo.constant.OperateType;
import com.hotent.bpm.todo.vo.HandledTask;
import com.hotent.bpm.todo.vo.InsertCallyTaskVo;
import com.hotent.bpm.todo.vo.InsertDoneTaskVo;
import com.hotent.bpm.todo.vo.OperatorCallyTasksVo;
import com.hotent.bpm.todo.vo.PendingTask;
import com.hotent.bpm.todo.vo.PortalTaskVo;
import com.hotent.bpm.todo.vo.UpdateFlowsVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PortalMsgPushServiceImpl
implements PortalMsgPushService {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    IUserService userService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    FlowMessageService flowMessageService;
    @Resource
    BpmFlowMqLogManager bpmFlowMqLogManager;
    @Value(value="${eip.frontUrl:''}")
    private String frontUrl;
    @Value(value="${eip.mobileUrl:''}")
    private String mobileUrl;
    private Logger logger = LoggerFactory.getLogger(PortalMsgPushServiceImpl.class);

    @Override
    public void startFlow(DefaultBpmProcessInstance instance) {
        String status = this.getPortalInstanceStatus(instance.getStatus());
        UpdateFlowsVo vo = new UpdateFlowsVo(instance.getId(), instance.getCreateBy(), instance.getSubject(), status, instance.getProcDefKey(), instance.getProcDefName(), instance.getCreateTime(), instance.getId(), instance.getProcDefName(), instance.getCreateOrgId(), instance.getCreateOrgPath(), instance.getSupportMobile());
        try {
            vo.setProcessKey(instance.getProcDefKey());
            vo.setSystemCode("bpm");
            vo.setOperatorType(OperateType.START_FLOW.getKey());
            vo.setFlowStatusName(FlowStatusType.fromKey(vo.getFlowStatus()).getValue());
            vo.setOwerId(instance.getCreator());
            vo.setOwerName(ContextUtil.getCurrentUser().getFullname());
            vo.setOwerAccount(ContextUtil.getCurrentUser().getAccount());
            vo.setProcDefId(instance.getProcDefId());
            FlowMessage msg = new FlowMessage();
            msg.setType("inst_new");
            msg.setSubject(instance.getSubject());
            msg.setInstId(instance.getId());
            String contentStr = JsonUtil.toJson((Object)vo);
            msg.setInstId(instance.getId());
            msg.setContent(Base64.getBase64((String)contentStr));
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(instance.getSubject(), "inst_new", 1, msg, "");
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            this.buildLog(instance.getSubject(), "inst_new", 0, vo, e.getMessage());
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void updateProcessStatus(DefaultBpmProcessInstance instance) {
        if (BeanUtils.isNotEmpty((Object)instance) && StringUtil.isZeroEmpty((String)instance.getParentInstId())) {
            String status = this.getPortalInstanceStatus(instance.getStatus());
            UpdateFlowsVo vo = new UpdateFlowsVo(instance.getId(), instance.getCreateBy(), instance.getSubject(), status, instance.getProcDefKey(), instance.getProcDefName(), instance.getCreateTime(), instance.getId(), instance.getProcDefName(), instance.getCreateOrgId(), instance.getCreateOrgPath(), instance.getSupportMobile());
            try {
                instance.setFormKey("bpm");
                vo.setSystemCode("bpm");
                vo.setOperatorType(OperateType.UPDATE_FLOW.getKey());
                vo.setProcessKey(instance.getProcDefKey());
                vo.setOwerName(instance.getCreator());
                vo.setProcDefId(instance.getProcDefId());
                FlowMessage msg = new FlowMessage();
                msg.setType("inst_update");
                msg.setSubject(instance.getSubject());
                String contentStr = JsonUtil.toJson((Object)vo);
                msg.setInstId(instance.getId());
                msg.setContent(Base64.getBase64((String)contentStr));
                this.flowMessageService.handlerFlowJmsMessage(msg);
                this.buildLog(instance.getSubject(), "inst_update", 1, msg, "");
            }
            catch (Exception e) {
                this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
                this.buildLog(instance.getSubject(), "inst_update", 0, vo, e.getMessage());
                throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private String getPortalInstanceStatus(String statu) {
        String status = statu;
        switch (statu) {
            case "running": {
                status = "approving";
                break;
            }
            case "draft": {
                status = "draft";
                break;
            }
            case "end": {
                status = "complete";
                break;
            }
            case "revokeToStart": {
                status = "revoke";
                break;
            }
            case "backToStart": {
                status = "approving";
                break;
            }
            case "back": 
            case "BACK": {
                status = "approving";
                break;
            }
            case "manualend": {
                status = "cancel";
            }
        }
        return status;
    }

    @Override
    public void addTodo(PortalTaskVo portalTaskVo) {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        try {
            Map<String, Object> vars;
            String status;
            String string = status = StringUtil.isNotEmpty((String)portalTaskVo.getStatus()) ? portalTaskVo.getStatus() : "";
            if (StringUtil.isNotEmpty((String)status) && "back".equals(status.toLowerCase()) && BeanUtils.isNotEmpty((Object)cmd) && BeanUtils.isNotEmpty(vars = cmd.getTransitVars()) && BeanUtils.isNotEmpty((Object)vars.get("approval_type"))) {
                status = (String)vars.get("approval_type");
            }
            portalTaskVo.setOperatorType(OperateType.UPDATE_FLOW.getKey());
            portalTaskVo.setPcTaskUrl(String.format("%s", this.frontUrl));
            portalTaskVo.setMobileTaskUrl(String.format("%s", this.mobileUrl));
            FlowMessage msg = new FlowMessage();
            msg.setType("task_create");
            msg.setSubject(portalTaskVo.getSubject());
            String contentStr = JsonUtil.toJson((Object)portalTaskVo);
            msg.setContent(Base64.getBase64((String)contentStr));
            msg.setInstId(portalTaskVo.getInstId());
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(portalTaskVo.getSubject(), "task_create", 1, msg, "");
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            this.buildLog(portalTaskVo.getSubject(), "task_create", 0, portalTaskVo, e.getMessage());
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void delTodo(String instId, List<String> taskIdList, int type, List<String> ownerList, String fromSysKey, PortalTaskVo portalTaskVo) {
        FlowMessage msg = new FlowMessage();
        msg.setType("task_remove");
        msg.setSubject("\u5220\u9664\u5f85\u529e");
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        node.put("instanceId", instId);
        node.put("operatorType", type);
        node.put("flowType", portalTaskVo.getFlowType());
        node.put("flowTypeName", portalTaskVo.getFlowTypeName());
        try {
            node.put("taskIdList", StringUtils.join(taskIdList, (String)","));
            String contentStr = JsonUtil.toJson((Object)node);
            msg.setContent(Base64.getBase64((String)contentStr));
            msg.setInstId(instId);
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(msg.getSubject(), "task_remove", 1, msg, "");
        }
        catch (IOException e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            this.buildLog(msg.getSubject(), "task_remove", 0, node, "");
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void toCompleted(HandledTask task) {
        InsertDoneTaskVo insertDoneTask = new InsertDoneTaskVo(task.getId(), task.getType(), task.getAssigneeId(), task.getAssigneeName(), task.getCompleteTime());
        try {
            IUser user;
            if (StringUtil.isEmpty((String)insertDoneTask.getTaskApproveAccount()) && StringUtil.isNotEmpty((String)insertDoneTask.getTaskApproveId()) && BeanUtils.isNotEmpty((Object)(user = this.userService.getUserById(insertDoneTask.getTaskApproveId())))) {
                insertDoneTask.setTaskApproveName(user.getFullname());
                insertDoneTask.setTaskApproveAccount(user.getAccount());
            }
            insertDoneTask.setInstanceId(task.getProcInstId());
            insertDoneTask.setInstanceId(task.getProcInstId());
            insertDoneTask.setTaskDoneDate(task.getCompleteTime());
            insertDoneTask.setOperatorType(OperateType.PENDING_TO_DEAl.getStringKey());
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)task.getProcInstId()));
            insertDoneTask.setSystemCode("bpm");
            insertDoneTask.setFlowType(instance.getProcDefKey());
            insertDoneTask.setFlowTypeName(instance.getProcDefName());
            FlowMessage msg = new FlowMessage();
            msg.setType("task_2_done");
            msg.setSubject(task.getSubject());
            String contentStr = JsonUtil.toJson((Object)insertDoneTask);
            msg.setContent(Base64.getBase64((String)contentStr));
            msg.setInstId(instance.getId());
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(task.getSubject(), "task_2_done", 1, msg, "");
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            this.buildLog(task.getSubject(), "task_2_done", 0, insertDoneTask, "");
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void copyTo(PendingTask task) {
        try {
            String taskStatus = "COPYTO";
            String todoType = "\u4f20\u9605";
            if ("COMMU".equals(task.getTaskStatus())) {
                taskStatus = "COMMU";
                todoType = "\u6c9f\u901a";
            }
            IUser user = this.userService.getUserById(task.getOwnerId());
            InsertCallyTaskVo insertCallTask = new InsertCallyTaskVo(task.getId(), task.getType(), task.getProcInstId(), user.getAccount(), user.getFullname(), task.getCreateTime(), "5");
            IUser currentUser = ContextUtil.getCurrentUser();
            if (BeanUtils.isNotEmpty((Object)currentUser)) {
                insertCallTask.setCallyStartAccount(currentUser.getAccount());
                insertCallTask.setCallyStartName(currentUser.getFullname());
            } else {
                insertCallTask.setCallyStartAccount("admin");
                insertCallTask.setCallyStartName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            insertCallTask.setOperatorType(OperateType.ADD_COPYTO.getKey() + "");
            insertCallTask.setPcTaskUrl(String.format("%s/matter/approvalForm?readId=%s&instId=%s&from=received&receivedStatus=%s", this.frontUrl, insertCallTask.getCallyId(), insertCallTask.getInstanceId(), taskStatus));
            if (task.getSupportMobile() == 1) {
                insertCallTask.setMobileTaskUrl(String.format("%s/matter/approvalForm?readId=%s&instId=%s&from=received&receivedStatus=%s", this.mobileUrl, insertCallTask.getCallyId(), insertCallTask.getInstanceId(), taskStatus));
            }
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)task.getProcInstId()));
            insertCallTask.setSystemCode("bpm");
            insertCallTask.setFlowType(instance.getProcDefKey());
            insertCallTask.setFlowTypeName(instance.getProcDefName());
            insertCallTask.setTodoType(todoType);
            FlowMessage msg = new FlowMessage();
            msg.setType("copy_new");
            msg.setSubject("\u3010" + todoType + "\u3011" + task.getSubject());
            try {
                String contentStr = JsonUtil.toJson((Object)insertCallTask);
                msg.setContent(Base64.getBase64((String)contentStr));
            }
            catch (IOException e) {
                this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
                throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
            }
            msg.setInstId(instance.getId());
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(task.getSubject(), "copy_new", 1, msg, "");
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void dealCopyTo(HandledTask task) {
        try {
            OperatorCallyTasksVo operatorCallyTasksVo = new OperatorCallyTasksVo(task.getId(), "\u6284\u9001", task.getProcInstId(), "-1", task.getAssigneeId(), task.getAssigneeName(), "6");
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)task.getProcInstId()));
            operatorCallyTasksVo.setSystemCode("bpm");
            operatorCallyTasksVo.setInstanceId(instance.getId());
            operatorCallyTasksVo.setFlowType(instance.getProcDefKey());
            operatorCallyTasksVo.setFlowTypeName(instance.getProcDefName());
            operatorCallyTasksVo.setStatus(task.getTaskStatus());
            FlowMessage msg = new FlowMessage();
            msg.setType("copy_handle");
            msg.setSubject(task.getSubject());
            try {
                String contentStr = JsonUtil.toJson((Object)operatorCallyTasksVo);
                msg.setContent(Base64.getBase64((String)contentStr));
            }
            catch (IOException e) {
                this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
                throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
            }
            msg.setInstId(instance.getId());
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(task.getSubject(), "copy_handle", 1, msg, "");
        }
        catch (Exception e1) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e1);
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e1.getMessage());
        }
    }

    @Override
    public void follow(PendingTask task) {
        try {
            IUser user = this.userService.getUserById(task.getOwnerId());
            InsertCallyTaskVo insertCallTask = new InsertCallyTaskVo(task.getId(), task.getType(), task.getProcInstId(), user.getAccount(), user.getFullname(), task.getCreateTime(), "5");
            IUser currentUser = ContextUtil.getCurrentUser();
            if (BeanUtils.isNotEmpty((Object)currentUser)) {
                insertCallTask.setCallyStartAccount(currentUser.getAccount());
                insertCallTask.setCallyStartName(currentUser.getFullname());
            } else {
                insertCallTask.setCallyStartAccount("admin");
                insertCallTask.setCallyStartName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            insertCallTask.setOperatorType(OperateType.ADD_COPYTO.getKey() + "");
            insertCallTask.setPcTaskUrl(String.format("%s/matter/approvalForm?readId=%s&instId=%s&from=received&receivedStatus=FOLLOW", this.frontUrl, insertCallTask.getCallyId(), insertCallTask.getInstanceId()));
            if (task.getSupportMobile() == 1) {
                insertCallTask.setMobileTaskUrl(String.format("%s/matter/approvalForm?readId=%s&instId=%s", this.mobileUrl, insertCallTask.getCallyId(), insertCallTask.getInstanceId()));
            }
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)task.getProcInstId()));
            insertCallTask.setSystemCode("bpm");
            FlowMessage msg = new FlowMessage();
            msg.setType("copy_new");
            msg.setSubject("\u3010\u8ddf\u8e2a\u3011" + task.getSubject());
            try {
                String contentStr = JsonUtil.toJson((Object)insertCallTask);
                msg.setContent(Base64.getBase64((String)contentStr));
            }
            catch (IOException e) {
                this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
                throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
            }
            msg.setInstId(instance.getId());
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(task.getSubject(), "copy_new", 1, msg, "");
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void lockOrUnLockTask(String instanceId, String taskId, String account, String type) {
        FlowMessage msg = new FlowMessage();
        msg.setType("lockOrUnLock");
        msg.setSubject("\u9501\u5b9a\u6216\u89e3\u9501\u4efb\u52a1");
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        node.put("instanceId", instanceId);
        node.put("type", type);
        node.put("account", account);
        node.put("taskId", taskId);
        try {
            String contentStr = JsonUtil.toJson((Object)node);
            msg.setContent(Base64.getBase64((String)contentStr));
            msg.setInstId(instanceId);
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(msg.getSubject(), "lockOrUnLock", 1, msg, "");
        }
        catch (IOException e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            this.buildLog(msg.getSubject(), "lockOrUnLock", 0, node, "");
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void commuTo(PendingTask task) {
        try {
            IUser user = this.userService.getUserById(task.getOwnerId());
            InsertCallyTaskVo insertCallTask = new InsertCallyTaskVo(task.getId(), task.getType(), task.getProcInstId(), user.getAccount(), user.getFullname(), task.getCreateTime(), "5");
            IUser currentUser = ContextUtil.getCurrentUser();
            if (BeanUtils.isNotEmpty((Object)currentUser)) {
                insertCallTask.setCallyStartAccount(currentUser.getAccount());
                insertCallTask.setCallyStartName(currentUser.getFullname());
            } else {
                insertCallTask.setCallyStartAccount("admin");
                insertCallTask.setCallyStartName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            insertCallTask.setOperatorType(OperateType.ADD_COPYTO.getKey() + "");
            insertCallTask.setPcTaskUrl(String.format("%s/matter/approvalForm?readId=%s&instId=%s&from=received&receivedStatus=COMMU", this.frontUrl, insertCallTask.getCallyId(), insertCallTask.getInstanceId()));
            if (task.getSupportMobile() == 1) {
                insertCallTask.setMobileTaskUrl(String.format("%s/matter/approvalForm?readId=%s&instId=%s&from=received&receivedStatus=COPYTO", this.mobileUrl, insertCallTask.getCallyId(), insertCallTask.getInstanceId()));
            }
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)task.getProcInstId()));
            insertCallTask.setSystemCode("bpm");
            FlowMessage msg = new FlowMessage();
            msg.setType("copy_new");
            msg.setSubject("\u3010\u4f20\u9605\u3011" + task.getSubject());
            try {
                String contentStr = JsonUtil.toJson((Object)insertCallTask);
                msg.setContent(Base64.getBase64((String)contentStr));
            }
            catch (IOException e) {
                this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
                throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
            }
            msg.setInstId(instance.getId());
            this.flowMessageService.handlerFlowJmsMessage(msg);
            this.buildLog(task.getSubject(), "copy_new", 1, msg, "");
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            throw new WorkFlowException("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void buildLog(String subject, String type, int status, Object vo, String exception) {
        String instId = "";
        String taskId = "";
        String ownerId = "";
        String ownerName = "";
        String contentStr = "";
        if (vo instanceof UpdateFlowsVo) {
            UpdateFlowsVo instVo = (UpdateFlowsVo)vo;
            instId = instVo.getInstanceId();
        } else if (vo instanceof PortalTaskVo) {
            PortalTaskVo taskVo = (PortalTaskVo)vo;
            instId = taskVo.getInstId();
            taskId = taskVo.getTaskId();
            ownerId = taskVo.getTaskApproveId();
            ownerName = taskVo.getTaskApproveName();
        } else if (vo instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)vo;
            instId = BeanUtils.isNotEmpty((Object)node.get("instanceId")) ? node.get("instanceId").asText() : "";
        } else if (vo instanceof InsertDoneTaskVo) {
            InsertDoneTaskVo doneTaskVo = (InsertDoneTaskVo)vo;
            instId = doneTaskVo.getInstanceId();
            taskId = doneTaskVo.getTaskId();
            ownerId = doneTaskVo.getTaskApproveId();
            ownerName = doneTaskVo.getTaskApproveName();
        } else if (vo instanceof PendingTask) {
            PendingTask task = (PendingTask)vo;
            instId = task.getProcInstId();
            taskId = task.getId();
            ownerId = task.getOwnerId();
            ownerName = task.getOwnerName();
        } else if (vo instanceof HandledTask) {
            HandledTask task = (HandledTask)vo;
            instId = task.getProcInstId();
            taskId = task.getId();
            ownerId = task.getAssigneeId();
            ownerName = task.getAssigneeName();
        } else if (vo instanceof String) {
            instId = (String)vo;
        } else if (vo instanceof InsertCallyTaskVo) {
            InsertCallyTaskVo taskVo = (InsertCallyTaskVo)vo;
            instId = taskVo.getInstanceId();
        } else if (vo instanceof FlowMessage) {
            FlowMessage msg = (FlowMessage)vo;
            instId = msg.getInstId();
            ownerId = ContextUtil.getCurrentUserId();
            ownerName = ContextUtil.getCurrentUser().getFullname();
        }
        try {
            contentStr = JsonUtil.toJson((Object)vo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bpmFlowMqLogManager.buildLog(type, subject, contentStr, status, exception, instId, taskId, ownerId, ownerName);
    }
}

