/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.service.DataObjectHandler;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BoDataUtil {
    public static void validBo(DefaultBpmProcessDefExt bpmProcessDefExt, ObjectNode jsonObj) {
        List<ProcBoDef> list = bpmProcessDefExt.getBoDefList();
        if (BeanUtils.isEmpty(list)) {
            throw new RuntimeException("\u6d41\u7a0b\u6ca1\u6709\u5b9a\u4e49Bo\u5217\u8868");
        }
        for (ProcBoDef boDef : list) {
            String name = boDef.getName();
            if (!boDef.isRequired() || JsonUtil.isContainsKey((JsonNode)jsonObj, (String)name)) continue;
            throw new RuntimeException("\u63d0\u4ea4\u6570\u636e\u4e0d\u5305\u542b:" + boDef.getName());
        }
    }

    public static Map<String, ObjectNode> getMap(ObjectNode jsonObj) {
        HashMap<String, ObjectNode> map = new HashMap<String, ObjectNode>();
        Iterator it = jsonObj.fields();
        while (it.hasNext()) {
            Map.Entry ent = (Map.Entry)it.next();
            String key = (String)ent.getKey();
            try {
                ObjectNode val = (ObjectNode)JsonUtil.toJsonNode(ent.getValue());
                map.put(key, (ObjectNode)HtJsonNodeFactory.build().htObjectNode(val));
            }
            catch (Exception exception) {}
        }
        return map;
    }

    public static ObjectNode hanlerData(String defId, List<ObjectNode> boDatas, boolean handShowData) throws Exception {
        ObjectNode jsondata = JsonUtil.getMapper().createObjectNode();
        DataObjectHandler dataObjectHandler = (DataObjectHandler)AppUtil.getBean(DataObjectHandler.class);
        if (handShowData && StringUtil.isNotEmpty((String)defId)) {
            dataObjectHandler.handShowData(defId, boDatas);
        }
        if (BeanUtils.isNotEmpty(boDatas)) {
            for (ObjectNode data : boDatas) {
                ObjectNode json = BoDataUtil.toJSON(data, true);
                String boDefCode = "";
                boDefCode = data.has("boDef") ? data.get("boDef").get("alias").asText() : data.get("boDefAlias").asText();
                jsondata.set(boDefCode, (JsonNode)json);
            }
        }
        return jsondata;
    }

    public static ObjectNode hanlerData(BpmProcessInstance instance, String nodeId, List<ObjectNode> boDatas) throws Exception {
        ObjectNode jsondata = JsonUtil.getMapper().createObjectNode();
        DataObjectHandler dataObjectHandler = (DataObjectHandler)AppUtil.getBean(DataObjectHandler.class);
        if (StringUtil.isNotEmpty((String)nodeId)) {
            dataObjectHandler.handShowData(instance, nodeId, boDatas);
        }
        BpmContextUtil.setBoToContext(boDatas);
        for (ObjectNode data : boDatas) {
            ObjectNode json = BoDataUtil.toJSON(data, true);
            String boDefCode = "";
            boDefCode = data.has("boDef") ? data.get("boDef").get("alias").asText() : data.get("boDefAlias").asText();
            jsondata.set(boDefCode, (JsonNode)json);
        }
        return jsondata;
    }

    public static Object hanlerData(List<ObjectNode> boDatas) throws IOException {
        ObjectNode jsondata = JsonUtil.getMapper().createObjectNode();
        for (ObjectNode data : boDatas) {
            ObjectNode json = BoDataUtil.toJSON(data, true);
            String boDefCode = "";
            boDefCode = data.has("boDef") ? data.get("boDef").get("alias").asText() : data.get("boDefAlias").asText();
            jsondata.set(boDefCode, (JsonNode)json);
        }
        return jsondata;
    }

    public static JsonNode transJSON(JsonNode jsonNode) {
        ObjectNode data = JsonUtil.getMapper().createObjectNode();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (jNode.isArray()) {
                boolean isCheck = false;
                if (BeanUtils.isNotEmpty((Object)jNode)) {
                    for (JsonNode fxk : jNode) {
                        if (fxk.isObject()) continue;
                        isCheck = true;
                        break;
                    }
                }
                if (!isCheck && key.toString().indexOf("sub_") > -1) {
                    String tmp = key.toString().replaceFirst("sub_", "");
                    ObjectNode subNode = (ObjectNode)data.get("subMap");
                    if (BeanUtils.isEmpty((Object)subNode)) {
                        subNode = JsonUtil.getMapper().createObjectNode();
                    }
                    subNode.set(tmp, jNode);
                    data.set("subMap", (JsonNode)subNode);
                    continue;
                }
                data.set(key, jNode);
                continue;
            }
            data.set(key, jNode);
        }
        return data;
    }

    public static ObjectNode toJSON(ObjectNode boData, boolean needInitData) throws IOException {
        HashMap<String, Map<String, Object>> initMap = new HashMap<String, Map<String, Object>>();
        ObjectNode json = BoDataUtil.toJSON(boData, initMap);
        if (needInitData) {
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            for (Map.Entry entry : initMap.entrySet()) {
                String key = (String)entry.getKey();
                ObjectNode rowJson = JsonUtil.getMapper().createObjectNode();
                for (Map.Entry row : ((Map)entry.getValue()).entrySet()) {
                    Object value = row.getValue();
                    JsonNode oNode = JsonUtil.toJsonNode(value);
                    rowJson.set((String)row.getKey(), oNode);
                }
                objectNode.set(key, (JsonNode)rowJson);
            }
            json.set("initData", (JsonNode)objectNode);
        }
        return json;
    }

    private static ObjectNode toJSON(ObjectNode boData, Map<String, Map<String, Object>> initMap) throws IOException {
        Map initDataMap;
        ObjectNode objectNode = (ObjectNode)boData.get("data");
        ObjectNode subMap = (ObjectNode)boData.get("subMap");
        if (BeanUtils.isNotEmpty((Object)subMap)) {
            Iterator fields = subMap.fields();
            while (fields.hasNext()) {
                Map.Entry next = (Map.Entry)fields.next();
                String key = (String)next.getKey();
                JsonNode jNode = (JsonNode)next.getValue();
                ArrayNode aNode = JsonUtil.getMapper().createArrayNode();
                for (JsonNode obj : jNode) {
                    ObjectNode objNode = null;
                    objNode = obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode ? (ObjectNode)obj.get("data") : (ObjectNode)obj;
                    if (BeanUtils.isNotEmpty((Object)obj.get("subMap"))) {
                        JsonNode sunNodes = obj.get("subMap");
                        Iterator sunTabFields = sunNodes.fields();
                        while (sunTabFields.hasNext()) {
                            Map.Entry nextSun = (Map.Entry)sunTabFields.next();
                            JsonNode sunValueNode = (JsonNode)nextSun.getValue();
                            if (!BeanUtils.isNotEmpty((Object)sunValueNode)) continue;
                            String sunKey = (String)nextSun.getKey();
                            ArrayNode sunNode = JsonUtil.getMapper().createArrayNode();
                            for (JsonNode sunObj : sunValueNode) {
                                if (sunObj.hasNonNull("data")) {
                                    sunNode.add(sunObj.get("data"));
                                    continue;
                                }
                                sunNode.add(sunObj);
                            }
                            objNode.set("sub_" + sunKey, (JsonNode)sunNode);
                        }
                    }
                    aNode.add((JsonNode)objNode);
                }
                objectNode.set("sub_" + key, (JsonNode)aNode);
            }
        }
        if (BeanUtils.isNotEmpty((Object)(initDataMap = JsonUtil.toMap((String)JsonUtil.toJson((Object)boData.get("initDataMap")))))) {
            initMap.putAll(initDataMap);
        }
        return objectNode;
    }

    public static String getSubPkKey(List<ObjectNode> boDatas, String subEntAlias) {
        String result = "id_";
        if (StringUtil.isEmpty((String)subEntAlias)) {
            return result;
        }
        block0: for (ObjectNode objectNode : boDatas) {
            JsonNode childEnts = objectNode.get("boEnt").get("childEnts");
            if (!BeanUtils.isNotEmpty((Object)childEnts)) continue;
            for (JsonNode jsonNode : childEnts) {
                ObjectNode childEnt = (ObjectNode)jsonNode;
                String name = childEnt.get("name").asText();
                if (!subEntAlias.equalsIgnoreCase(name)) continue;
                if (childEnt.get("pkKey") == null || !StringUtil.isNotEmpty((String)childEnt.get("pkKey").asText())) continue block0;
                result = childEnt.get("pkKey").asText();
                continue block0;
            }
        }
        return result;
    }

    public static List<ObjectNode> emptyFkAndPk(List<ObjectNode> boDatas) {
        for (ObjectNode objectNode : boDatas) {
            String fk = objectNode.get("boEnt").get("fk").asText();
            String pkKey = objectNode.get("boEnt").get("pkKey").asText();
            ObjectNode data = (ObjectNode)objectNode.get("data");
            data.remove(fk);
            data.remove(pkKey);
            JsonNode subMap = objectNode.get("subMap");
            JsonNode childEnts = objectNode.get("boEnt").get("childEnts");
            BoDataUtil.disposeSub(subMap, childEnts);
        }
        return boDatas;
    }

    private static void disposeSub(JsonNode subMap, JsonNode childEnts) {
        if (BeanUtils.isNotEmpty((Object)subMap) && BeanUtils.isNotEmpty((Object)childEnts)) {
            for (JsonNode jsonNode : childEnts) {
                ObjectNode childEnt = (ObjectNode)jsonNode;
                String sfk = childEnt.get("fk").asText();
                String spkKey = childEnt.get("pkKey").asText();
                String name = childEnt.get("name").asText();
                JsonNode subList = subMap.get(name);
                if (!BeanUtils.isNotEmpty((Object)subList)) continue;
                for (JsonNode jsonNode2 : subList) {
                    ObjectNode jsonNode3 = (ObjectNode)jsonNode2.get("data");
                    jsonNode3.remove(sfk);
                    jsonNode3.remove(spkKey);
                    JsonNode ssubMap = jsonNode2.get("subMap");
                    JsonNode schildEnts = jsonNode.get("childEnts");
                    if (!BeanUtils.isNotEmpty((Object)ssubMap)) continue;
                    BoDataUtil.disposeSub(ssubMap, schildEnts);
                }
            }
        }
    }

    public static Map<String, ObjectNode> converBodataListToMap(List<ObjectNode> boDatas) {
        HashMap<String, ObjectNode> boMap = new HashMap<String, ObjectNode>();
        if (BeanUtils.isEmpty(boDatas)) {
            return boMap;
        }
        for (ObjectNode data : boDatas) {
            String code = "";
            code = data.hasNonNull("boDefAlias") ? data.get("boDefAlias").asText() : data.get("boDef").get("alias").asText();
            if (data.hasNonNull("data") && data.get("data").isObject()) {
                JsonNode jsonNode = data.get("data");
                HtObjectNode node = HtJsonNodeFactory.build().htObjectNode((ObjectNode)jsonNode);
                boMap.put(code, (ObjectNode)node);
                if (!data.hasNonNull("subMap")) continue;
                node.set("subMap", data.get("subMap"));
                continue;
            }
            boMap.put(code, (ObjectNode)HtJsonNodeFactory.build().htObjectNode(data));
        }
        return boMap;
    }

    public static List<ObjectNode> converFormData(String formData) throws IOException {
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        JsonNode jsonNode = JsonUtil.toJsonNode((String)formData);
        Iterator newSet = jsonNode.fields();
        while (newSet.hasNext()) {
            Map.Entry ent = (Map.Entry)newSet.next();
            ObjectNode objectNode = JsonUtil.createObjectNode();
            objectNode.set("data", jsonNode.get((String)ent.getKey()));
            objectNode.put("boDefAlias", (String)ent.getKey());
            result.add(objectNode);
        }
        return result;
    }
}

