/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.codegen.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.hotent.bpmx.codegen.config.DsConfig;
import com.hotent.bpmx.codegen.model.GeneratorModel;
import com.hotent.bpmx.codegen.util.CodeGeneratorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.boot.SpringBootVersion;
import org.springframework.util.Assert;

public class MybatisPlusGeneratorService {
    public static void generator(GeneratorModel generatorModel, DsConfig dsConfig) {
        AutoGenerator gen = new AutoGenerator();
        gen.setDataSource(MybatisPlusGeneratorService.getDataSource(dsConfig));
        String position = generatorModel.getPosition().replace("/", File.separator).replace("\\", File.separator);
        gen.setGlobalConfig(MybatisPlusGeneratorService.getGlobalConfig(position, generatorModel));
        gen.setStrategy(MybatisPlusGeneratorService.getStrategyConfig(generatorModel.getTableName()));
        gen.setPackageInfo(MybatisPlusGeneratorService.getPackageConfig(generatorModel.getBasePackage(), generatorModel.getModuleName()));
        gen.setCfg(MybatisPlusGeneratorService.getInjectionConfig(position, generatorModel, gen));
        gen.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        gen.setTemplate(MybatisPlusGeneratorService.getTemplateConfig());
        gen.execute();
    }

    private static DataSourceConfig getDataSource(DsConfig dsConfig) {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUrl(dsConfig.getUrl());
        dataSourceConfig.setDbType(dsConfig.getDbType());
        dataSourceConfig.setDriverName(dsConfig.getDriverName());
        dataSourceConfig.setUsername(dsConfig.getUsername());
        dataSourceConfig.setPassword(dsConfig.getPassword());
        return dataSourceConfig;
    }

    private static GlobalConfig getGlobalConfig(String baseProjectPath, GeneratorModel generatorModel) {
        GlobalConfig globalConfig = new GlobalConfig().setOutputDir(String.format("%s%s", baseProjectPath, "/src/main/java".replace("/", File.separator))).setFileOverride(true).setActiveRecord(true).setEnableCache(false).setBaseResultMap(true).setBaseColumnList(true).setOpen(false).setAuthor(generatorModel.getAuthorName()).setSwagger2(true).setIdType(IdType.ASSIGN_ID).setEntityName("%sEntity").setMapperName("%sManager").setXmlName("%sMapper").setServiceName("%sService").setServiceImplName("%sServiceImpl").setControllerName("%sController");
        return globalConfig;
    }

    private static StrategyConfig getStrategyConfig(String ... tableNames) {
        return new StrategyConfig().setVersionFieldName("REV_").setTablePrefix(new String[]{"bpmx_"}).setControllerMappingHyphenStyle(true).setNaming(NamingStrategy.underline_to_camel).setEntityBooleanColumnRemoveIsPrefix(true).setInclude(tableNames).setRestControllerStyle(true).setSuperEntityClass("com.hotent.bpmx.core.persistence.entity.BpmxBaseEntity").setSuperMapperClass("com.hotent.bpmx.core.persistence.manager.BpmxAbstractManager").setSuperServiceClass("com.hotent.bpmx.core.service.BpmxBaseService").setSuperServiceImplClass("com.hotent.bpmx.core.service.impl.BpmxBaseServiceImpl").setSuperControllerClass("com.hotent.bpmx.core.controller.BpmxController");
    }

    private static PackageConfig getPackageConfig(String basePackage, String moduleName) {
        Assert.isTrue((boolean)StrUtil.isNotEmpty((CharSequence)basePackage), (String)"\u57fa\u7840\u5305\u8def\u5f84(BasePackage)\u4e0d\u80fd\u4e3a\u7a7a");
        return new PackageConfig().setParent(basePackage).setModuleName(moduleName).setController("controller").setEntity("persistence.entity").setMapper("persistence.manager").setService("service").setServiceImpl("service.impl").setXml("mapper");
    }

    private static InjectionConfig getInjectionConfig(String baseProjectPath, final GeneratorModel generatorModel, AutoGenerator gen) {
        InjectionConfig injectionConfig = new InjectionConfig(){

            public void initMap() {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                String authorEmail = generatorModel.getAuthorEmail();
                String companyName = generatorModel.getCompanyName();
                if (StrUtil.isNotEmpty((CharSequence)authorEmail)) {
                    map.put("authorEmail", authorEmail);
                }
                if (StrUtil.isNotEmpty((CharSequence)companyName)) {
                    map.put("companyName", companyName);
                }
                map.put("springbootVersion", SpringBootVersion.getVersion());
                map.put("cgUtil", new CodeGeneratorUtil());
                map.put("voPackage", generatorModel.getBasePackage() + ".vo");
                map.put("convertPackage", generatorModel.getBasePackage() + ".mapstruct");
                this.setMap(map);
            }
        };
        MybatisPlusGeneratorService.setFileOutConfig(baseProjectPath, generatorModel, injectionConfig);
        return injectionConfig;
    }

    private static void setFileOutConfig(final String baseProjectPath, final GeneratorModel generatorModel, InjectionConfig injectionConfig) {
        String tamplatePath = "/template/codegen/mapper.xml.ftl";
        ArrayList<FileOutConfig> fileOutList = new ArrayList<FileOutConfig>();
        fileOutList.add(new FileOutConfig(tamplatePath){

            public String outputFile(TableInfo tableInfo) {
                return baseProjectPath + "/src/main/resources/mapper/".replace("/", File.separator) + CodeGeneratorUtil.cutOutTail(tableInfo.getEntityName()) + "Mapper.xml";
            }
        });
        fileOutList.add(new FileOutConfig("/template/codegen/vo.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return baseProjectPath + "/src/main/java/".replace("/", File.separator) + generatorModel.getBasePackage().replace(".", File.separator) + File.separator + "vo" + File.separator + CodeGeneratorUtil.cutOutTail(tableInfo.getEntityName()) + "VO.java";
            }
        });
        fileOutList.add(new FileOutConfig("/template/codegen/entityConvert.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return baseProjectPath + "/src/main/java/".replace("/", File.separator) + generatorModel.getBasePackage().replace(".", File.separator) + File.separator + "mapstruct" + File.separator + tableInfo.getEntityName() + "Convert.java";
            }
        });
        injectionConfig.setFileOutConfigList(fileOutList);
    }

    private static TemplateConfig getTemplateConfig() {
        return new TemplateConfig().setXml(null).setController("template/codegen/controller.java").setEntity("template/codegen/entity.java").setMapper("template/codegen/mapper.java").setService("template/codegen/service.java").setServiceImpl("template/codegen/serviceImpl.java");
    }
}

