/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.codegen.util;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CodeGeneratorUtil {
    public static final String TABLE_PREFIX = "";
    private static final String TAIL = "Entity";
    private static final List<String> ENTITY_BASE_FIELDS = Arrays.asList("id", "createdBy", "createdByName", "createdByOrgId", "", "createdTime", "updatedBy", "updatedByOrgId", "updatedByName", "updatedTime", "tenantId");
    private static final List<String> ENTIT_INSERT_FIELDS = Arrays.asList("id", "createdBy", "createdByName", "createdByOrgId", "", "createdTime", "tenantId");

    public static String cutOutTail(String entityName) {
        return entityName.substring(0, entityName.indexOf(TAIL));
    }

    public static String removeSufix(String str, int length) {
        return str.substring(0, str.length() - length);
    }

    public static String cutTableNamePrefix(String tableName) {
        tableName = tableName.toLowerCase();
        return tableName.replace(TABLE_PREFIX, TABLE_PREFIX);
    }

    public static String underlineToCamel(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return TABLE_PREFIX;
        }
        String temp = param.toLowerCase();
        int len = temp.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean isBaseField(String field) {
        return ENTITY_BASE_FIELDS.contains(field);
    }

    public boolean notBaseField(String field) {
        return !ENTITY_BASE_FIELDS.contains(field);
    }

    public boolean isInsertField(String field) {
        return ENTIT_INSERT_FIELDS.contains(field);
    }

    public List<TableField> filterInsertField(List<TableField> fields) {
        return fields.stream().filter(predicate -> !ENTIT_INSERT_FIELDS.contains(predicate.getPropertyName())).collect(Collectors.toList());
    }
}

