package ${package.Entity};

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import com.hotent.bpmx.core.persistence.entity.BpmxBaseEntity;
import java.util.HashMap;
import java.util.Map;
<#if entityLombokModel>
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
</#if>
import com.fasterxml.jackson.annotation.JsonProperty;
/**
 * ${table.comment!}
 *
 <#if cfg.companyName??>
 * @company ${cfg.companyName}
 </#if>
 * @author ${author}
 <#if cfg.authorEmail??>
 * @email ${cfg.authorEmail}
 </#if>
 * @since ${date}
 */
<#if entityLombokModel>
@Data
    <#if superEntityClass??>
@EqualsAndHashCode(callSuper = true)
    <#else>
@EqualsAndHashCode(callSuper = false)
    </#if>
@Accessors(chain = true)
</#if>
<#if swagger2>
@Schema(name="${entity}对象", description="${table.comment!}")
</#if>
<#if superEntityClass??>
public class ${entity} extends ${superEntityClass} {
<#elseif activeRecord>
public class ${entity} extends Model<${entity}> {
<#else>
public class ${entity} implements Serializable {
</#if>
<#if entitySerialVersionUID>
    private static final long serialVersionUID = 1L;

</#if>
<#-- ----------  BEGIN 字段循环遍历  ---------->
<#list table.fields as field>
    <#if cfg.cgUtil.notBaseField(field.propertyName)>
    <#if field.keyFlag>
        <#assign keyPropertyName="${field.propertyName}"/>
    </#if>
	<#assign propertyName>${field.propertyName}</#assign>
    <#if field.comment!?length gt 0>
        <#if swagger2>
    @Schema(description = "${field.comment}")
        <#else>
    /**
     * ${field.comment}
     */
        </#if>
    </#if>
    @JsonProperty("${propertyName}")
    private ${field.propertyType} ${propertyName};

    </#if>
</#list>
<#------------  END 字段循环遍历  ---------->

<#if !entityLombokModel>
    <#list table.fields as field>
        <#if cfg.cgUtil.notBaseField(field.propertyName)>
            <#if field.propertyType == "boolean">
                <#assign getprefix="is"/>
            <#else>
                <#assign getprefix="get"/>
            </#if>
            <#assign propertyName>${field.propertyName}</#assign>
    public ${field.propertyType} ${getprefix}${propertyName?cap_first}() {
        return ${propertyName};
    }

            <#if entityBuilderModel>
    public ${entity} set${propertyName?cap_first}(${field.propertyType} ${propertyName}) {
            <#else>
    public void set${propertyName?cap_first}(${field.propertyType} ${propertyName}) {
            </#if>
        this.${propertyName} = ${propertyName};
            <#if entityBuilderModel>
        return this;
            </#if>
    }
        </#if>
    </#list>
</#if>

<#if entityColumnConstant>
    <#list table.fields as field>
    public static final String ${field.name?upper_case} = "${field.name}";

    </#list>
</#if>

    @Override
    @JsonIgnore
    public Object getPersistentState() {
        Map<String, Object> state = new HashMap<String, Object>();
    <#list table.fields as field>
        <#if cfg.cgUtil.notBaseField(field.propertyName)>
        state.put("${field.propertyName}", ${field.propertyName});
        </#if>
    </#list>
        return state;
    }
<#if versionFieldName??>

    @Override
    @JsonIgnore
    public int getRevisionNext() {
        return ${cfg.cgUtil.underlineToCamel(versionFieldName)} + 1;
    }

    @Override
    @JsonIgnore
    public int getRevision() {
        return  ${cfg.cgUtil.underlineToCamel(versionFieldName)};
    }

    @Override
    public void setRevision(int revision) {
        this.${cfg.cgUtil.underlineToCamel(versionFieldName)} = revision;
    }
</#if>

<#if !entityLombokModel>
    @Override
    public String toString() {
        return "${entity}{" +
    <#list table.fields as field>
    <#assign propertyName>${field.propertyName}</#assign>
        <#if field_index==0>
            "${propertyName}=" + ${propertyName} +
        <#else>
            ", ${propertyName}=" + ${propertyName} +
        </#if>
    </#list>
        "}";
    }
</#if>
}
