<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">
<mapper namespace="${package.Entity}.${entity}">
<#if baseResultMap>
    <!-- 通用查询映射结果 -->
    <resultMap id="${cfg.cgUtil.cutOutTail(entity)}ResultMap" type="${package.Entity}.${entity}">
<#list table.fields as field>
<#if field.keyFlag><#--生成主键排在第一位-->
        <id column="${field.name}" property="${field.propertyName}" />
</#if>
</#list>
<#list table.commonFields as field><#--生成公共字段 -->
	<#assign propertyName>${field.propertyName}</#assign>
    	<result column="${field.name}" property="${propertyName}" />
</#list>
<#list table.fields as field>
<#if !field.keyFlag><#--生成普通字段 -->
	<#assign propertyName>${field.propertyName}</#assign>
    	<result column="${field.name}" property="${propertyName}" />
</#if>
</#list>
    </resultMap>

</#if>
<#if baseColumnList>
    <sql id="Base_Column_List">
        ${table.fieldNames}
    </sql>
</#if>

	<insert id="insert${cfg.cgUtil.cutOutTail(entity)}" parameterType="${package.Entity}.${entity}">
		insert into <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)} (${table.fieldNames})
		values (
		<#list table.fields as field>
			<#if field.propertyName == cfg.cgUtil.underlineToCamel(versionFieldName)>
				1<#if field_has_next>,</#if>
			<#else >
				<#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse><#if field_has_next>,</#if>
			</#if>
		</#list>
		)
	</insert>

	<update id="update${cfg.cgUtil.cutOutTail(entity)}" parameterType="${package.Entity}.${entity}">
		update <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)} set
		<#list cfg.cgUtil.filterInsertField(table.fields) as field>
			<#if !field.keyFlag>
				<#if field.propertyName == cfg.cgUtil.underlineToCamel(versionFieldName)>
					${field.name} = <#noparse>#{revisionNext ,jdbcType=INTEGER}</#noparse><#if field_has_next>,</#if>
				<#else >
					${field.name} = <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse><#if field_has_next>,</#if>
				</#if>
			</#if>
		</#list>
		where
		<#list table.fields as field>
			<#if field.keyFlag>
			${field.name} = <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse>
			</#if>
			<#if field.propertyName == cfg.cgUtil.underlineToCamel(versionFieldName)>
			and ${versionFieldName} = <#noparse>#{revision ,jdbcType=INTEGER}</#noparse>
			</#if>
		</#list>
	</update>

	<delete id="delete${cfg.cgUtil.cutOutTail(entity)}" parameterType="${package.Entity}.${entity}">
		delete from <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)}
		where
		<#list table.fields as field>
			<#if field.keyFlag>
			${field.name} = <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse>
			</#if>
			<#if field.propertyName == cfg.cgUtil.underlineToCamel(versionFieldName)>
			and ${versionFieldName} = <#noparse>#{revision ,jdbcType=INTEGER}</#noparse>
			</#if>
		</#list>
	</delete>

	<select id="select${cfg.cgUtil.cutOutTail(entity)}" parameterType="string" resultMap="${cfg.cgUtil.cutOutTail(entity)}ResultMap">
		select * from <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)}
		where
		<#list table.fields as field>
			<#if field.keyFlag>
			${field.name} = <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse>
			</#if>
		</#list>
	</select>

	<select id="query${cfg.cgUtil.cutOutTail(entity)}ByQueryCriteria" parameterType="com.hotent.bpmx.core.service.impl.BpmxQueryImpl" resultMap="${cfg.cgUtil.cutOutTail(entity)}ResultMap">
		<include refid="org.camunda.bpm.engine.impl.persistence.entity.Commons.bindOrderBy"/>
		<#noparse>${limitBefore}</#noparse>
		select <#noparse>${distinct}</#noparse> RES.*
		<#noparse>${limitBetween}</#noparse>
		<include refid="query${cfg.cgUtil.cutOutTail(entity)}ByQueryCriteriaSql"/>
		<#noparse>${orderBy}</#noparse>
		<#noparse>${limitAfter}</#noparse>
	</select>

	<select id="query${cfg.cgUtil.cutOutTail(entity)}CountByQueryCriteria" parameterType="com.hotent.bpmx.core.service.impl.BpmxQueryImpl" resultType="long">
		<#noparse>${countDistinctBeforeStart} RES.ID_ ${countDistinctBeforeEnd}</#noparse>
		<include refid="query${cfg.cgUtil.cutOutTail(entity)}ByQueryCriteriaSql" />
		<#noparse>${countDistinctAfterEnd}</#noparse>
	</select>

	<sql id="query${cfg.cgUtil.cutOutTail(entity)}ByQueryCriteriaSql">
		from <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)} RES
		<#noparse><where>
			<if test="id != null">
				RES.ID_ = #{id}
			</if>
			<if test="whereSql != null">
				and ${whereSql}
			</if>
			<include refid="org.camunda.bpm.engine.impl.persistence.entity.TenantEntity.queryTenantCheck" />
		</where></#noparse>
	</sql>

	<!-- 新增基础的方法  -->
	<delete id="removeIds${cfg.cgUtil.cutOutTail(entity)}" parameterType="string">
		delete from <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)}  where ID_ in
		<foreach collection="ids" item="id" open="(" close=")" separator=",">
			<#noparse>#{id}</#noparse>
		</foreach>
	</delete>

	<!-- 新增基础的方法  -->
	<delete id="remove${cfg.cgUtil.cutOutTail(entity)}" parameterType="string">
		delete from <#noparse>${prefix}</#noparse>${cfg.cgUtil.cutTableNamePrefix(table.name)}  where ID_ = <#noparse>#{id}</#noparse>
	</delete>

</mapper>
