package ${cfg.voPackage};

import io.swagger.v3.oas.annotations.media.Schema;

<#if entityLombokModel>
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
</#if>
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
/**
 * ${table.comment!} VO
 *
 <#if cfg.companyName??>
 * @company ${cfg.companyName}
 </#if>
 * @author ${author}
 <#if cfg.authorEmail??>
 * @email ${cfg.authorEmail}
 </#if>
 * @since ${date}
 */
<#if entityLombokModel>
@Data
    <#if superEntityClass??>
@EqualsAndHashCode(callSuper = true)
    <#else>
@EqualsAndHashCode(callSuper = false)
    </#if>
@Accessors(chain = true)
</#if>
<#if swagger2>
@Schema(name="${table.comment!}VO", description="${table.comment!}VO")
</#if>
public class ${cfg.cgUtil.cutOutTail(entity)}VO implements Serializable {
<#if entitySerialVersionUID>
    private static final long serialVersionUID = 1L;

</#if>
    @Schema(description = "主键")
    @JsonProperty("id")
    protected String id;

<#-- ----------  BEGIN 字段循环遍历  ---------->
<#list table.fields as field>
    <#if cfg.cgUtil.notBaseField(field.propertyName)>
    <#if field.keyFlag>
        <#assign keyPropertyName="${field.propertyName}"/>
    </#if>
	<#assign propertyName>${field.propertyName}</#assign>
    <#if field.comment!?length gt 0>
        <#if swagger2>
    @Schema(description = "${field.comment}")
        <#else>
    /**
     * ${field.comment}
     */
        </#if>
    </#if>
    @JsonProperty("${propertyName}")
    private ${field.propertyType} ${propertyName};

    </#if>
</#list>
<#if !entityLombokModel>
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
</#if>
<#------------  END 字段循环遍历  ---------->

<#if !entityLombokModel>
    <#list table.fields as field>
        <#if cfg.cgUtil.notBaseField(field.propertyName)>
            <#if field.propertyType == "boolean">
                <#assign getprefix="is"/>
            <#else>
                <#assign getprefix="get"/>
            </#if>
            <#assign propertyName>${field.propertyName}</#assign>
    public ${field.propertyType} ${getprefix}${propertyName?cap_first}() {
        return ${propertyName};
    }

            <#if entityBuilderModel>
    public ${entity} set${propertyName?cap_first}(${field.propertyType} ${propertyName}) {
            <#else>
    public void set${propertyName?cap_first}(${field.propertyType} ${propertyName}) {
            </#if>
        this.${propertyName} = ${propertyName};
            <#if entityBuilderModel>
        return this;
            </#if>
    }
        </#if>
    </#list>
</#if>

    @Override
    public String toString() {
        return "${cfg.cgUtil.cutOutTail(entity)}VO{" +
            "id=" + id +
    <#list table.fields as field>
    <#if cfg.cgUtil.notBaseField(field.propertyName)>
    <#assign propertyName>${field.propertyName}</#assign>
            ", ${propertyName}=" + ${propertyName} +
     </#if>
    </#list>
        "}";
    }
}
