/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.demo.controller;

import camundajar.impl.com.google.gson.JsonObject;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.hotent.base.auth.context.AuthenticationContextUtil;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.utils.IdUtil;
import com.hotent.bpmx.core.conf.BpmxSpringProcessEngineConfiguration;
import com.hotent.bpmx.core.controller.BpmxController;
import com.hotent.bpmx.core.enums.exception.BpmxResponseInfoEnums;
import com.hotent.bpmx.demo.mapstruct.DemoEntityConvert;
import com.hotent.bpmx.demo.persistence.entity.DemoEntity;
import com.hotent.bpmx.demo.service.DemoBpmxQuery;
import com.hotent.bpmx.demo.service.DemoService;
import com.hotent.bpmx.demo.vo.DemoEntityVO;
import com.hotent.bpmx.demo.vo.UrlDemoVO;
import com.hotent.uc.feign.client.dto.UserDTO;
import com.hotent.uc.feign.client.restful.UserFeignClient;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Tag(name="\u6d4b\u8bd5demo")
@RestController
@RequestMapping(value={"/demo/v1/"})
public class DemoController
extends BpmxController<DemoService, DemoEntity> {
    private static final Log log = LogFactory.get();
    @Resource
    DemoEntityConvert demoEntityConvert;
    @Resource
    BpmxSpringProcessEngineConfiguration bpmxSpringProcessEngineConfiguration;
    @Resource
    UserFeignClient userFeignClient;

    @GetMapping(value={"testExepress"})
    @Operation(summary="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e32")
    public void testExepress(@RequestParam(value="script") String script) {
        ExpressionManager expressionManager = this.bpmxSpringProcessEngineConfiguration.getExpressionManager();
        Expression expression = expressionManager.createExpression(script);
        TaskEntity variableScope = new TaskEntity();
        variableScope.setVariable("age", (Object)18);
        DemoEntity demoEntity = new DemoEntity();
        demoEntity.setId("1111");
        demoEntity.setActionName("test");
        demoEntity.setUserId("1");
        variableScope.setVariable("demoEntity", (Object)demoEntity);
        Object value = expression.getValue((VariableScope)variableScope);
        System.out.println(value);
    }

    @PostMapping(value={"testSave"})
    @Operation(summary="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e32")
    public void testSave(@RequestBody @Valid DemoEntityVO t) {
        String message = SpringUtil.getApplicationContext().getMessage("return.failed", null, LocaleContextHolder.getLocale());
        DemoEntity demoEntity = this.demoEntityConvert.vo2dto(t);
        ((DemoService)this.bpmxBaseService).testSave(demoEntity);
    }

    @GetMapping(value={"getDemoEntityById"})
    @Parameters(value={@Parameter(name="id", description="\u5b9e\u4f53id", in=ParameterIn.QUERY)})
    @Operation(summary="getDemoEntityById")
    public DemoEntity getDemoEntityById(@RequestParam String id) {
        return ((DemoService)this.bpmxBaseService).getDemoEntityById(id);
    }

    @PostMapping(value={"updateDemoEntity"})
    @Operation(summary="updateDemoEntity")
    public void updateDemoEntity(@RequestBody DemoEntity t) {
        ((DemoService)this.bpmxBaseService).updateDemoEntity(t);
    }

    @GetMapping(value={"deleteDemoEntity"})
    @Parameters(value={@Parameter(name="id", description="\u5b9e\u4f53id", in=ParameterIn.QUERY)})
    @Operation(summary="deleteDemoEntity")
    public void deleteDemoEntity(@RequestParam String id) {
        ((DemoService)this.bpmxBaseService).deleteDemoEntity(id);
    }

    @PostMapping(value={"removeByIds"})
    @Operation(summary="removeByIds")
    public void removeByIds(@RequestBody List<String> ids) {
        ((DemoService)this.bpmxBaseService).removeByIds(ids);
    }

    @PostMapping(value={"testSave2"})
    @Operation(summary="\u67e5\u8be21\u66f4\u65b01\u67e5\u8be22\u66f4\u65b02\u6d4b\u8bd5")
    @Parameters(value={@Parameter(name="id", description="\u5b9e\u4f53id", in=ParameterIn.QUERY)})
    public void testSave2(@RequestParam String id) {
        ((DemoService)this.bpmxBaseService).testSave2(id);
    }

    @PostMapping(value={"batchSave"})
    @Operation(summary="\u6279\u91cf\u63d2\u5165")
    public void batchSave(@RequestBody DemoEntity t) {
        ((DemoService)this.bpmxBaseService).batchSave(t);
    }

    @PostMapping(value={"saveBatch"})
    @Operation(summary="\u57fa\u7840\u670d\u52a1\u65b9\u6cd5-\u6279\u91cf\u63d2\u5165")
    public void saveBatch(@RequestBody List<DemoEntity> entities) {
        ((DemoService)this.bpmxBaseService).saveBatch(entities);
    }

    @PostMapping(value={"batchSaveOrUpate"})
    @Operation(summary="\u57fa\u7840\u670d\u52a1\u65b9\u6cd5-\u6279\u91cf\u63d2\u5165\u6216\u66f4\u65b0")
    public void batchSaveOrUpate(@RequestBody List<DemoEntity> entities) {
        ((DemoService)this.bpmxBaseService).saveOrUpdateBatch(entities);
    }

    @PostMapping(value={"updateBatchById"})
    @Operation(summary="\u57fa\u7840\u670d\u52a1\u65b9\u6cd5-\u6279\u91cf\u66f4\u65b0\u901a\u8fc7ID")
    public void updateBatchById(@RequestBody List<DemoEntity> entities) {
        ((DemoService)this.bpmxBaseService).saveOrUpdateBatch(entities);
    }

    @PostMapping(value={"testQuery2"})
    @Operation(summary="\u6d4b\u8bd5\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public PageList<DemoEntity> testQuery2(@RequestBody QueryFilter queryFilter) {
        PageList<DemoEntity> DemoEntityPageList = ((DemoService)this.bpmxBaseService).queryManageemo(queryFilter);
        return DemoEntityPageList;
    }

    @PutMapping(value={"/customUpdateDemo"})
    @Operation(summary="customUpdateDemo")
    @Parameters(value={@Parameter(name="id", description="\u5b9e\u4f53id", in=ParameterIn.QUERY), @Parameter(name="sentence", description="\u5e38\u7528\u8bed", in=ParameterIn.QUERY)})
    public void customUpdateDemo(@RequestParam String id, @RequestParam String sentence) {
        ((DemoService)this.bpmxBaseService).customUpdateDemo(id, sentence);
    }

    @PutMapping(value={"/customupdatePreserveOerDemo"})
    @Operation(summary="customupdatePreserveOerDemo")
    @Parameters(value={@Parameter(name="id", description="\u5b9e\u4f53id", in=ParameterIn.QUERY), @Parameter(name="sentence", description="\u5e38\u7528\u8bed", in=ParameterIn.QUERY)})
    public void customupdatePreserveOerDemo(@RequestParam String id, @RequestParam String sentence) {
        ((DemoService)this.bpmxBaseService).customupdatePreserveOerDemo(id, sentence);
    }

    @DeleteMapping(value={"/customDeleteDemo"})
    @Operation(summary="customDeleteDemo")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", in=ParameterIn.QUERY), @Parameter(name="actionName", description="\u52a8\u4f5c", in=ParameterIn.QUERY)})
    public void customDeleteDemo(@RequestParam String userId, @RequestParam String actionName) {
        ((DemoService)this.bpmxBaseService).customDeleteDemo(userId, actionName);
    }

    @DeleteMapping(value={"/customDeletePreserveOerDemo"})
    @Operation(summary="customDeletePreserveOerDemo")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", in=ParameterIn.QUERY), @Parameter(name="actionName", description="\u52a8\u4f5c", in=ParameterIn.QUERY)})
    public void customDeletePreserveOerDemo(@RequestParam String userId, @RequestParam String actionName) {
        ((DemoService)this.bpmxBaseService).customDeletePreserveOerDemo(userId, actionName);
    }

    @PostMapping(value={"testTransaction1"})
    @Operation(summary="testTransaction1")
    public void testTransaction1(@RequestBody DemoEntity t) {
        ((DemoService)this.bpmxBaseService).testTransaction1(t);
    }

    @PostMapping(value={"testTransaction2"})
    @Operation(summary="testTransaction2")
    public void testTransaction2(@RequestBody DemoEntity t) {
        ((DemoService)this.bpmxBaseService).testTransaction2(t);
    }

    @PostMapping(value={"testTransaction3"})
    @Operation(summary="testTransaction3")
    public void testTransaction3(@RequestBody DemoEntity t) {
        ((DemoService)this.bpmxBaseService).testTransaction3(t);
    }

    @GetMapping(value={"testResponseInfo"})
    @Operation(summary="testResponseInfo")
    public BpmxResponseInfoEnums testResponseInfo() {
        return BpmxResponseInfoEnums.SUCCESS_OPTION;
    }

    @GetMapping(value={"testResponseInfo2"})
    @Operation(summary="testResponseInfo2")
    public String testResponseInfo2() {
        return BpmxResponseInfoEnums.SUCCESS_OPTION.getMessage();
    }

    @GetMapping(value={"testResponseInfo3"})
    @Operation(summary="testResponseInfo3")
    public String testResponseInfo3() {
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @PostMapping(value={"testLanbdaQuery3"})
    @Operation(summary="testLanbdaQuery3")
    public List<DemoEntity> testLanbdaQuery3() {
        DemoBpmxQuery demoBpmxQuery = ((DemoService)this.bpmxBaseService).createDemoBpmxQuery();
        demoBpmxQuery.between("age_", 1, 3);
        demoBpmxQuery.clear();
        LocalDateTime now = LocalDateTime.now();
        demoBpmxQuery.between("createdTime", now.minusDays(1L), now.plusDays(1L));
        demoBpmxQuery.clear();
        demoBpmxQuery.in("age", new Object[]{1, 2, 3});
        demoBpmxQuery.clear();
        demoBpmxQuery.eq("userId", "1");
        demoBpmxQuery.clear();
        demoBpmxQuery.ne("userId", "1");
        demoBpmxQuery.clear();
        demoBpmxQuery.like("userId", "1");
        demoBpmxQuery.clear();
        demoBpmxQuery.notLike("userId", "1");
        demoBpmxQuery.clear();
        demoBpmxQuery.likeLeft("userId", "1");
        demoBpmxQuery.clear();
        demoBpmxQuery.likeRight("userId", "1");
        demoBpmxQuery.clear();
        demoBpmxQuery.ge("age", 1);
        demoBpmxQuery.gt("age", 1);
        demoBpmxQuery.clear();
        demoBpmxQuery.le("age", 1);
        demoBpmxQuery.lt("age", 1);
        return demoBpmxQuery.list();
    }

    @GetMapping(value={"/app/dsTranstion/{id}"})
    @Operation(summary="\u4e8b\u52a1\u6d4b\u8bd5", description="\u4e8b\u52a1\u6d4b\u8bd5")
    @Parameters(value={@Parameter(name="id", description="\u4e8b\u52a1\u6d4b\u8bd5", required=true, in=ParameterIn.QUERY)})
    public void dsTranstion(@PathVariable String id, HttpServletRequest request) throws Exception {
        AntPathRequestMatcher antPathMatcher = new AntPathRequestMatcher("/demo/v1/app/dsTranstion/{id}");
        boolean matches = antPathMatcher.matches(request);
        MvcRequestMatcher mvcRequestMatcher = new MvcRequestMatcher((HandlerMappingIntrospector)SpringUtil.getBean((String)"mvcHandlerMappingIntrospector", HandlerMappingIntrospector.class), "/demo/v1/app/dsTranstion/*");
        boolean matches3 = mvcRequestMatcher.matches(request);
        MvcRequestMatcher mvcRequestMatcher4 = new MvcRequestMatcher((HandlerMappingIntrospector)SpringUtil.getBean((String)"mvcHandlerMappingIntrospector", HandlerMappingIntrospector.class), "/demo/v1/app/dsTranstion/123");
        boolean matches4 = mvcRequestMatcher4.matches(request);
        ((DemoService)this.bpmxBaseService).dsTranstion(id);
    }

    @GetMapping(value={"/app/dsTranstion/123"})
    @Operation(summary="\u4e8b\u52a1\u6d4b\u8bd53", description="\u4e8b\u52a1\u6d4b\u8bd53")
    @Parameters(value={@Parameter(name="id", description="\u4e8b\u52a1\u6d4b\u8bd5", required=true, in=ParameterIn.QUERY)})
    public void dsTranstion3(@RequestParam String id, HttpServletRequest request) throws Exception {
        AsyncContext asyncContext = request.startAsync();
        AntPathRequestMatcher antPathMatcher = new AntPathRequestMatcher("/demo/v1/app/dsTranstion/{id}");
        boolean matches = antPathMatcher.matches(request);
        AntPathRequestMatcher antPathMatcher2 = new AntPathRequestMatcher("/demo/v1/app/dsTranstion/123");
        boolean matches2 = antPathMatcher2.matches(request);
        MvcRequestMatcher mvcRequestMatcher = new MvcRequestMatcher((HandlerMappingIntrospector)SpringUtil.getBean((String)"mvcHandlerMappingIntrospector", HandlerMappingIntrospector.class), "/demo/v1/app/dsTranstion/*");
        boolean matches3 = mvcRequestMatcher.matches(request);
        MvcRequestMatcher mvcRequestMatcher4 = new MvcRequestMatcher((HandlerMappingIntrospector)SpringUtil.getBean((String)"mvcHandlerMappingIntrospector", HandlerMappingIntrospector.class), "/demo/v1/app/dsTranstion/123");
        boolean matches4 = mvcRequestMatcher4.matches(request);
        ((DemoService)this.bpmxBaseService).dsTranstion(id);
    }

    @GetMapping(value={"/app/dsTranstion"})
    @Operation(summary="\u4e8b\u52a1\u6d4b\u8bd52", description="\u4e8b\u52a1\u6d4b\u8bd52")
    @Parameters(value={@Parameter(name="id", description="\u4e8b\u52a1\u6d4b\u8bd52", required=true, in=ParameterIn.QUERY)})
    public void dsTranstion2(@RequestParam String id, HttpServletRequest request) throws Exception {
        AntPathRequestMatcher antPathMatcher = new AntPathRequestMatcher("/demo/v1/app/dsTranstion");
        boolean matches = antPathMatcher.matches(request);
        ((DemoService)this.bpmxBaseService).dsTranstion(id);
    }

    @GetMapping(value={"/app/getMapDemoEntitys"})
    @Operation(summary="\u6d4b\u8bd5getMapDemoEntitys", description="getMapDemoEntitys")
    public void getMapDemoEntitys() throws Exception {
        ((DemoService)this.bpmxBaseService).getMapDemoEntitys("id");
    }

    @PostMapping(value={"testSaveBusData"})
    @Operation(summary="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e32")
    public CommonResult<String> testSaveBusData(@RequestBody JsonObject busData) {
        log.info("\u4e1a\u52a1\u8868\u5355\u6570\u636e", new Object[]{busData.toString()});
        return CommonResult.ok().value((Object)IdUtil.nextId());
    }

    @PostMapping(value={"testOpenApi"})
    @Operation(summary="\u6a21\u62df\u5916\u90e8\u7cfb\u7edf\u8c03\u7528")
    public CommonResult<String> testOpenApi(@RequestBody UrlDemoVO urlDemoVO) {
        log.info("\u4e1a\u52a1\u8868\u5355\u6570\u636e", new Object[]{urlDemoVO.toString()});
        AuthenticationContextUtil.switchAuthentication((String)urlDemoVO.getQjr());
        UserDTO byId = this.userFeignClient.getById("1");
        log.info("\u4e1a\u52a1\u8868\u5355\u6570\u636e", new Object[]{byId});
        return CommonResult.ok().value((Object)IdUtil.nextId());
    }
}

