/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.demo.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.bpmx.demo.service.AuthenticationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Tag(name="MockController")
@RestController
@RequestMapping(value={"/"})
public class MockController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Resource
    AuthenticationService authenticationService;

    @GetMapping(value={"/getAsyncRoutes2"})
    @Operation(summary="getAsyncRoutes2")
    public JsonNode getAsyncRoutes() throws IOException {
        return this.authenticationService.getAsyncRoutes();
    }

    @GetMapping(value={"/getAllUrl"})
    @Operation(summary="getAllUrl")
    public List<Map<String, String>> getAllUrl() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)SpringUtil.getBean(RequestMappingHandlerMapping.class);
        Map handlerMethods = mapping.getHandlerMethods();
        BiConsumer<RequestMappingInfo, HandlerMethod> requestMappingInfoHandlerMethodBiConsumer = (requestMappingInfo, handlerMethod) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            Set patterns = requestMappingInfo.getPatternValues();
            requestMappingInfo.getPatternValues();
            map.put("applicationName", this.applicationName);
            map.put("className", handlerMethod.getMethod().getDeclaringClass().getName());
            map.put("methodName", handlerMethod.getMethod().getName());
            Operation annotation = handlerMethod.getMethod().getAnnotation(Operation.class);
            if (annotation != null) {
                String description = annotation.description();
                String desc = annotation.summary();
                if (StrUtil.isNotEmpty((CharSequence)description)) {
                    desc = description;
                }
                map.put("desc", desc);
            }
            RequestMethodsRequestCondition methodsCondition = requestMappingInfo.getMethodsCondition();
            Set methods = methodsCondition.getMethods();
            for (String pattern : patterns) {
                HashMap<String, String> urlMap = new HashMap<String, String>(map);
                urlMap.put("url", pattern);
                for (RequestMethod method : methods) {
                    HashMap<String, String> methodMap = new HashMap<String, String>(urlMap);
                    methodMap.put("requestMethod", method.name());
                    list.add(methodMap);
                }
            }
        };
        handlerMethods.forEach(requestMappingInfoHandlerMethodBiConsumer);
        return list;
    }
}

