/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.demo.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.core.utils.JsonUtil;
import com.hotent.bpmx.demo.service.AuthenticationService;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.Objects;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    @Resource
    AuthenticationManager authenticationManager;

    @Override
    public JsonNode getAsyncRoutes() throws IOException {
        ArrayNode arrayNode = JsonUtil.createArrayNode();
        ObjectNode permissionRouter = JsonUtil.createObjectNode();
        permissionRouter.put("path", "/permission");
        ObjectNode meta = JsonUtil.createObjectNode();
        meta.put("title", "menus.permission");
        meta.put("icon", "lollipop");
        meta.put("rank", 10);
        permissionRouter.set("meta", (JsonNode)meta);
        ArrayNode permissionRouterChildren = JsonUtil.createArrayNode();
        permissionRouterChildren.add((JsonNode)AuthenticationServiceImpl.createMenu("/permission/page/index", "PermissionPage", "menus.permissionPage"));
        permissionRouterChildren.add((JsonNode)AuthenticationServiceImpl.createMenu("/permission/button/index", "PermissionButton", "menus.permissionButton"));
        permissionRouter.set("children", (JsonNode)permissionRouterChildren);
        arrayNode.add((JsonNode)permissionRouter);
        ObjectNode pageRouter = JsonUtil.createObjectNode();
        pageRouter.put("path", "/admin/page");
        ObjectNode pageRouterMeta = JsonUtil.createObjectNode();
        pageRouterMeta.put("title", "\u793a\u4f8b\u9875\u9762");
        pageRouterMeta.put("icon", "flowchart");
        pageRouterMeta.put("rank", 11);
        pageRouterMeta.put("transfer", true);
        pageRouter.set("meta", (JsonNode)pageRouterMeta);
        ArrayNode pageRouterChildren = JsonUtil.createArrayNode();
        pageRouterChildren.add((JsonNode)AuthenticationServiceImpl.createMenu("/admin/page/demo1", "demo1", "\u9875\u97621"));
        pageRouterChildren.add((JsonNode)AuthenticationServiceImpl.createMenu("/admin/page/demo2", "demo2", "\u9875\u97622"));
        pageRouter.set("children", (JsonNode)pageRouterChildren);
        arrayNode.add((JsonNode)pageRouter);
        ObjectNode flowRouter = JsonUtil.createObjectNode();
        flowRouter.put("path", "/bpmx");
        ObjectNode flowRouterMeta = JsonUtil.createObjectNode();
        flowRouterMeta.put("title", "\u6d41\u7a0b\u4e2d\u5fc3");
        flowRouterMeta.put("icon", "flowchart");
        flowRouterMeta.put("rank", 11);
        flowRouterMeta.put("transfer", true);
        flowRouter.set("meta", (JsonNode)flowRouterMeta);
        ArrayNode children = JsonUtil.createArrayNode();
        children.add((JsonNode)AuthenticationServiceImpl.createMenu("/bpmx/process/decision-definition-list", "decision-definition-list", "\u51b3\u7b56\u6a21\u578b\u7ba1\u7406"));
        children.add((JsonNode)AuthenticationServiceImpl.createMenu("/bpmx/process/def-list", "def-list", "\u6d41\u7a0b\u7ba1\u7406"));
        children.add((JsonNode)AuthenticationServiceImpl.createMenu("/bpmx/flow/instance-manager", "instance-manager", "\u5b9e\u4f8b\u7ba1\u7406"));
        children.add((JsonNode)AuthenticationServiceImpl.createMenu("/bpmx/flow/task-manager", "task-manager", "\u4efb\u52a1\u7ba1\u7406"));
        flowRouter.set("children", (JsonNode)children);
        arrayNode.add((JsonNode)flowRouter);
        return arrayNode;
    }

    private static ObjectNode createMenu(String path, String name, String title) {
        ObjectNode childrenItem = JsonUtil.createObjectNode();
        childrenItem.put("path", path);
        childrenItem.put("name", name);
        ObjectNode childrenItemMeta = JsonUtil.createObjectNode();
        childrenItemMeta.put("title", title);
        childrenItemMeta.put("transfer", true);
        childrenItem.set("meta", (JsonNode)childrenItemMeta);
        return childrenItem;
    }

    private void authenticate(String username, String password) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }
}

