/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.identity.uc.security.filter;

import com.hotent.uc.feign.client.model.BaseUser;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.springframework.security.core.context.SecurityContextHolder;

public class StatelessUserAuthenticationFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String userId = "1";
        List groupIds = List.of("1", "2");
        List<String> tenantIds = List.of("-1");
        if (principal instanceof BaseUser) {
            BaseUser baseUser = (BaseUser)principal;
            userId = baseUser.getUserId();
            groupIds = baseUser.getGroupIds();
            tenantIds = Collections.singletonList(baseUser.getTenantId());
        }
        try {
            engine.getIdentityService().setAuthentication(userId, groupIds, tenantIds);
            chain.doFilter(request, response);
        }
        finally {
            this.clearAuthentication(engine);
        }
    }

    public void destroy() {
    }

    private void clearAuthentication(ProcessEngine engine) {
        engine.getIdentityService().clearAuthentication();
    }
}

