/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.autoconfigure;

import com.hotent.base.core.context.BaseContext;
import com.hotent.base.core.properties.BaseDataPermissionProperties;
import com.hotent.bpmx.mybatisplus.plugins.MybatisPlusInterceptor;
import com.hotent.bpmx.mybatisplus.plugins.handler.impl.MultiDataPermissionHandlerImpl;
import com.hotent.bpmx.mybatisplus.plugins.inner.DataPermissionInterceptor;
import com.hotent.bpmx.mybatisplus.plugins.inner.TenantLineInnerInterceptor;
import com.hotent.bpmx.mybatisplus.tenant.handler.MultiTenantHandler;
import com.hotent.bpmx.mybatisplus.tenant.properties.TenantProperty;
import jakarta.annotation.Resource;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={TenantProperty.class})
public class BpmxMybatisPlusAutoConfigure {
    @Resource
    BaseDataPermissionProperties baseDataPermissionProperties;

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor(TenantProperty tenantProperty, BaseContext baseContext) {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        if (this.baseDataPermissionProperties.isEnabled()) {
            DataPermissionInterceptor dataPermissionInterceptor = new DataPermissionInterceptor();
            dataPermissionInterceptor.setDataPermissionHandler(new MultiDataPermissionHandlerImpl());
            mybatisPlusInterceptor.addInnerInterceptor(dataPermissionInterceptor);
        }
        if (Boolean.TRUE.equals(tenantProperty.isEnabled())) {
            mybatisPlusInterceptor.addInnerInterceptor(new TenantLineInnerInterceptor(new MultiTenantHandler(tenantProperty, baseContext)));
        }
        return mybatisPlusInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.put("Oracle", "oracle");
        properties.put("MySQL", "mysql");
        properties.put("H2", "h2");
        properties.put("SQLServer", "sqlserver");
        properties.put("PostgreSQL", "pg");
        properties.put("DM DBMS", "oracle");
        properties.put("KingbaseES", "oracle");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionFactory transactionFactory() {
        return new SpringManagedTransactionFactory();
    }
}

