/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.core;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hotent.base.core.context.BaseContext;
import com.hotent.bpmx.mybatisplus.entity.DbBaseEntity;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.SimpleTypeRegistry;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MybatisParameterHandler
implements ParameterHandler {
    public static final String ID = "id";
    public static final String CREATE_BY = "createBy";
    public static final String CREATOR_NAME = "creatorName";
    public static final String CREATE_ORG_ID = "createOrgId";
    public static final String CREATE_TIME = "createTime";
    public static final String UPDATE_BY = "updateBy";
    public static final String UPDATER_NAME = "updaterName";
    public static final String UPDATE_TIME = "updateTime";
    public static final String TENANT_ID = "tenantId";
    private final Cache<String, Boolean> entityCache = Caffeine.newBuilder().maximumSize(1024L).build();
    String COLL = "coll";
    String LIST = "list";
    String ARRAY = "array";
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final MappedStatement mappedStatement;
    private final Object parameterObject;
    private final BoundSql boundSql;
    private final Configuration configuration;
    private final SqlCommandType sqlCommandType;

    public MybatisParameterHandler(MappedStatement mappedStatement, Object parameter, BoundSql boundSql) {
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.mappedStatement = mappedStatement;
        this.boundSql = boundSql;
        this.configuration = mappedStatement.getConfiguration();
        this.sqlCommandType = mappedStatement.getSqlCommandType();
        this.parameterObject = this.processParameter(parameter);
    }

    public Object processParameter(Object parameter) {
        if (parameter != null && (SqlCommandType.INSERT == this.sqlCommandType || SqlCommandType.UPDATE == this.sqlCommandType)) {
            if (SimpleTypeRegistry.isSimpleType(parameter.getClass())) {
                return parameter;
            }
            Collection<Object> parameters = this.getParameters(parameter);
            if (null != parameters) {
                parameters.forEach(this::process);
            } else {
                this.process(parameter);
            }
        }
        return parameter;
    }

    private void tenantIdFill(Object parameter) {
        if (SqlCommandType.INSERT == this.sqlCommandType) {
            BaseContext baseContext = (BaseContext)SpringUtil.getBean(BaseContext.class);
            MetaObject metaObject = this.configuration.newMetaObject(parameter);
            if (this.hasSetTenantId(parameter)) {
                this.strictFillStrategy(metaObject, TENANT_ID, () -> ((BaseContext)baseContext).getCurrentTenantId());
            }
        }
    }

    protected boolean hasSetTenantId(Object parameter) {
        String name = parameter.getClass().getName();
        Boolean setTenantId = (Boolean)this.entityCache.get((Object)name, key -> ReflectUtil.getMethodByName(parameter.getClass(), (String)"setTenantId") != null);
        this.entityCache.put((Object)name, (Object)setTenantId);
        return setTenantId;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    private void process(Object parameter) {
        if (parameter != null) {
            if (parameter instanceof DbBaseEntity) {
                DbBaseEntity dbBaseEntity = (DbBaseEntity)parameter;
                if (SqlCommandType.INSERT == this.sqlCommandType) {
                    this.insertFill(dbBaseEntity);
                } else {
                    this.updateFill(dbBaseEntity);
                }
            } else {
                this.tenantIdFill(parameter);
            }
        }
    }

    protected void strictFillStrategy(MetaObject metaObject, String fieldName, Supplier<?> fieldVal) {
        Object obj;
        if (metaObject.getValue(fieldName) == null && Objects.nonNull(obj = fieldVal.get())) {
            metaObject.setValue(fieldName, obj);
        }
    }

    private void insertFill(DbBaseEntity dbBaseEntity) {
        BaseContext baseContext = (BaseContext)SpringUtil.getBean(BaseContext.class);
        Optional.ofNullable(dbBaseEntity.getCreatedBy()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setCreatedBy(baseContext.getCurrentUserId()));
        Optional.ofNullable(dbBaseEntity.getCreatedByName()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setCreatedByName(baseContext.getCurrentUserFullname()));
        Optional.ofNullable(dbBaseEntity.getCreatedByOrgId()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setCreatedByOrgId(baseContext.getCurrentOrgId()));
        Optional.ofNullable(dbBaseEntity.getCreatedTime()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setCreatedTime(LocalDateTime.now()));
    }

    private void updateFill(DbBaseEntity dbBaseEntity) {
        BaseContext baseContext = (BaseContext)SpringUtil.getBean(BaseContext.class);
        Optional.ofNullable(dbBaseEntity.getUpdatedBy()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setUpdatedBy(baseContext.getCurrentUserId()));
        Optional.ofNullable(dbBaseEntity.getUpdatedByOrgId()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setUpdatedByOrgId(baseContext.getCurrentOrgId()));
        Optional.ofNullable(dbBaseEntity.getUpdatedByName()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setUpdatedByName(baseContext.getCurrentUserFullname()));
        Optional.ofNullable(dbBaseEntity.getUpdatedTime()).ifPresentOrElse(u -> {}, () -> dbBaseEntity.setUpdatedTime(LocalDateTime.now()));
    }

    private Object getSetterTypeOfLocal(MetaObject metaObject, String propertyName) {
        Class targetType = metaObject.getSetterType(propertyName);
        Comparable<ChronoLocalDateTime<?>> obj = null;
        if (LocalDateTime.class.equals((Object)targetType)) {
            obj = LocalDateTime.now();
        } else if (LocalDate.class.equals((Object)targetType)) {
            obj = LocalDate.now();
        } else if (Date.class.equals((Object)targetType)) {
            obj = new Date();
        }
        return obj;
    }

    protected Collection<Object> getParameters(Object parameterObject) {
        List<Object> parameters = null;
        if (parameterObject instanceof Collection) {
            parameters = (List<Object>)parameterObject;
        } else if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            if (parameterMap.containsKey("collection")) {
                parameters = (Collection)parameterMap.get("collection");
            } else if (parameterMap.containsKey(this.COLL)) {
                parameters = (Collection)parameterMap.get(this.COLL);
            } else if (parameterMap.containsKey(this.LIST)) {
                parameters = (List)parameterMap.get(this.LIST);
            } else if (parameterMap.containsKey(this.ARRAY)) {
                parameters = Arrays.asList((Object[])parameterMap.get(this.ARRAY));
            }
        }
        return parameters;
    }

    public void setParameters(PreparedStatement ps) {
        ErrorContext.instance().activity("setting parameters").object(this.mappedStatement.getParameterMap().getId());
        List parameterMappings = this.boundSql.getParameterMappings();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (this.boundSql.hasAdditionalParameter(propertyName)) {
                    value = this.boundSql.getAdditionalParameter(propertyName);
                } else if (this.parameterObject == null) {
                    value = null;
                } else if (this.typeHandlerRegistry.hasTypeHandler(this.parameterObject.getClass())) {
                    value = this.parameterObject;
                } else {
                    MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = this.configuration.getJdbcTypeForNull();
                }
                try {
                    typeHandler.setParameter(ps, i + 1, value, jdbcType);
                    continue;
                }
                catch (SQLException | TypeException e) {
                    throw new TypeException("Could not set parameters for mapping: " + String.valueOf(parameterMapping) + ". Cause: " + String.valueOf(e), e);
                }
            }
        }
    }
}

