/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.plugins.inner;

import com.hotent.bpmx.mybatisplus.plugins.InnerInterceptor;
import com.hotent.bpmx.mybatisplus.plugins.InterceptorIgnoreHelper;
import com.hotent.bpmx.mybatisplus.plugins.handler.DataPermissionHandler;
import com.hotent.bpmx.mybatisplus.plugins.handler.MultiDataPermissionHandler;
import com.hotent.bpmx.mybatisplus.plugins.inner.BaseMultiTableInnerInterceptor;
import com.hotent.bpmx.mybatisplus.toolkit.CollectionUtils;
import com.hotent.bpmx.mybatisplus.toolkit.PluginUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class DataPermissionInterceptor
extends BaseMultiTableInnerInterceptor
implements InnerInterceptor {
    private DataPermissionHandler dataPermissionHandler;

    @Override
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreDataPermission(ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql(boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler(sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreDataPermission(ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), ms.getId()));
        }
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
        if (this.dataPermissionHandler == null) {
            return;
        }
        if (this.dataPermissionHandler instanceof MultiDataPermissionHandler) {
            String whereSegment = (String)obj;
            this.processSelectBody(select, whereSegment);
            List withItemsList = select.getWithItemsList();
            if (!CollectionUtils.isEmpty(withItemsList)) {
                withItemsList.forEach(withItem -> this.processSelectBody((Select)withItem, whereSegment));
            }
        } else if (select instanceof PlainSelect) {
            this.setWhere((PlainSelect)select, (String)obj);
        } else if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            List selectBodyList = setOperationList.getSelects();
            selectBodyList.forEach(s -> this.setWhere((PlainSelect)s, (String)obj));
        }
    }

    protected void setWhere(PlainSelect plainSelect, String whereSegment) {
        if (this.dataPermissionHandler == null) {
            return;
        }
        Expression sqlSegment = this.dataPermissionHandler.getSqlSegment(plainSelect.getWhere(), whereSegment);
        if (null != sqlSegment) {
            plainSelect.setWhere(sqlSegment);
        }
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Expression sqlSegment = this.getUpdateOrDeleteExpression(update.getTable(), update.getWhere(), (String)obj);
        if (null != sqlSegment) {
            update.setWhere(sqlSegment);
        }
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        Expression sqlSegment = this.getUpdateOrDeleteExpression(delete.getTable(), delete.getWhere(), (String)obj);
        if (null != sqlSegment) {
            delete.setWhere(sqlSegment);
        }
    }

    protected Expression getUpdateOrDeleteExpression(Table table, Expression where, String whereSegment) {
        if (this.dataPermissionHandler == null) {
            return null;
        }
        if (this.dataPermissionHandler instanceof MultiDataPermissionHandler) {
            return this.andExpression(table, where, whereSegment);
        }
        return this.dataPermissionHandler.getSqlSegment(where, whereSegment);
    }

    @Override
    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        if (this.dataPermissionHandler == null) {
            return null;
        }
        MultiDataPermissionHandler handler = (MultiDataPermissionHandler)this.dataPermissionHandler;
        return handler.getSqlSegment(table, where, whereSegment);
    }

    @Generated
    public DataPermissionHandler getDataPermissionHandler() {
        return this.dataPermissionHandler;
    }

    @Generated
    public void setDataPermissionHandler(DataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    @Generated
    public DataPermissionInterceptor() {
    }

    @Generated
    public DataPermissionInterceptor(DataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    @Generated
    public String toString() {
        return "DataPermissionInterceptor(super=" + super.toString() + ", dataPermissionHandler=" + String.valueOf(this.getDataPermissionHandler()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPermissionInterceptor)) {
            return false;
        }
        DataPermissionInterceptor other = (DataPermissionInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataPermissionHandler this$dataPermissionHandler = this.getDataPermissionHandler();
        DataPermissionHandler other$dataPermissionHandler = other.getDataPermissionHandler();
        return !(this$dataPermissionHandler == null ? other$dataPermissionHandler != null : !this$dataPermissionHandler.equals(other$dataPermissionHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataPermissionInterceptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DataPermissionHandler $dataPermissionHandler = this.getDataPermissionHandler();
        result = result * 59 + ($dataPermissionHandler == null ? 43 : $dataPermissionHandler.hashCode());
        return result;
    }
}

