/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.properties;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="bpmx.mybatis")
public class MybatisProperty {
    public static final String PREFIX = "bpmx.mybatis";
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String configLocation;
    private String[] mapperLocations = new String[]{"classpath*:/mapper/**/*.xml", "classpath*:/mapper/*.xml"};
    private String defaultScriptingLanguage = "com.hotent.bpmx.mybatisplus.core.MybatisXMLLanguageDriver";
    private String logImpl;

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public String getDefaultScriptingLanguage() {
        return this.defaultScriptingLanguage;
    }

    public void setDefaultScriptingLanguage(String defaultScriptingLanguage) {
        this.defaultScriptingLanguage = defaultScriptingLanguage;
    }

    public String getLogImpl() {
        return this.logImpl;
    }

    public void setLogImpl(String logImpl) {
        this.logImpl = logImpl;
    }

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of(Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }
}

