/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.tenant.handler;

import com.hotent.base.core.common.thread.ContextThread;
import com.hotent.base.core.context.BaseContext;
import com.hotent.bpmx.mybatisplus.plugins.handler.TenantLineHandler;
import com.hotent.bpmx.mybatisplus.tenant.constants.TenantConstant;
import com.hotent.bpmx.mybatisplus.tenant.handler.MultiTenantIgnoreResult;
import com.hotent.bpmx.mybatisplus.tenant.properties.TenantProperty;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantHandler
implements TenantLineHandler,
ContextThread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BaseContext baseContext;
    private final TenantProperty tenantProperty;
    private static ThreadLocal<Boolean> threadLocalIgnore = new ThreadLocal();

    public MultiTenantHandler(TenantProperty tenantProperty, BaseContext baseContext) {
        this.tenantProperty = tenantProperty;
        this.baseContext = baseContext;
    }

    public static MultiTenantIgnoreResult setThreadLocalIgnore() {
        threadLocalIgnore.set(true);
        return new MultiTenantIgnoreResult();
    }

    public static Boolean getThreadLocalIgnore() {
        Boolean ignoreTable = threadLocalIgnore.get();
        return Optional.ofNullable(ignoreTable).orElse(false);
    }

    public static void removeThreadLocalIgnore() {
        threadLocalIgnore.remove();
    }

    @Override
    public Expression getTenantId() {
        String tenantId = this.baseContext.getCurrentTenantId();
        this.log.debug("\u5f53\u524d\u79df\u6237\u4e3a{}", (Object)tenantId);
        if (tenantId == null) {
            return new NullValue();
        }
        return new StringValue(tenantId);
    }

    @Override
    public String getTenantIdColumn() {
        return Optional.ofNullable(this.tenantProperty.getTenantIdColumn()).orElse("tenant_id_");
    }

    @Override
    public boolean ignoreTable(String tableName) {
        if (MultiTenantHandler.getThreadLocalIgnore().booleanValue()) {
            return true;
        }
        return TenantConstant.DEFAULT_IGNORE_TABLES.stream().anyMatch(e -> e.equalsIgnoreCase(tableName)) || this.tenantProperty.getIgnoreTableNames().stream().anyMatch(e -> e.equalsIgnoreCase(tableName));
    }

    public void cleanAll() {
        MultiTenantHandler.removeThreadLocalIgnore();
    }
}

